/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunctions;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.PrefixMap;
import it.unimi.dsi.util.StringMap;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringMaps {
    private StringMaps() {
    }

    public static <T extends CharSequence> StringMap<T> synchronize(StringMap<T> stringMap) {
        return stringMap instanceof PrefixMap ? new SynchronizedPrefixMap((PrefixMap)stringMap) : new SynchronizedStringMap<T>(stringMap);
    }

    public static <T extends CharSequence> PrefixMap<T> synchronize(PrefixMap<T> prefixMap) {
        return new SynchronizedPrefixMap<T>(prefixMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SynchronizedPrefixMap<S extends CharSequence>
    extends SynchronizedStringMap<S>
    implements PrefixMap<S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final PrefixMap<S> map;
        protected Object2ObjectFunction<Interval, S> prefixMap;
        protected Object2ObjectFunction<CharSequence, Interval> rangeMap;

        public SynchronizedPrefixMap(PrefixMap<S> map) {
            super(map);
            this.map = map;
        }

        @Override
        public synchronized Object2ObjectFunction<Interval, S> prefixMap() {
            if (this.prefixMap == null) {
                this.prefixMap = this.map.prefixMap();
                if (this.prefixMap != null) {
                    this.prefixMap = Object2ObjectFunctions.synchronize(this.prefixMap, this);
                }
            }
            return this.prefixMap;
        }

        @Override
        public synchronized Object2ObjectFunction<CharSequence, Interval> rangeMap() {
            if (this.rangeMap == null) {
                this.rangeMap = this.map.rangeMap();
                if (this.rangeMap != null) {
                    this.rangeMap = Object2ObjectFunctions.synchronize(this.rangeMap, this);
                }
            }
            return this.rangeMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SynchronizedStringMap<S extends CharSequence>
    implements StringMap<S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final StringMap<S> stringMap;
        protected ObjectList<? extends S> list;

        public SynchronizedStringMap(StringMap<S> stringMap) {
            this.stringMap = stringMap;
        }

        @Override
        public synchronized int size() {
            return this.stringMap.size();
        }

        @Override
        public synchronized ObjectList<? extends S> list() {
            if (this.list == null) {
                this.list = this.stringMap.list();
                if (this.list != null) {
                    this.list = ObjectLists.synchronize(this.list, this);
                }
            }
            return this.list;
        }

        @Override
        public synchronized long getLong(Object s) {
            return this.stringMap.getLong(s);
        }

        @Override
        public synchronized Long get(Object key) {
            return (Long)this.stringMap.get(key);
        }

        @Override
        public synchronized long put(CharSequence key, long value) {
            return this.stringMap.put(key, value);
        }

        @Override
        public synchronized Long put(CharSequence key, Long value) {
            return this.stringMap.put(key, value);
        }

        @Override
        public synchronized Long remove(Object key) {
            return (Long)this.stringMap.remove(key);
        }

        @Override
        public synchronized long removeLong(Object key) {
            return this.stringMap.removeLong(key);
        }

        @Override
        public synchronized void clear() {
            this.stringMap.clear();
        }

        @Override
        public synchronized boolean containsKey(Object key) {
            return this.stringMap.containsKey(key);
        }

        @Override
        public synchronized long defaultReturnValue() {
            return this.stringMap.defaultReturnValue();
        }

        @Override
        public synchronized void defaultReturnValue(long rv) {
            this.stringMap.defaultReturnValue(rv);
        }
    }
}

