/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.util;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.ImmutableExternalPrefixMap;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import it.unimi.dsi.util.TernaryIntervalSearchTree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import test.it.unimi.dsi.util.TernaryIntervalSearchTreeTest;

public class ImmutableExternalPrefixMapTest
extends TestCase {
    public void testLargeSet(int blockSize) throws IOException {
        int j;
        int i;
        List<String> c = Arrays.asList(TernaryIntervalSearchTreeTest.WORDS);
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree(c);
        ImmutableExternalPrefixMap d = new ImmutableExternalPrefixMap(c, blockSize);
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            ImmutableExternalPrefixMapTest.assertTrue((String)TernaryIntervalSearchTreeTest.WORDS[i], (boolean)d.containsKey(TernaryIntervalSearchTreeTest.WORDS[i]));
        }
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            ImmutableExternalPrefixMapTest.assertEquals((String)TernaryIntervalSearchTreeTest.WORDS[i], (String)((MutableString)d.list().get(i)).toString());
        }
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            for (j = 0; j < TernaryIntervalSearchTreeTest.WORDS[i].length(); ++j) {
                String s = TernaryIntervalSearchTreeTest.WORDS[i].substring(0, j + 1);
                ImmutableExternalPrefixMapTest.assertEquals((String)s, t.rangeMap().get(s), (Object)d.getInterval(s));
                s = s + " ";
                ImmutableExternalPrefixMapTest.assertEquals((String)s, t.rangeMap().get(s), (Object)d.getInterval(s));
                s = s.substring(0, s.length() - 1) + "~";
                ImmutableExternalPrefixMapTest.assertEquals((String)s, t.rangeMap().get(s), (Object)d.getInterval(s));
            }
        }
        ObjectRBTreeSet p = new ObjectRBTreeSet();
        for (int i2 = 0; i2 < TernaryIntervalSearchTreeTest.WORDS.length; ++i2) {
            for (int j2 = 0; j2 < TernaryIntervalSearchTreeTest.WORDS[i2].length(); ++j2) {
                p.add(TernaryIntervalSearchTreeTest.WORDS[i2].substring(0, j2 + 1));
            }
        }
        d = new ImmutableExternalPrefixMap(p, blockSize);
        t = new TernaryIntervalSearchTree(p);
        j = 0;
        for (String s : p) {
            ImmutableExternalPrefixMapTest.assertTrue((String)s, (boolean)d.containsKey(s));
            ImmutableExternalPrefixMapTest.assertEquals((String)s, (String)((MutableString)d.list().get(j++)).toString());
            ImmutableExternalPrefixMapTest.assertEquals((String)s, t.rangeMap().get(s), (Object)d.getInterval(s));
        }
        ObjectIterator<CharSequence> k = d.iterator();
        Iterator i3 = p.iterator();
        while (i3.hasNext()) {
            ImmutableExternalPrefixMapTest.assertEquals((boolean)i3.hasNext(), (boolean)k.hasNext());
            ImmutableExternalPrefixMapTest.assertEquals((String)((String)i3.next()).toString(), (String)((Object)((CharSequence)k.next())).toString());
        }
        for (long i4 = 1000000000000L; i4 < 1000000002000L; ++i4) {
            ImmutableExternalPrefixMapTest.assertEquals((long)-1L, (long)d.getLong(Long.toBinaryString(i4)));
        }
    }

    public void testLargeSet64() throws IOException {
        this.testLargeSet(64);
    }

    public void testLargeSet128() throws IOException {
        this.testLargeSet(128);
    }

    public void testLargeSet256() throws IOException {
        this.testLargeSet(256);
    }

    public void testLargeSet1024() throws IOException {
        this.testLargeSet(1024);
    }

    public void testLargeSet16384() throws IOException {
        this.testLargeSet(16384);
    }

    public void testPrefixes() throws IOException {
        ImmutableExternalPrefixMap d = new ImmutableExternalPrefixMap(new ObjectLinkedOpenHashSet<String>(new String[]{"ab", "ba", "bb"}));
        ImmutableExternalPrefixMapTest.assertEquals((Object)Interval.valueOf(1, 2), (Object)d.getInterval("b"));
    }

    public void testLargeRootPrefixes() throws IOException {
        ImmutableExternalPrefixMap d = new ImmutableExternalPrefixMap(new ObjectLinkedOpenHashSet<String>(new String[]{"aab", "aac", "aad"}), 2);
        ImmutableExternalPrefixMapTest.assertEquals((Object)Interval.valueOf(0, 2), (Object)d.getInterval(""));
        ImmutableExternalPrefixMapTest.assertEquals((Object)Interval.valueOf(0, 2), (Object)d.getInterval("aa"));
        ImmutableExternalPrefixMapTest.assertEquals((Object)Interval.valueOf(0, 2), (Object)d.getInterval("aa"));
    }

    public void testSingleton() throws IOException {
        ImmutableExternalPrefixMap d = new ImmutableExternalPrefixMap(ObjectSets.singleton("a"), 1024);
        ImmutableExternalPrefixMapTest.assertTrue((boolean)d.containsKey("a"));
        ImmutableExternalPrefixMapTest.assertFalse((boolean)d.containsKey("b"));
        ImmutableExternalPrefixMapTest.assertFalse((boolean)d.containsKey("0"));
    }

    public void testPrefixOutOfRange() throws IOException {
        ImmutableExternalPrefixMap d = new ImmutableExternalPrefixMap(new ObjectLinkedOpenHashSet<String>(new String[]{"ab", "ac"}));
        ImmutableExternalPrefixMapTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, (Object)d.getInterval("b"));
        ImmutableExternalPrefixMapTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)d.getInterval("a"));
    }
}

