/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.FrontCodedStringList;
import it.unimi.dsi.util.LiterallySignedStringMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;

public class LiterallySignedStringMapTest
extends TestCase {
    public void testNumbers() throws IOException, ClassNotFoundException {
        for (int n = 10; n < 10000; n *= 10) {
            String[] s = new String[n];
            int i = s.length;
            while (i-- != 0) {
                s[i] = Integer.toString(i);
            }
            Collections.shuffle(Arrays.asList(s));
            FrontCodedStringList fcl = new FrontCodedStringList(Arrays.asList(s), 8, true);
            Object2LongOpenCustomHashMap<CharSequence> mph = new Object2LongOpenCustomHashMap<CharSequence>(new CharSequenceStrategy());
            mph.defaultReturnValue(-1L);
            for (int i2 = 0; i2 < s.length; ++i2) {
                mph.put((CharSequence)new MutableString(s[i2]), i2);
            }
            LiterallySignedStringMap map = new LiterallySignedStringMap(mph, fcl);
            int i3 = s.length;
            while (i3-- != 0) {
                LiterallySignedStringMapTest.assertEquals((long)i3, (long)map.getLong(s[i3]));
            }
            i3 = s.length + n;
            while (i3-- != s.length) {
                LiterallySignedStringMapTest.assertEquals((long)-1L, (long)map.getLong(Integer.toString(i3)));
            }
            File temp = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), "test");
            temp.deleteOnExit();
            BinIO.storeObject((Object)map, temp);
            map = (LiterallySignedStringMap)BinIO.loadObject(temp);
            int i4 = s.length;
            while (i4-- != 0) {
                LiterallySignedStringMapTest.assertEquals((long)i4, (long)map.getLong(s[i4]));
            }
            i4 = s.length + n;
            while (i4-- != s.length) {
                LiterallySignedStringMapTest.assertEquals((long)-1L, (long)map.getLong(Integer.toString(i4)));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CharSequenceStrategy
    implements Hash.Strategy<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CharSequenceStrategy() {
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return ((Object)a).toString().equals(((Object)b).toString());
        }

        @Override
        public int hashCode(CharSequence o) {
            return ((Object)o).toString().hashCode();
        }
    }
}

