/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import it.unimi.dsi.util.TernaryIntervalSearchTree;
import java.util.Collections;
import junit.framework.TestCase;

public class TernaryIntervalSearchTreeTest
extends TestCase {
    public static final String[] WORDS = new String[]{"0", "00", "01", "02", "0200", "03", "09", "1", "10", "100", "11", "12", "13", "14", "15", "15mb", "18", "19", "1999", "2", "20", "2000", "2003", "2004", "2430", "27", "28", "3", "30", "33", "3d", "4", "5", "50", "6", "61", "7", "7027", "8", "9", "96", "a", "abiti", "accanto", "accesso", "accordo", "ad", "addio", "adsl", "aerei", "aereo", "affari", "affitto", "aforismi", "ai", "aiuto", "al", "alan", "alcune", "alcuni", "all", "alla", "alta", "altra", "altre", "altri", "altro", "ambo", "american", "amici", "amico", "amore", "ampia", "anche", "anima", "anni", "anno", "annunci", "annuncio", "anticoncezionali", "api", "appelli", "appuntamento", "aquario", "argomento", "arianna", "arrivi", "arte", "aspettano", "assicurazioni", "aste", "auto", "autore", "autoworld", "avermi", "avrai", "avuto", "avventura", "avvocati", "avvocato", "aziendale", "aziende", "azione", "azioni", "b", "b2b", "baci", "banche", "barra", "barzelletta", "barzellette", "basket", "basta", "battute", "battutine", "bella", "belle", "bello", "bellucci", "ben", "benessere", "benvenuti", "biasimo", "bilancia", "bisogno", "bisturi", "blu", "bob", "borsa", "borse", "borsellino", "brevi", "buffe", "buona", "business", "c", "cabaret", "calcio", "calcola", "calendari", "calorie", "camera", "campeggio", "canale", "canali", "canone", "canzone", "capacit\u00e0", "capisce", "capodanno", "carabinieri", "carta", "cartoline", "cartoni", "casa", "casaclick", "case", "categorie", "cattiverie", "ce", "cellulare", "center", "centesimi", "cerca", "cercatrova", "cerchi", "champions", "chat", "che", "chi", "chiedi", "chilo", "chiuso", "cinema", "citta", "citt\u00e0", "ciunga", "classe", "classifica", "classifiche", "clicca", "cliccati", "clienti", "collegati", "collegato", "colleghi", "com", "come", "comico", "commedia", "community", "compra", "computer", "computers", "con", "conosci", "console", "consulenze", "consulti", "contattaci", "contenuti", "continua", "copyright", "corpo", "correzioni", "cortometrag", "cosa", "cose", "crea", "credito", "cronache", "cucina", "cui", "cultura", "cupido", "cv", "d", "da", "dai", "dal", "dalla", "date", "decisamente", "dei", "del", "dell", "della", "delle", "dello", "desideri", "di", "dieta", "dietro", "difficolt\u00e0", "digiland", "digitale", "directory", "diritti", "disclaimer", "discorso", "discussioni", "disposizione", "diteci", "diversi", "divertente", "divertenti", "divertimento", "divorzio", "documentario", "dom", "domanda", "domini", "donne", "dopo", "download", "drammatico", "dreamcast", "dubbi", "due", "durare", "e", "easysms", "ebay", "ecocultura", "ecommerce", "economia", "edicola", "editoria", "editoriale", "editoriali", "elenco", "elisa", "erotico", "esclusivi", "etaslab", "eterni", "eterno", "euro", "evoluzione", "excite", "express", "extra", "fa", "facile", "fai", "fantascienza", "fare", "fasi", "fatto", "febbraio", "ferro", "feste", "festival", "figli", "figlia", "figlio", "filastrocche", "files", "film", "finalmente", "finanza", "finora", "fiorellini", "fissa", "fitness", "flat", "folli", "fondi", "fortuna", "forum", "foto", "fotografia", "freddure", "free", "fumetti", "fun", "galleria", "gallerie", "gallery", "gamecube", "games", "garanzie", "gemella", "gemelli", "generale", "genere", "generi", "gente", "gi", "giallo", "gio", "gioca", "giochi", "gioco", "giornalistiche", "giorno", "giurisdizioni", "giusta", "gli", "google", "gossip", "gratis", "gratuitamente", "gratuiti", "grottesco", "guadagna", "guadagni", "guardare", "guest", "guida", "ha", "hai", "ho", "home", "hope", "horror", "hosting", "hotel", "humor", "i", "idee", "il", "immagini", "improbabile", "in", "incinta", "incontri", "indice", "indirizzi", "infernali", "informazioni", "iniziativa", "inseriti", "interagisci", "internet", "interromperti", "intrattenimento", "invia", "inwind", "iol", "irriverenti", "iscrivermi", "iscriviti", "it", "italia", "italiani", "italiaonline", "jumpy", "l", "la", "lastminute", "laurea", "lavagna", "lavatrice", "lavoro", "le", "legge", "leggendo", "leggerlo", "leggi", "libero", "libri", "life", "line", "live", "lo", "localit\u00e0", "loghi", "loro", "lotto", "lui", "lun", "luned\u00ec", "lycos", "macchine", "mai", "mail", "mailbox", "mappe", "mar", "marito", "mars", "matrimonio", "matte", "matti", "maturando", "medicoonline", "meglio", "memoria", "men\u00f9", "mer", "mercatino", "mercedes", "messo", "meteo", "mette", "mib", "mibtel", "miglior", "migliori", "milano", "mio", "misteri", "miti", "mms", "moda", "mode", "modem", "modo", "moglie", "molto", "mondo", "mostralfonso", "motori", "moviola", "mp3", "multiservizi", "musica", "musical", "mutui", "mutuo", "n64", "napoli", "nascosti", "nascosto", "nasdaq", "natura", "naviga", "nazionale", "ne", "negativo", "nel", "nella", "nelle", "neve", "news", "newsgroup", "newsletter", "nikkei", "non", "notebook", "notizie", "novita", "nuova", "nuovi", "o", "offerte", "offre", "ogni", "on", "online", "ora", "ordine", "ore", "oroscopo", "orsa", "oscar", "ottima", "ottimizza", "ovviamente", "p", "padre", "page", "palco", "panoramica", "parecchi", "parenti", "parla", "partite", "partner", "pass", "passioni", "pazze", "pc", "pena", "per", "perdere", "personal", "personalizzati", "persone", "piace", "pianeta", "piangono", "pianificare", "piatti", "picchio", "pillole", "pippo", "pippoland", "piu", "pi\u00f9", "playstation", "poesie", "polemica", "policy", "poliziesco", "pop", "porno", "porta", "positivo", "possibile", "posta", "poveri", "povert\u00e0", "praticit\u00e0", "preferenza", "preferiti", "premi", "premio", "premium", "prese", "presentaci", "prestiti", "prestito", "previsioni", "prezzi", "primo", "privacy", "problema", "prodotti", "professionale", "progetto", "promozioni", "proposte", "prostituta", "prova", "ps2", "pubblicheremo", "pubblicita", "punti", "puoi", "qualche", "qualcosa", "quelle", "quello", "questa", "queste", "questi", "questo", "qui", "raccolte", "raccontato", "radio", "rapido", "rassegna", "realizzazione", "recensioni", "recensiti", "relazione", "religione", "reserved", "responsabile", "ricchezza", "ricchi", "ricerca", "ricerche", "ricette", "ricevi", "richiedi", "ridono", "rights", "rime", "risate", "riservati", "riso", "risolti", "risparmi", "rno", "roma", "rosso", "rotta", "rubriche", "s", "sab", "sacco", "sali", "salute", "san", "saretefamosi", "sar\u00e0", "scambia", "scarica", "scaricare", "scegli", "scelta", "scelti", "scienza", "scienze", "sconosciuto", "scontati", "sconti", "scopri", "scoprilo", "scrivi", "scrivici", "se", "secondo", "segnala", "segreti", "sei", "sembrano", "sempre", "seno", "sentimentale", "sera", "serpenti", "serve", "servizi", "sessi", "settimana", "sfido", "sfortuna", "sfortunata", "shirt", "shop", "shopping", "si", "sia", "siamo", "signora", "silicone", "simpatiche", "siti", "sito", "smeraldo", "sms", "snake", "software", "sognato", "soli", "solo", "soluzione", "soluzioni", "son", "sondaggio", "sono", "sotto", "special", "speciale", "speciali", "spediscila", "spettacolari", "spicy", "sport", "srl", "sta", "stampa", "stanno", "stanza", "stasera", "stella", "stellare", "stelle", "storia", "storico", "storie", "stranafoto", "strane", "strani", "studia", "stupidario", "stupisci", "su", "sua", "subito", "successo", "sugli", "sul", "sulla", "suo", "suonerie", "suoni", "super", "supertop", "sviluppatori", "t", "tante", "tantum", "tarocco", "tassi", "te", "tecnologia", "teknosurf", "telefonia", "telefonino", "televisione", "tempo", "territorio", "testa", "thriller", "ti", "tipiche", "toccano", "top", "tra", "traduzioni", "tranquillo", "trasloca", "trasloco", "tre", "trib\u00f9", "troppo", "trova", "trovi", "trucchi", "tu", "tua", "tue", "tuo", "tuoi", "tutta", "tutte", "tutti", "tutto", "tuttocasa", "tv", "uccelli", "uffa", "ultim", "ultimi", "umoristico", "un", "una", "unico", "uomini", "uomo", "user", "utili", "vacanze", "vale", "valentino", "varie", "vasectomia", "veloce", "velocemente", "ven", "vendita", "vero", "vetrine", "via", "viaggi", "viaggiare", "viaggio", "video", "videogiochi", "vignette", "vinci", "virgilio", "virtuali", "visita", "vista", "vivere", "voglio", "voi", "volta", "vostre", "voto", "vuoi", "vuole", "wap", "web", "webmaster", "western", "www", "xbox", "yahoo", "zone"};

    private void assertContains(TernaryIntervalSearchTree t, String s, int i) {
        TernaryIntervalSearchTreeTest.assertEquals((long)i, (long)t.getLong(s));
        TernaryIntervalSearchTreeTest.assertTrue((boolean)t.containsKey(s));
    }

    private void assertDoesNotContain(TernaryIntervalSearchTree t, String s) {
        TernaryIntervalSearchTreeTest.assertEquals((long)-1L, (long)t.getLong(s));
        TernaryIntervalSearchTreeTest.assertFalse((boolean)t.containsKey(s));
    }

    public void testSingleString() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("test");
        this.assertContains(t, "test", 0);
        this.assertDoesNotContain(t, "t");
        this.assertDoesNotContain(t, "tes");
        TernaryIntervalSearchTreeTest.assertEquals((int)1, (int)t.size());
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), t.rangeMap().get("test"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), t.rangeMap().get("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), t.rangeMap().get("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), t.rangeMap().get("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, (Object)t.getApproximatedInterval("s"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), (Object)t.getApproximatedInterval("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), (Object)t.getApproximatedInterval("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.list().get(0)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
    }

    public void testForkLeft() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("test");
        t.add("tast");
        this.assertContains(t, "test", 1);
        this.assertContains(t, "tast", 0);
        this.assertDoesNotContain(t, "t");
        this.assertDoesNotContain(t, "tes");
        TernaryIntervalSearchTreeTest.assertEquals((int)2, (int)t.size());
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("test"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("ta"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("tas"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("tast"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tastx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, (Object)t.getApproximatedInterval("sz"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), (Object)t.getApproximatedInterval("tat"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("tet"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"tast", (String)((MutableString)t.list().get(0)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.list().get(1)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tast", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"t", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 1))).toString());
    }

    public void testForkRight() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("test");
        t.add("tust");
        this.assertContains(t, "test", 0);
        this.assertContains(t, "tust", 1);
        this.assertDoesNotContain(t, "t");
        this.assertDoesNotContain(t, "tes");
        TernaryIntervalSearchTreeTest.assertEquals((int)2, (int)t.size());
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tustx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("tust"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("tus"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("tu"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("test"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, (Object)t.getApproximatedInterval("ta"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, (Object)t.getApproximatedInterval("s"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), (Object)t.getApproximatedInterval("tf"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), (Object)t.getApproximatedInterval("tet"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("tut"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.list().get(0)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tust", (String)((MutableString)t.list().get(1)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tust", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"t", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 1))).toString());
    }

    public void testForkMiddle() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("te");
        t.add("test");
        this.assertContains(t, "test", 1);
        this.assertContains(t, "te", 0);
        this.assertDoesNotContain(t, "t");
        this.assertDoesNotContain(t, "tes");
        TernaryIntervalSearchTreeTest.assertEquals((int)2, (int)t.size());
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tex"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("test"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, (Object)t.getApproximatedInterval("s"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("tet"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("tt"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"te", (String)((MutableString)t.list().get(0)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.list().get(1)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"te", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"te", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 1))).toString());
    }

    public void testSplit() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("test");
        t.add("te");
        this.assertContains(t, "test", 1);
        this.assertContains(t, "te", 0);
        this.assertDoesNotContain(t, "t");
        this.assertDoesNotContain(t, "tes");
        TernaryIntervalSearchTreeTest.assertEquals((int)2, (int)t.size());
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tex"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("test"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, (Object)t.getApproximatedInterval("s"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("tet"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("tt"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"te", (String)((MutableString)t.list().get(0)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.list().get(1)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"te", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"te", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 1))).toString());
    }

    public void testForkLeftLate() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("test");
        t.add("tess");
        this.assertContains(t, "test", 1);
        this.assertContains(t, "tess", 0);
        this.assertDoesNotContain(t, "t");
        this.assertDoesNotContain(t, "tes");
        TernaryIntervalSearchTreeTest.assertEquals((int)2, (int)t.size());
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("test"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("tess"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tessx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, (Object)t.getApproximatedInterval("sz"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), (Object)t.getApproximatedInterval("tessz"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("testz"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("tet"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"tess", (String)((MutableString)t.list().get(0)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.list().get(1)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tess", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tes", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 1))).toString());
    }

    public void testForkRightLate() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("test");
        t.add("tesv");
        this.assertContains(t, "test", 0);
        this.assertContains(t, "tesv", 1);
        this.assertDoesNotContain(t, "t");
        this.assertDoesNotContain(t, "tes");
        TernaryIntervalSearchTreeTest.assertEquals((int)2, (int)t.size());
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tesvx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("tesv"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("test"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), (Object)t.getApproximatedInterval("tesu"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), (Object)t.getApproximatedInterval("testvz"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("tet"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.list().get(0)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tesv", (String)((MutableString)t.list().get(1)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tesv", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tes", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 1))).toString());
    }

    public void testForkMiddleLate() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("tes");
        t.add("test");
        this.assertContains(t, "test", 1);
        this.assertContains(t, "tes", 0);
        this.assertDoesNotContain(t, "t");
        this.assertDoesNotContain(t, "te");
        TernaryIntervalSearchTreeTest.assertEquals((int)2, (int)t.size());
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tex"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), t.rangeMap().get("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), t.rangeMap().get("test"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0), (Object)t.getApproximatedInterval("tess"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("testvz"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1), (Object)t.getApproximatedInterval("tet"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"tes", (String)((MutableString)t.list().get(0)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.list().get(1)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tes", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tes", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 1))).toString());
    }

    public void testJustMarkNode() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("test");
        t.add("tast");
        t.add("te");
        this.assertContains(t, "test", 2);
        this.assertContains(t, "tast", 0);
        this.assertContains(t, "te", 1);
        TernaryIntervalSearchTreeTest.assertEquals((int)3, (int)t.size());
        this.assertDoesNotContain(t, "t");
        this.assertDoesNotContain(t, "tes");
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("testx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(2), t.rangeMap().get("test"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(2), t.rangeMap().get("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1, 2), t.rangeMap().get("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 2), t.rangeMap().get("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("tas"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), t.rangeMap().get("tast"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, t.rangeMap().get("tastx"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 2), (Object)t.getApproximatedInterval("t"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 0), (Object)t.getApproximatedInterval("ta"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1, 2), (Object)t.getApproximatedInterval("te"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(1, 2), (Object)t.getApproximatedInterval("tes"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(2), (Object)t.getApproximatedInterval("testvz"));
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(2), (Object)t.getApproximatedInterval("tet"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"tast", (String)((MutableString)t.list().get(0)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"te", (String)((MutableString)t.list().get(1)).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"tast", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"te", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"test", (String)((MutableString)t.prefixMap().get(Interval.valueOf(2))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"t", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"te", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1, 2))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"t", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 2))).toString());
    }

    public void testTwoRightForks() {
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree();
        t.add("0");
        t.add("iscrivit");
        t.add("vai");
        TernaryIntervalSearchTreeTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)t.getApproximatedInterval("i"));
        TernaryIntervalSearchTreeTest.assertEquals((String)"0", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"iscrivit", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"vai", (String)((MutableString)t.prefixMap().get(Interval.valueOf(2))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 1))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"", (String)((MutableString)t.prefixMap().get(Interval.valueOf(1, 2))).toString());
        TernaryIntervalSearchTreeTest.assertEquals((String)"", (String)((MutableString)t.prefixMap().get(Interval.valueOf(0, 2))).toString());
    }

    public void testLargeSet() {
        int i;
        long seed = System.currentTimeMillis();
        System.err.println(seed);
        ObjectArrayList<String> c = new ObjectArrayList<String>(WORDS);
        Collections.shuffle(c);
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree(c);
        for (i = 0; i < WORDS.length; ++i) {
            TernaryIntervalSearchTreeTest.assertTrue((String)WORDS[i], (boolean)t.containsKey(WORDS[i]));
        }
        for (i = 0; i < WORDS.length; ++i) {
            TernaryIntervalSearchTreeTest.assertEquals((String)WORDS[i], (String)((MutableString)t.list().get(i)).toString());
        }
        for (i = 0; i < WORDS.length; ++i) {
            for (int j = 0; j < WORDS[i].length(); ++j) {
                int k;
                String s = WORDS[i].substring(0, j + 1);
                for (k = 0; k < WORDS.length && !WORDS[k].startsWith(s); ++k) {
                }
                int left = k;
                while (k < WORDS.length && WORDS[k].startsWith(s)) {
                    ++k;
                }
                int right = k - 1;
                TernaryIntervalSearchTreeTest.assertEquals((String)s, (Object)(left <= right ? Interval.valueOf(left, right) : Intervals.EMPTY_INTERVAL), t.rangeMap().get(s));
                s = s + " ";
                for (k = 0; k < WORDS.length && s.compareTo(WORDS[k]) >= 0; ++k) {
                }
                TernaryIntervalSearchTreeTest.assertEquals((String)s, (Object)(k > 0 ? Interval.valueOf(k - 1) : Intervals.EMPTY_INTERVAL), (Object)t.getApproximatedInterval(s));
                s = s.substring(0, s.length() - 1) + "~";
                for (k = 0; k < WORDS.length && s.compareTo(WORDS[k]) >= 0; ++k) {
                }
                TernaryIntervalSearchTreeTest.assertEquals((String)s, (Object)Interval.valueOf(k - 1), (Object)t.getApproximatedInterval(s));
            }
        }
        ObjectRBTreeSet p = new ObjectRBTreeSet();
        for (int i2 = 0; i2 < WORDS.length; ++i2) {
            for (int j = 0; j < WORDS[i2].length(); ++j) {
                p.add(WORDS[i2].substring(0, j + 1));
            }
        }
        t = new TernaryIntervalSearchTree(p);
        for (String s : p) {
            TernaryIntervalSearchTreeTest.assertTrue((String)s, (boolean)t.containsKey(s));
        }
        int j = 0;
        for (String s : p) {
            TernaryIntervalSearchTreeTest.assertEquals((String)s, (String)((MutableString)t.list().get(j++)).toString());
        }
    }
}

