/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.webapp.navigation;

import info.aduna.io.ResourceUtil;
import info.aduna.webapp.navigation.Group;
import info.aduna.webapp.navigation.NavigationXmlParser;
import info.aduna.webapp.navigation.View;
import java.util.ArrayList;
import java.util.List;

public class NavigationModel
extends Group {
    public static final String NAVIGATION_MODEL_KEY = "navigation-model";
    public static final String DEFAULT_PATH_PREFIX = "/";
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    public static final String DEFAULT_VIEW_SUFFIX = ".view";
    public static final String DEFAULT_ICON_PREFIX = "/images/icons/";
    public static final String DEFAULT_ICON_SEPARATOR = "_";
    public static final String DEFAULT_ICON_SUFFIX = ".png";
    public static final String DEFAULT_I18N_PREFIX = "";
    public static final String DEFAULT_I18N_SEPARATOR = ".";
    public static final String DEFAULT_I18N_SUFFIX = ".title";
    private List<String> navigationModelLocations = new ArrayList<String>();
    private String pathPrefix;
    private String pathSeparator;
    private String iconPrefix;
    private String iconSeparator;
    private String iconSuffix;
    private String i18nPrefix;
    private String i18nSeparator;
    private String i18nSuffix;

    public NavigationModel() {
        super(null);
    }

    public NavigationModel(String id) {
        super(id);
    }

    @Override
    public String getId() {
        return DEFAULT_I18N_PREFIX;
    }

    @Override
    public String getPathPrefix() {
        if (this.pathPrefix == null) {
            this.setPathPrefix("/");
        }
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    @Override
    public String getPathSeparator() {
        if (this.pathSeparator == null) {
            this.setPathSeparator("/");
        }
        return this.pathSeparator;
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    @Override
    public String getIconPrefix() {
        if (this.iconPrefix == null) {
            this.setIconPrefix(DEFAULT_ICON_PREFIX);
        }
        return this.iconPrefix;
    }

    public void setIconPrefix(String iconPrefix) {
        this.iconPrefix = iconPrefix;
    }

    @Override
    public String getIconSeparator() {
        if (this.iconSeparator == null) {
            this.setIconSeparator(DEFAULT_ICON_SEPARATOR);
        }
        return this.iconSeparator;
    }

    public void setIconSeparator(String iconSeparator) {
        this.iconSeparator = iconSeparator;
    }

    @Override
    public String getIconSuffix() {
        if (this.iconSuffix == null) {
            this.setIconSuffix(DEFAULT_ICON_SUFFIX);
        }
        return this.iconSuffix;
    }

    public void setIconSuffix(String iconSuffix) {
        this.iconSuffix = iconSuffix;
    }

    @Override
    public String getI18nPrefix() {
        if (this.i18nPrefix == null) {
            this.setI18nPrefix(DEFAULT_I18N_PREFIX);
        }
        return this.i18nPrefix;
    }

    public void setI18nPrefix(String i18nPrefix) {
        this.i18nPrefix = i18nPrefix;
    }

    @Override
    public String getI18nSeparator() {
        if (this.i18nSeparator == null) {
            this.setI18nSeparator(DEFAULT_I18N_SEPARATOR);
        }
        return this.i18nSeparator;
    }

    public void setI18nSeparator(String i18nSeparator) {
        this.i18nSeparator = i18nSeparator;
    }

    @Override
    public String getI18nSuffix() {
        if (this.i18nSuffix == null) {
            this.setI18nSuffix(DEFAULT_I18N_SUFFIX);
        }
        return this.i18nSuffix;
    }

    public void setI18nSuffix(String i18nSuffix) {
        this.i18nSuffix = i18nSuffix;
    }

    @Override
    public String getViewSuffix() {
        if (this.viewSuffix == null) {
            this.setViewSuffix(DEFAULT_VIEW_SUFFIX);
        }
        return this.viewSuffix;
    }

    public View findView(String viewName) {
        View result = null;
        int prefixLength = this.getPathPrefix().length();
        viewName = viewName.substring(prefixLength);
        result = this.findViewInternal(viewName);
        return result;
    }

    public void addModel(NavigationModel other) {
        for (Group group : other.getGroups()) {
            this.addGroup(group);
        }
        for (View view : other.getViews()) {
            this.addView(view);
        }
    }

    public void setNavigationModels(List<String> navigationModelLocations) {
        this.navigationModelLocations = navigationModelLocations;
        this.createNavigationModel();
    }

    private void createNavigationModel() {
        boolean first = true;
        for (String navigationModelLocation : this.navigationModelLocations) {
            NavigationXmlParser parser = new NavigationXmlParser();
            if (first) {
                parser.parseInto(this, ResourceUtil.getURL(navigationModelLocation));
                first = false;
                continue;
            }
            this.addModel(parser.parse(ResourceUtil.getURL(navigationModelLocation)));
        }
    }

    @Override
    public Object clone() {
        NavigationModel result = new NavigationModel(this.getId());
        this.copyCommonAttributes(result);
        this.copyGroupsAndViews(result);
        return result;
    }
}

