/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import java.io.IOException;
import org.openrdf.console.Command;
import org.openrdf.console.ConsoleIO;
import org.openrdf.console.ConsoleState;
import org.openrdf.console.LockRemover;
import org.openrdf.model.Resource;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryReadOnlyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clear
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Clear.class);
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final LockRemover lockRemover;

    Clear(ConsoleIO consoleIO, ConsoleState state, LockRemover lockRemover) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.lockRemover = lockRemover;
    }

    @Override
    public void execute(String ... tokens) {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
        } else {
            ValueFactory valueFactory = repository.getValueFactory();
            Resource[] contexts = new Resource[tokens.length - 1];
            for (int i = 1; i < tokens.length; ++i) {
                String contextID = tokens[i];
                if (contextID.equalsIgnoreCase("null")) {
                    contexts[i - 1] = null;
                    continue;
                }
                if (contextID.startsWith("_:")) {
                    contexts[i - 1] = valueFactory.createBNode(contextID.substring(2));
                    continue;
                }
                try {
                    contexts[i - 1] = valueFactory.createURI(contextID);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.consoleIO.writeError("illegal URI: " + contextID);
                    this.consoleIO.writeln("Usage:\nclear                   Clears the entire repository\nclear (<uri>|null)...   Clears the specified context(s)\n");
                    return;
                }
            }
            this.clear(repository, contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(Repository repository, Resource[] contexts) {
        if (contexts.length == 0) {
            this.consoleIO.writeln("Clearing repository...");
        } else {
            this.consoleIO.writeln("Removing specified contexts...");
        }
        try {
            RepositoryConnection con = repository.getConnection();
            try {
                con.clear(contexts);
                if (contexts.length == 0) {
                    con.clearNamespaces();
                }
            }
            finally {
                con.close();
            }
        }
        catch (RepositoryReadOnlyException e) {
            try {
                if (this.lockRemover.tryToRemoveLock(repository)) {
                    this.clear(repository, contexts);
                }
                this.consoleIO.writeError("Failed to clear repository");
                LOGGER.error("Failed to clear repository", (Throwable)e);
            }
            catch (RepositoryException e1) {
                this.consoleIO.writeError("Unable to restart repository: " + e1.getMessage());
                LOGGER.error("Unable to restart repository", (Throwable)e1);
            }
            catch (IOException e1) {
                this.consoleIO.writeError("Unable to remove lock: " + e1.getMessage());
            }
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError("Failed to clear repository: " + e.getMessage());
            LOGGER.error("Failed to clear repository", (Throwable)e);
        }
    }
}

