/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import info.aduna.app.AppConfiguration;
import info.aduna.app.AppVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.openrdf.Sesame;
import org.openrdf.console.Clear;
import org.openrdf.console.Close;
import org.openrdf.console.Command;
import org.openrdf.console.Connect;
import org.openrdf.console.ConsoleIO;
import org.openrdf.console.ConsoleParameters;
import org.openrdf.console.ConsoleState;
import org.openrdf.console.Create;
import org.openrdf.console.Disconnect;
import org.openrdf.console.Drop;
import org.openrdf.console.Federate;
import org.openrdf.console.Load;
import org.openrdf.console.LockRemover;
import org.openrdf.console.Open;
import org.openrdf.console.PrintHelp;
import org.openrdf.console.PrintInfo;
import org.openrdf.console.QueryEvaluator;
import org.openrdf.console.SetParameters;
import org.openrdf.console.Show;
import org.openrdf.console.Verify;
import org.openrdf.repository.Repository;
import org.openrdf.repository.manager.RepositoryManager;

public class Console
implements ConsoleState,
ConsoleParameters {
    private static final AppVersion VERSION = AppVersion.parse(Sesame.getVersion());
    private static final String APP_NAME = "OpenRDF Sesame console";
    private static boolean exitOnError;
    private final AppConfiguration appConfig = new AppConfiguration("OpenRDF Sesame console", "OpenRDF Sesame console", VERSION);
    private RepositoryManager manager;
    private String managerID;
    private Repository repository;
    private String repositoryID;
    private final ConsoleIO consoleIO;
    private int consoleWidth = 80;
    private boolean showPrefix = true;
    private boolean queryPrefix = false;
    private final Map<String, Command> commandMap = new HashMap<String, Command>();
    private final Connect connect;
    private final Disconnect disconnect;
    private final Open open;
    private final QueryEvaluator queryEvaluator;

    public static void main(String[] args) throws IOException {
        Console console = new Console();
        Option helpOption = new Option("h", "help", false, "print this help");
        Option versionOption = new Option("v", "version", false, "print version information");
        Option serverURLOption = new Option("s", "serverURL", true, "URL of Sesame server to connect to, e.g. http://localhost/openrdf-sesame/");
        Option dirOption = new Option("d", "dataDir", true, "Sesame data dir to 'connect' to");
        Option echoOption = new Option("e", "echo", false, "echoes input back to stdout, useful for logging script sessions");
        Option quietOption = new Option("q", "quiet", false, "suppresses prompts, useful for scripting");
        Option forceOption = new Option("f", "force", false, "always answer yes to (suppressed) confirmation prompts");
        Option cautiousOption = new Option("c", "cautious", false, "always answer no to (suppressed) confirmation prompts");
        Option exitOnErrorMode = new Option("x", "exitOnError", false, "immediately exit the console on the first error");
        Options options = new Options();
        OptionGroup cautionGroup = new OptionGroup().addOption(cautiousOption).addOption(forceOption).addOption(exitOnErrorMode);
        OptionGroup locationGroup = new OptionGroup().addOption(serverURLOption).addOption(dirOption);
        options.addOptionGroup(locationGroup).addOptionGroup(cautionGroup);
        options.addOption(helpOption).addOption(versionOption).addOption(echoOption).addOption(quietOption);
        CommandLine commandLine = Console.parseCommandLine(args, console, options);
        Console.handleInfoOptions(console, helpOption, versionOption, options, commandLine);
        console.consoleIO.setEcho(commandLine.hasOption(echoOption.getOpt()));
        console.consoleIO.setQuiet(commandLine.hasOption(quietOption.getOpt()));
        exitOnError = commandLine.hasOption(exitOnErrorMode.getOpt());
        String location = Console.handleOptionGroups(console, serverURLOption, dirOption, forceOption, cautiousOption, options, cautionGroup, locationGroup, commandLine);
        String[] otherArgs = commandLine.getArgs();
        if (otherArgs.length > 1) {
            Console.printUsage(console.consoleIO, options);
            System.exit(1);
        }
        Console.connectAndOpen(console, locationGroup.getSelected(), location, otherArgs);
        console.start();
    }

    private static String handleOptionGroups(Console console, Option serverURLOption, Option dirOption, Option forceOption, Option cautiousOption, Options options, OptionGroup cautionGroup, OptionGroup locationGroup, CommandLine commandLine) {
        String location = null;
        try {
            if (commandLine.hasOption(forceOption.getOpt())) {
                cautionGroup.setSelected(forceOption);
                console.consoleIO.setForce();
            }
            if (commandLine.hasOption(cautiousOption.getOpt())) {
                cautionGroup.setSelected(cautiousOption);
                console.consoleIO.setCautious();
            }
            if (commandLine.hasOption(dirOption.getOpt())) {
                locationGroup.setSelected(dirOption);
                location = commandLine.getOptionValue(dirOption.getOpt());
            }
            if (commandLine.hasOption(serverURLOption.getOpt())) {
                locationGroup.setSelected(serverURLOption);
                location = commandLine.getOptionValue(serverURLOption.getOpt());
            }
        }
        catch (AlreadySelectedException e) {
            Console.printUsage(console.consoleIO, options);
            System.exit(3);
        }
        return location;
    }

    private static CommandLine parseCommandLine(String[] args, Console console, Options options) {
        CommandLine commandLine = null;
        try {
            commandLine = new PosixParser().parse(options, args);
        }
        catch (ParseException e) {
            console.consoleIO.writeError(e.getMessage());
            System.exit(1);
        }
        return commandLine;
    }

    private static void handleInfoOptions(Console console, Option helpOption, Option versionOption, Options options, CommandLine commandLine) {
        if (commandLine.hasOption(helpOption.getOpt())) {
            Console.printUsage(console.consoleIO, options);
            System.exit(0);
        }
        if (commandLine.hasOption(versionOption.getOpt())) {
            console.consoleIO.writeln(console.appConfig.getFullName());
            System.exit(0);
        }
    }

    private static void connectAndOpen(Console console, String selectedLocationOption, String location, String[] otherArgs) {
        boolean connected = "s".equals(selectedLocationOption) ? console.connect.connectRemote(location) : ("d".equals(selectedLocationOption) ? console.connect.connectLocal(location) : console.connect.connectDefault());
        if (!connected) {
            System.exit(2);
        }
        if (otherArgs.length > 0) {
            console.open.openRepository(otherArgs[0]);
        }
    }

    private static void printUsage(ConsoleIO cio, Options options) {
        cio.writeln("Sesame Console, an interactive shell based utility to communicate with Sesame repositories.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(80);
        formatter.printHelp("start-console [OPTION] [repositoryID]", options);
        cio.writeln();
        cio.writeln("For bug reports and suggestions, see http://www.openrdf.org/");
    }

    public Console() throws IOException {
        this.appConfig.init();
        this.consoleIO = new ConsoleIO(new BufferedReader(new InputStreamReader(System.in)), System.out, System.err, this);
        this.commandMap.put("federate", new Federate(this.consoleIO, this));
        this.queryEvaluator = new QueryEvaluator(this.consoleIO, this, this);
        LockRemover lockRemover = new LockRemover(this.consoleIO);
        Close close = new Close(this.consoleIO, this);
        this.commandMap.put("close", close);
        this.disconnect = new Disconnect(this.consoleIO, this, close);
        this.commandMap.put("help", new PrintHelp(this.consoleIO));
        this.commandMap.put("info", new PrintInfo(this.consoleIO, this));
        this.connect = new Connect(this.consoleIO, this, this.disconnect);
        this.commandMap.put("connect", this.connect);
        this.commandMap.put("create", new Create(this.consoleIO, this, lockRemover));
        this.commandMap.put("drop", new Drop(this.consoleIO, this, close, lockRemover));
        this.open = new Open(this.consoleIO, this, close, lockRemover);
        this.commandMap.put("open", this.open);
        this.commandMap.put("show", new Show(this.consoleIO, this));
        this.commandMap.put("load", new Load(this.consoleIO, this, lockRemover));
        this.commandMap.put("verify", new Verify(this.consoleIO));
        this.commandMap.put("clear", new Clear(this.consoleIO, this, lockRemover));
        this.commandMap.put("set", new SetParameters(this.consoleIO, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.consoleIO.writeln();
        this.consoleIO.writeln("Commands end with '.' at the end of a line");
        this.consoleIO.writeln("Type 'help.' for help");
        int exitCode = 0;
        try {
            boolean exitFlag = false;
            while (!exitFlag) {
                String command = this.consoleIO.readMultiLineInput();
                if (command == null) {
                    break;
                }
                exitFlag = this.executeCommand(command);
                if (!exitOnError || !this.consoleIO.wasErrorWritten()) continue;
                exitCode = 2;
                exitFlag = true;
            }
        }
        finally {
            this.disconnect.execute(false);
        }
        if (exitCode != 0) {
            System.exit(exitCode);
        }
        this.consoleIO.writeln("Bye");
    }

    private boolean executeCommand(String command) throws IOException {
        boolean exit;
        boolean bl = exit = 0 == command.length();
        if (!exit) {
            String[] tokens = this.parse(command);
            String operation = tokens[0].toLowerCase(Locale.ENGLISH);
            boolean bl2 = exit = "quit".equals(operation) || "exit".equals(operation);
            if (!exit) {
                if (this.commandMap.containsKey(operation)) {
                    this.commandMap.get(operation).execute(tokens);
                } else if ("disconnect".equals(operation)) {
                    this.disconnect.execute(true);
                } else {
                    this.queryEvaluator.executeQuery(command, operation);
                }
            }
        }
        return exit;
    }

    private String[] parse(String command) {
        Pattern pattern = Pattern.compile("\"([^\"]*)\"|(\\S+)");
        Matcher matcher = pattern.matcher(command);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            if (matcher.group(1) == null) {
                tokens.add(matcher.group());
                continue;
            }
            tokens.add(matcher.group(1));
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    @Override
    public String getApplicationName() {
        return this.appConfig.getFullName();
    }

    @Override
    public File getDataDirectory() {
        return this.appConfig.getDataDir();
    }

    @Override
    public String getManagerID() {
        return this.managerID;
    }

    @Override
    public String getRepositoryID() {
        return this.repositoryID;
    }

    @Override
    public RepositoryManager getManager() {
        return this.manager;
    }

    @Override
    public void setManager(RepositoryManager manager) {
        this.manager = manager;
    }

    @Override
    public void setManagerID(String managerID) {
        this.managerID = managerID;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepositoryID(String repositoryID) {
        this.repositoryID = repositoryID;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public int getWidth() {
        return this.consoleWidth;
    }

    @Override
    public void setWidth(int width) {
        this.consoleWidth = width;
    }

    @Override
    public boolean isShowPrefix() {
        return this.showPrefix;
    }

    @Override
    public void setShowPrefix(boolean value) {
        this.showPrefix = value;
    }

    @Override
    public boolean isQueryPrefix() {
        return this.queryPrefix;
    }

    @Override
    public void setQueryPrefix(boolean value) {
        this.queryPrefix = value;
    }
}

