/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import info.aduna.io.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.console.Command;
import org.openrdf.console.ConsoleIO;
import org.openrdf.console.ConsoleState;
import org.openrdf.console.LockRemover;
import org.openrdf.model.Resource;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryReadOnlyException;
import org.openrdf.repository.config.ConfigTemplate;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigSchema;
import org.openrdf.repository.config.RepositoryConfigUtil;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Create
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(Create.class);
    private static final String TEMPLATES_DIR = "templates";
    private final ConsoleIO consoleIO;
    private final ConsoleState state;
    private final LockRemover lockRemover;

    Create(ConsoleIO consoleIO, ConsoleState state, LockRemover lockRemover) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.lockRemover = lockRemover;
    }

    @Override
    public void execute(String ... tokens) throws IOException {
        if (tokens.length < 2) {
            this.consoleIO.writeln("Usage:\ncreate <template-name>\n  <template-name>   The name of a repository configuration template\n");
        } else {
            this.createRepository(tokens[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepository(String templateName) throws IOException {
        block9: {
            try {
                boolean proceed;
                String template;
                String templateFileName = templateName + ".ttl";
                File templatesDir = new File(this.state.getDataDirectory(), TEMPLATES_DIR);
                File templateFile = new File(templatesDir, templateFileName);
                InputStream templateStream = this.createTemplateStream(templateName, templateFileName, templatesDir, templateFile);
                if (templateStream == null) break block9;
                try {
                    template = IOUtil.readString(new InputStreamReader(templateStream, "UTF-8"));
                }
                finally {
                    templateStream.close();
                }
                ConfigTemplate configTemplate = new ConfigTemplate(template);
                HashMap<String, String> valueMap = new HashMap<String, String>();
                Map<String, List<String>> variableMap = configTemplate.getVariableMap();
                boolean eof = this.inputParameters(valueMap, variableMap, configTemplate.getMultilineMap());
                if (eof) break block9;
                String configString = configTemplate.render(valueMap);
                Repository systemRepo = this.state.getManager().getSystemRepository();
                LinkedHashModel graph = new LinkedHashModel();
                RDFParser rdfParser = Rio.createParser(RDFFormat.TURTLE, systemRepo.getValueFactory());
                rdfParser.setRDFHandler(new StatementCollector(graph));
                rdfParser.parse(new StringReader(configString), "http://www.openrdf.org/config/repository#");
                Resource repositoryNode = GraphUtil.getUniqueSubject(graph, RDF.TYPE, RepositoryConfigSchema.REPOSITORY, new Resource[0]);
                RepositoryConfig repConfig = RepositoryConfig.create(graph, repositoryNode);
                repConfig.validate();
                boolean bl = proceed = RepositoryConfigUtil.hasRepositoryConfig(systemRepo, repConfig.getID()) ? this.consoleIO.askProceed("WARNING: you are about to overwrite the configuration of an existing repository!", false) : true;
                if (proceed) {
                    try {
                        RepositoryConfigUtil.updateRepositoryConfigs(systemRepo, repConfig);
                        this.consoleIO.writeln("Repository created");
                    }
                    catch (RepositoryReadOnlyException e) {
                        if (this.lockRemover.tryToRemoveLock(systemRepo)) {
                            RepositoryConfigUtil.updateRepositoryConfigs(systemRepo, repConfig);
                            this.consoleIO.writeln("Repository created");
                            break block9;
                        }
                        this.consoleIO.writeError("Failed to create repository");
                        LOGGER.error("Failed to create repository", (Throwable)e);
                    }
                    break block9;
                }
                this.consoleIO.writeln("Create aborted");
            }
            catch (Exception e) {
                this.consoleIO.writeError(e.getClass().getName() + ": " + e.getMessage());
                LOGGER.error("Failed to create repository", (Throwable)e);
            }
        }
    }

    private boolean inputParameters(Map<String, String> valueMap, Map<String, List<String>> variableMap, Map<String, String> multilineInput) throws IOException {
        if (!variableMap.isEmpty()) {
            this.consoleIO.writeln("Please specify values for the following variables:");
        }
        boolean eof = false;
        for (Map.Entry<String, List<String>> entry : variableMap.entrySet()) {
            String var = entry.getKey();
            List<String> values = entry.getValue();
            this.consoleIO.write(var);
            if (values.size() > 1) {
                this.consoleIO.write(" (");
                for (int i = 0; i < values.size(); ++i) {
                    if (i > 0) {
                        this.consoleIO.write("|");
                    }
                    this.consoleIO.write(values.get(i));
                }
                this.consoleIO.write(")");
            }
            if (!values.isEmpty()) {
                this.consoleIO.write(" [" + values.get(0) + "]");
            }
            this.consoleIO.write(": ");
            String value = multilineInput.containsKey(var) ? this.consoleIO.readMultiLineInput() : this.consoleIO.readln(new String[0]);
            boolean bl = eof = value == null;
            if (eof) break;
            if ((value = value.trim()).length() == 0) {
                value = null;
            }
            valueMap.put(var, value);
        }
        return eof;
    }

    private InputStream createTemplateStream(String templateName, String templateFileName, File templatesDir, File templateFile) throws FileNotFoundException {
        InputStream templateStream = null;
        if (templateFile.exists()) {
            if (templateFile.canRead()) {
                templateStream = new FileInputStream(templateFile);
            } else {
                this.consoleIO.writeError("Not allowed to read template file: " + templateFile);
            }
        } else {
            templateStream = RepositoryConfig.class.getResourceAsStream(templateFileName);
            if (templateStream == null) {
                this.consoleIO.writeError("No template called " + templateName + " found in " + templatesDir);
            }
        }
        return templateStream;
    }
}

