/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import org.openrdf.console.ConsoleIO;
import org.openrdf.model.Statement;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;

class VerificationListener
extends RDFHandlerBase
implements ParseErrorListener {
    private final ConsoleIO consoleIO;
    private int warnings;
    private int errors;
    private int statements;

    VerificationListener(ConsoleIO consoleIO) {
        this.consoleIO = consoleIO;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getStatements() {
        return this.statements;
    }

    @Override
    public void handleStatement(Statement statement) throws RDFHandlerException {
        ++this.statements;
    }

    @Override
    public void warning(String msg, int lineNo, int colNo) {
        ++this.warnings;
        this.consoleIO.writeParseError("WARNING", lineNo, colNo, msg);
    }

    @Override
    public void error(String msg, int lineNo, int colNo) {
        ++this.errors;
        this.consoleIO.writeParseError("ERROR", lineNo, colNo, msg);
    }

    @Override
    public void fatalError(String msg, int lineNo, int colNo) {
        ++this.errors;
        this.consoleIO.writeParseError("FATAL ERROR", lineNo, colNo, msg);
    }
}

