/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.protocol;

import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.ntriples.NTriplesUtil;

public abstract class Protocol {
    public static final String VERSION = "6";
    public static final String SUBJECT_PARAM_NAME = "subj";
    public static final String PREDICATE_PARAM_NAME = "pred";
    public static final String OBJECT_PARAM_NAME = "obj";
    public static final String INCLUDE_INFERRED_PARAM_NAME = "infer";
    public static final String CONTEXT_PARAM_NAME = "context";
    public static final String NULL_PARAM_VALUE = "null";
    public static final String GRAPH_PARAM_NAME = "graph";
    public static final String UPDATE_PARAM_NAME = "update";
    public static final String BASEURI_PARAM_NAME = "baseURI";
    public static final String QUERY_PARAM_NAME = "query";
    public static final String QUERY_LANGUAGE_PARAM_NAME = "queryLn";
    public static final String TIMEOUT_PARAM_NAME = "timeout";
    public static final String REMOVE_GRAPH_PARAM_NAME = "remove-graph-uri";
    public static final String INSERT_GRAPH_PARAM_NAME = "insert-graph-uri";
    public static final String USING_GRAPH_PARAM_NAME = "using-graph-uri";
    public static final String USING_NAMED_GRAPH_PARAM_NAME = "using-named-graph-uri";
    public static final String DEFAULT_GRAPH_PARAM_NAME = "default-graph-uri";
    public static final String NAMED_GRAPH_PARAM_NAME = "named-graph-uri";
    public static final String ACCEPT_PARAM_NAME = "Accept";
    public static final String PROTOCOL = "protocol";
    public static final String CONFIG = "config";
    public static final String REPOSITORIES = "repositories";
    public static final String STATEMENTS = "statements";
    public static final String CONTEXTS = "contexts";
    public static final String NAMESPACES = "namespaces";
    public static final String BINDING_PREFIX = "$";
    public static final String SIZE = "size";
    public static final String TXN_MIME_TYPE = "application/x-rdftransaction";
    public static final String FORM_MIME_TYPE = "application/x-www-form-urlencoded";

    private static String getServerDir(String serverLocation) {
        if (serverLocation.endsWith("/")) {
            return serverLocation;
        }
        return serverLocation + "/";
    }

    public static final String getProtocolLocation(String serverLocation) {
        return Protocol.getServerDir(serverLocation) + PROTOCOL;
    }

    public static final String getConfigLocation(String serverLocation) {
        return Protocol.getServerDir(serverLocation) + CONFIG;
    }

    public static final String getRepositoriesLocation(String serverLocation) {
        return Protocol.getServerDir(serverLocation) + REPOSITORIES;
    }

    public static final String getRepositoryLocation(String serverLocation, String repositoryID) {
        return Protocol.getRepositoriesLocation(serverLocation) + "/" + repositoryID;
    }

    public static final String getStatementsLocation(String repositoryLocation) {
        return repositoryLocation + "/" + STATEMENTS;
    }

    public static final String getServerLocation(String repositoryLocation) {
        String serverLocation = repositoryLocation.substring(0, repositoryLocation.lastIndexOf(47));
        serverLocation = serverLocation.substring(0, serverLocation.lastIndexOf(47));
        return serverLocation;
    }

    public static final String getRepositoryID(String repositoryLocation) {
        String repositoryID = repositoryLocation.substring(repositoryLocation.lastIndexOf(47) + 1);
        return repositoryID;
    }

    public static final String getContextsLocation(String repositoryLocation) {
        return repositoryLocation + "/" + CONTEXTS;
    }

    public static final String getNamespacesLocation(String repositoryLocation) {
        return repositoryLocation + "/" + NAMESPACES;
    }

    public static final String getNamespacePrefixLocation(String repositoryLocation, String prefix) {
        return Protocol.getNamespacesLocation(repositoryLocation) + "/" + prefix;
    }

    public static final String getSizeLocation(String repositoryLocation) {
        return repositoryLocation + "/" + SIZE;
    }

    public static String encodeValue(Value value) {
        return NTriplesUtil.toNTriplesString(value);
    }

    public static Value decodeValue(String encodedValue, ValueFactory valueFactory) {
        if (encodedValue != null) {
            return NTriplesUtil.parseValue(encodedValue, valueFactory);
        }
        return null;
    }

    public static Resource decodeResource(String encodedValue, ValueFactory valueFactory) {
        if (encodedValue != null) {
            return NTriplesUtil.parseResource(encodedValue, valueFactory);
        }
        return null;
    }

    public static URI decodeURI(String encodedValue, ValueFactory valueFactory) {
        if (encodedValue != null) {
            return NTriplesUtil.parseURI(encodedValue, valueFactory);
        }
        return null;
    }

    public static String encodeContext(Resource context) {
        if (context == null) {
            return NULL_PARAM_VALUE;
        }
        return Protocol.encodeValue(context);
    }

    public static Resource decodeContext(String encodedValue, ValueFactory valueFactory) {
        if (encodedValue == null) {
            return null;
        }
        if (NULL_PARAM_VALUE.equals(encodedValue)) {
            return null;
        }
        return Protocol.decodeResource(encodedValue, valueFactory);
    }

    public static String[] encodeContexts(Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        String[] result = new String[contexts.length];
        for (int index = 0; index < contexts.length; ++index) {
            result[index] = Protocol.encodeContext(contexts[index]);
        }
        return result;
    }

    public static Resource[] decodeContexts(String[] encodedValues, ValueFactory valueFactory) {
        Resource[] result;
        if (encodedValues == null) {
            result = new Resource[]{};
        } else {
            result = new Resource[encodedValues.length];
            for (int index = 0; index < encodedValues.length; ++index) {
                result[index] = Protocol.decodeContext(encodedValues[index], valueFactory);
            }
        }
        return result;
    }
}

