/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository.graph;

import info.aduna.webapp.util.HttpServerUtil;
import info.aduna.webapp.views.EmptySuccessView;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.protocol.error.ErrorInfo;
import org.openrdf.http.protocol.error.ErrorType;
import org.openrdf.http.server.ClientHTTPException;
import org.openrdf.http.server.ProtocolUtil;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.RepositoryInterceptor;
import org.openrdf.http.server.repository.statements.ExportStatementsView;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class GraphController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public GraphController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "HEAD", "POST", "PUT", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView result;
        Repository repository = RepositoryInterceptor.getRepository(request);
        String reqMethod = request.getMethod();
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET graph");
            result = this.getExportStatementsResult(repository, request, response);
            this.logger.info("GET graph request finished.");
        } else if ("HEAD".equals(reqMethod)) {
            this.logger.info("HEAD graph");
            result = this.getExportStatementsResult(repository, request, response);
            this.logger.info("HEAD graph request finished.");
        } else if ("POST".equals(reqMethod)) {
            this.logger.info("POST data to graph");
            result = this.getAddDataResult(repository, request, response, false);
            this.logger.info("POST data request finished.");
        } else if ("PUT".equals(reqMethod)) {
            this.logger.info("PUT data in graph");
            result = this.getAddDataResult(repository, request, response, true);
            this.logger.info("PUT data request finished.");
        } else if ("DELETE".equals(reqMethod)) {
            this.logger.info("DELETE data from graph");
            result = this.getDeleteDataResult(repository, request, response);
            this.logger.info("DELETE data request finished.");
        } else {
            throw new ClientHTTPException(405, "Method not allowed: " + reqMethod);
        }
        return result;
    }

    private URI getGraphName(HttpServletRequest request, ValueFactory vf) throws ClientHTTPException {
        String requestURL = request.getRequestURL().toString();
        boolean isServiceRequest = requestURL.endsWith("/service");
        String queryString = request.getQueryString();
        if (isServiceRequest) {
            if (!"default".equalsIgnoreCase(queryString)) {
                URI graph = ProtocolUtil.parseGraphParam(request, vf);
                if (graph == null) {
                    throw new ClientHTTPException(400, "Named or default graph expected for indirect reference request.");
                }
                return graph;
            }
            return null;
        }
        if (queryString != null) {
            throw new ClientHTTPException(400, "No parameters epxected for direct reference request.");
        }
        return vf.createURI(requestURL);
    }

    private ModelAndView getExportStatementsResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException {
        ProtocolUtil.logRequestParameters(request);
        ValueFactory vf = repository.getValueFactory();
        URI graph = this.getGraphName(request, vf);
        RDFWriterFactory rdfWriterFactory = ProtocolUtil.getAcceptableService(request, response, RDFWriterRegistry.getInstance());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("contexts", new Resource[]{graph});
        model.put("factory", rdfWriterFactory);
        model.put("useInferencing", true);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        return new ModelAndView((View)ExportStatementsView.getInstance(), model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView getAddDataResult(Repository repository, HttpServletRequest request, HttpServletResponse response, boolean replaceCurrent) throws IOException, ClientHTTPException, ServerHTTPException {
        ProtocolUtil.logRequestParameters(request);
        String mimeType = HttpServerUtil.getMIMEType(request.getContentType());
        RDFFormat rdfFormat = Rio.getParserFormatForMIMEType(mimeType);
        if (rdfFormat == null) {
            throw new ClientHTTPException(415, "Unsupported MIME type: " + mimeType);
        }
        ValueFactory vf = repository.getValueFactory();
        URI graph = this.getGraphName(request, vf);
        ServletInputStream in = request.getInputStream();
        try {
            RepositoryConnection repositoryCon;
            RepositoryConnection repositoryConnection = repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            synchronized (repositoryConnection) {
                if (repositoryCon.isAutoCommit()) {
                    repositoryCon.begin();
                }
                if (replaceCurrent) {
                    repositoryCon.clear(graph);
                }
                repositoryCon.add((InputStream)in, graph.toString(), rdfFormat, graph);
                repositoryCon.commit();
            }
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (UnsupportedRDFormatException e) {
            throw new ClientHTTPException(415, "No RDF parser available for format " + rdfFormat.getName());
        }
        catch (RDFParseException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_DATA, e.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (IOException e) {
            throw new ServerHTTPException("Failed to read data: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView getDeleteDataResult(Repository repository, HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException, ServerHTTPException {
        ProtocolUtil.logRequestParameters(request);
        ValueFactory vf = repository.getValueFactory();
        URI graph = this.getGraphName(request, vf);
        try {
            RepositoryConnection repositoryCon;
            RepositoryConnection repositoryConnection = repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            synchronized (repositoryConnection) {
                repositoryCon.clear(graph);
            }
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository update error: " + e.getMessage(), (Throwable)e);
        }
    }
}

