/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository.statements;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.RepositoryInterceptor;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.springframework.web.servlet.View;

public class ExportStatementsView
implements View {
    public static final String SUBJECT_KEY = "subject";
    public static final String PREDICATE_KEY = "predicate";
    public static final String OBJECT_KEY = "object";
    public static final String CONTEXTS_KEY = "contexts";
    public static final String USE_INFERENCING_KEY = "useInferencing";
    public static final String FACTORY_KEY = "factory";
    public static final String HEADERS_ONLY = "headersOnly";
    private static final ExportStatementsView INSTANCE = new ExportStatementsView();

    public static ExportStatementsView getInstance() {
        return INSTANCE;
    }

    private ExportStatementsView() {
    }

    public String getContentType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Resource subj = (Resource)model.get(SUBJECT_KEY);
        URI pred = (URI)model.get(PREDICATE_KEY);
        Value obj = (Value)model.get(OBJECT_KEY);
        Resource[] contexts = (Resource[])model.get(CONTEXTS_KEY);
        boolean useInferencing = (Boolean)model.get(USE_INFERENCING_KEY);
        boolean headersOnly = (Boolean)model.get(HEADERS_ONLY);
        RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)model.get(FACTORY_KEY);
        RDFFormat rdfFormat = rdfWriterFactory.getRDFFormat();
        try {
            ServletOutputStream out = response.getOutputStream();
            RDFWriter rdfWriter = rdfWriterFactory.getWriter((OutputStream)out);
            response.setStatus(200);
            String mimeType = rdfFormat.getDefaultMIMEType();
            if (rdfFormat.hasCharset()) {
                Charset charset = rdfFormat.getCharset();
                mimeType = mimeType + "; charset=" + charset.name();
            }
            response.setContentType(mimeType);
            String filename = "statements";
            if (rdfFormat.getDefaultFileExtension() != null) {
                filename = filename + "." + rdfFormat.getDefaultFileExtension();
            }
            response.setHeader("Content-Disposition", "attachment; filename=" + filename);
            if (!headersOnly) {
                RepositoryConnection repositoryCon;
                RepositoryConnection repositoryConnection = repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
                synchronized (repositoryConnection) {
                    repositoryCon.exportStatements(subj, pred, obj, useInferencing, rdfWriter, contexts);
                }
            }
            out.close();
        }
        catch (RDFHandlerException e) {
            throw new ServerHTTPException("Serialization error: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
    }
}

