/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import info.aduna.net.ParsedURI;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.ast.ASTBaseDecl;
import org.openrdf.query.parser.sparql.ast.ASTDeleteData;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTIRIFunc;
import org.openrdf.query.parser.sparql.ast.ASTInsertData;
import org.openrdf.query.parser.sparql.ast.ASTOperationContainer;
import org.openrdf.query.parser.sparql.ast.ASTServiceGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTUnparsedQuadDataBlock;
import org.openrdf.query.parser.sparql.ast.VisitorException;

public class BaseDeclProcessor {
    public static void process(ASTOperationContainer qc, String externalBaseURI) throws MalformedQueryException {
        ParsedURI parsedBaseURI = null;
        ASTBaseDecl baseDecl = qc.getBaseDecl();
        if (baseDecl != null) {
            parsedBaseURI = new ParsedURI(baseDecl.getIRI());
            if (!parsedBaseURI.isAbsolute()) {
                throw new MalformedQueryException("BASE IRI is not an absolute IRI: " + externalBaseURI);
            }
        } else if (externalBaseURI != null && !(parsedBaseURI = new ParsedURI(externalBaseURI)).isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI is not an absolute IRI: " + externalBaseURI);
        }
        if (parsedBaseURI != null) {
            ASTUnparsedQuadDataBlock dataBlock = null;
            if (qc.getOperation() instanceof ASTInsertData) {
                ASTInsertData insertData = (ASTInsertData)qc.getOperation();
                dataBlock = insertData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
            } else if (qc.getOperation() instanceof ASTDeleteData) {
                ASTDeleteData deleteData = (ASTDeleteData)qc.getOperation();
                dataBlock = deleteData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
            }
            if (dataBlock != null) {
                String baseURIDeclaration = "BASE <" + parsedBaseURI + "> \n";
                dataBlock.setDataBlock(baseURIDeclaration + dataBlock.getDataBlock());
            } else {
                RelativeIRIResolver visitor = new RelativeIRIResolver(parsedBaseURI);
                try {
                    qc.jjtAccept(visitor, null);
                }
                catch (VisitorException e) {
                    throw new MalformedQueryException(e);
                }
            }
        }
    }

    private static class RelativeIRIResolver
    extends ASTVisitorBase {
        private ParsedURI parsedBaseURI;

        public RelativeIRIResolver(ParsedURI parsedBaseURI) {
            this.parsedBaseURI = parsedBaseURI;
        }

        @Override
        public Object visit(ASTIRI node, Object data) throws VisitorException {
            ParsedURI resolvedURI = this.parsedBaseURI.resolve(node.getValue());
            node.setValue(resolvedURI.toString());
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTIRIFunc node, Object data) throws VisitorException {
            node.setBaseURI(this.parsedBaseURI.toString());
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
            node.setBaseURI(this.parsedBaseURI.toString());
            return super.visit(node, data);
        }
    }
}

