/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.queryrender.serql;

import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.BNodeGenerator;
import org.openrdf.query.algebra.BinaryValueOperator;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.CompareAll;
import org.openrdf.query.algebra.CompareAny;
import org.openrdf.query.algebra.Count;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Exists;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.In;
import org.openrdf.query.algebra.IsBNode;
import org.openrdf.query.algebra.IsLiteral;
import org.openrdf.query.algebra.IsResource;
import org.openrdf.query.algebra.IsURI;
import org.openrdf.query.algebra.Label;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.LangMatches;
import org.openrdf.query.algebra.Like;
import org.openrdf.query.algebra.LocalName;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.Max;
import org.openrdf.query.algebra.Min;
import org.openrdf.query.algebra.Namespace;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.UnaryValueOperator;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.queryrender.BaseTupleExprRenderer;
import org.openrdf.queryrender.RenderUtils;

class SerqlValueExprRenderer
extends QueryModelVisitorBase<Exception> {
    private StringBuffer mBuffer = new StringBuffer();

    SerqlValueExprRenderer() {
    }

    public void reset() {
        this.mBuffer = new StringBuffer();
    }

    public String render(ValueExpr theExpr) throws Exception {
        this.reset();
        theExpr.visit(this);
        return this.mBuffer.toString();
    }

    @Override
    public void meet(Bound theOp) throws Exception {
        this.mBuffer.append(" bound(");
        theOp.getArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(Var theVar) throws Exception {
        if (theVar.isAnonymous() && !theVar.hasValue()) {
            this.mBuffer.append(BaseTupleExprRenderer.scrubVarName(theVar.getName().substring(1)));
        } else if (theVar.hasValue()) {
            this.mBuffer.append(RenderUtils.getSerqlQueryString(theVar.getValue()));
        } else {
            this.mBuffer.append(theVar.getName());
        }
    }

    @Override
    public void meet(BNodeGenerator theGen) throws Exception {
        this.mBuffer.append(theGen.getSignature());
    }

    @Override
    public void meet(MathExpr theOp) throws Exception {
        this.mBuffer.append("(");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(" ").append(theOp.getOperator().getSymbol()).append(" ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(Compare theOp) throws Exception {
        this.mBuffer.append("(");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(" ").append(theOp.getOperator().getSymbol()).append(" ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(Exists theOp) throws Exception {
        this.mBuffer.append(" exists(");
        theOp.getSubQuery().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(In theOp) throws Exception {
        theOp.getArg().visit(this);
        this.mBuffer.append(" in ");
        this.mBuffer.append("(");
        theOp.getSubQuery().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(CompareAll theOp) throws Exception {
        this.mBuffer.append("(");
        theOp.getArg().visit(this);
        this.mBuffer.append(" ").append(theOp.getOperator().getSymbol()).append(" all ");
        this.mBuffer.append("(");
        theOp.getSubQuery().visit(this);
        this.mBuffer.append(")");
        this.mBuffer.append(")");
    }

    @Override
    public void meet(ValueConstant theVal) throws Exception {
        this.mBuffer.append(RenderUtils.getSerqlQueryString(theVal.getValue()));
    }

    @Override
    public void meet(FunctionCall theOp) throws Exception {
        this.mBuffer.append(theOp.getURI()).append("(");
        boolean aFirst = true;
        for (ValueExpr aArg : theOp.getArgs()) {
            if (!aFirst) {
                this.mBuffer.append(", ");
            } else {
                aFirst = false;
            }
            aArg.visit(this);
        }
        this.mBuffer.append(")");
    }

    @Override
    public void meet(CompareAny theOp) throws Exception {
        this.mBuffer.append("(");
        theOp.getArg().visit(this);
        this.mBuffer.append(" ").append(theOp.getOperator().getSymbol()).append(" any ");
        this.mBuffer.append("(");
        theOp.getSubQuery().visit(this);
        this.mBuffer.append(")");
        this.mBuffer.append(")");
    }

    @Override
    public void meet(Regex theOp) throws Exception {
        this.mBuffer.append(" regex(");
        theOp.getArg().visit(this);
        this.mBuffer.append(", ");
        theOp.getPatternArg().visit(this);
        if (theOp.getFlagsArg() != null) {
            this.mBuffer.append(",");
            theOp.getFlagsArg().visit(this);
        }
        this.mBuffer.append(")");
    }

    @Override
    public void meet(LangMatches theOp) throws Exception {
        this.mBuffer.append(" langMatches(");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(", ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(SameTerm theOp) throws Exception {
        this.mBuffer.append(" sameTerm(");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(", ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(And theAnd) throws Exception {
        this.binaryMeet("and", theAnd);
    }

    @Override
    public void meet(Or theOr) throws Exception {
        this.binaryMeet("or", theOr);
    }

    @Override
    public void meet(Not theNot) throws Exception {
        this.unaryMeet("not", theNot);
    }

    @Override
    public void meet(Count theOp) throws Exception {
        this.unaryMeet("count", theOp);
    }

    @Override
    public void meet(Datatype theOp) throws Exception {
        this.unaryMeet("datatype", theOp);
    }

    @Override
    public void meet(IsBNode theOp) throws Exception {
        this.unaryMeet("isBNode", theOp);
    }

    @Override
    public void meet(IsLiteral theOp) throws Exception {
        this.unaryMeet("isLiteral", theOp);
    }

    @Override
    public void meet(IsResource theOp) throws Exception {
        this.unaryMeet("isResource", theOp);
    }

    @Override
    public void meet(IsURI theOp) throws Exception {
        this.unaryMeet("isURI", theOp);
    }

    @Override
    public void meet(Label theOp) throws Exception {
        this.unaryMeet("label", theOp);
    }

    @Override
    public void meet(Lang theOp) throws Exception {
        this.unaryMeet("lang", theOp);
    }

    @Override
    public void meet(Like theOp) throws Exception {
        theOp.getArg().visit(this);
        this.mBuffer.append(" like \"").append(theOp.getPattern()).append("\"");
        if (!theOp.isCaseSensitive()) {
            this.mBuffer.append(" ignore case");
        }
    }

    @Override
    public void meet(LocalName theOp) throws Exception {
        this.unaryMeet("localName", theOp);
    }

    @Override
    public void meet(Min theOp) throws Exception {
        this.unaryMeet("min", theOp);
    }

    @Override
    public void meet(Max theOp) throws Exception {
        this.unaryMeet("max", theOp);
    }

    @Override
    public void meet(Namespace theOp) throws Exception {
        this.unaryMeet("namespace", theOp);
    }

    @Override
    public void meet(Str theOp) throws Exception {
        this.unaryMeet("str", theOp);
    }

    private void binaryMeet(String theOpStr, BinaryValueOperator theOp) throws Exception {
        this.mBuffer.append(" (");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(" ").append(theOpStr).append(" ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    private void unaryMeet(String theOpStr, UnaryValueOperator theOp) throws Exception {
        this.mBuffer.append(" ").append(theOpStr).append("(");
        theOp.getArg().visit(this);
        this.mBuffer.append(")");
    }
}

