/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.queryrender.sparql;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class ContextCollector
extends QueryModelVisitorBase<Exception> {
    private Map<TupleExpr, Var> mContexts = new HashMap<TupleExpr, Var>();

    private ContextCollector() {
    }

    static Map<TupleExpr, Var> collectContexts(TupleExpr theTupleExpr) throws Exception {
        ContextCollector aContextVisitor = new ContextCollector();
        theTupleExpr.visit(aContextVisitor);
        return aContextVisitor.mContexts;
    }

    @Override
    public void meet(Join theJoin) throws Exception {
        this.binaryOpMeet(theJoin, theJoin.getLeftArg(), theJoin.getRightArg());
    }

    @Override
    public void meet(LeftJoin theJoin) throws Exception {
        this.binaryOpMeet(theJoin, theJoin.getLeftArg(), theJoin.getRightArg());
    }

    @Override
    public void meet(Union theOp) throws Exception {
        this.binaryOpMeet(theOp, theOp.getLeftArg(), theOp.getRightArg());
    }

    @Override
    public void meet(Difference theOp) throws Exception {
        this.binaryOpMeet(theOp, theOp.getLeftArg(), theOp.getRightArg());
    }

    @Override
    public void meet(Intersection theOp) throws Exception {
        this.binaryOpMeet(theOp, theOp.getLeftArg(), theOp.getRightArg());
    }

    @Override
    public void meet(Filter theFilter) throws Exception {
        theFilter.getArg().visit(this);
        if (this.mContexts.containsKey(theFilter.getArg())) {
            Var aCtx = this.mContexts.get(theFilter.getArg());
            this.mContexts.remove(theFilter.getArg());
            this.mContexts.put(theFilter, aCtx);
        }
    }

    private void binaryOpMeet(TupleExpr theCurrentExpr, TupleExpr theLeftExpr, TupleExpr theRightExpr) throws Exception {
        theLeftExpr.visit(this);
        Var aLeftCtx = this.mContexts.get(theLeftExpr);
        theRightExpr.visit(this);
        Var aRightCtx = this.mContexts.get(theRightExpr);
        this.sameCtxCheck(theCurrentExpr, theLeftExpr, aLeftCtx, theRightExpr, aRightCtx);
    }

    @Override
    public void meet(StatementPattern thePattern) throws Exception {
        Var aCtxVar = thePattern.getContextVar();
        if (aCtxVar != null) {
            this.mContexts.put(thePattern, aCtxVar);
        }
    }

    private void sameCtxCheck(TupleExpr theCurrentExpr, TupleExpr theLeftExpr, Var theLeftCtx, TupleExpr theRightExpr, Var theRightCtx) {
        if (theLeftCtx != null && theRightCtx != null && this.isSameCtx(theLeftCtx, theRightCtx)) {
            this.mContexts.remove(theLeftExpr);
            this.mContexts.remove(theRightExpr);
            this.mContexts.put(theCurrentExpr, theLeftCtx);
        }
    }

    private boolean isSameCtx(Var v1, Var v2) {
        if (v1 != null && v1.getValue() != null && v2 != null && v2.getValue() != null) {
            return v1.getValue().equals(v2.getValue());
        }
        if (v1 != null && v1.getName() != null && v2 != null && v2.getName() != null) {
            return v1.getName().equals(v2.getName());
        }
        return false;
    }
}

