/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.queryrender.sparql;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.queryrender.BaseTupleExprRenderer;
import org.openrdf.queryrender.RenderUtils;
import org.openrdf.queryrender.sparql.ContextCollector;
import org.openrdf.queryrender.sparql.SparqlValueExprRenderer;

public final class SparqlTupleExprRenderer
extends BaseTupleExprRenderer {
    private StringBuffer mJoinBuffer = new StringBuffer();
    private Map<TupleExpr, Var> mContexts = new HashMap<TupleExpr, Var>();
    private int mIndent = 2;

    @Override
    public void reset() {
        super.reset();
        this.mJoinBuffer = new StringBuffer();
        this.mContexts.clear();
    }

    @Override
    public String render(TupleExpr theExpr) throws Exception {
        this.mContexts = ContextCollector.collectContexts(theExpr);
        theExpr.visit(this);
        return this.mJoinBuffer.toString();
    }

    private String indent() {
        StringBuilder aBuilder = new StringBuilder();
        for (int i = 0; i < this.mIndent; ++i) {
            aBuilder.append(" ");
        }
        return aBuilder.toString();
    }

    @Override
    protected String renderValueExpr(ValueExpr theExpr) throws Exception {
        return new SparqlValueExprRenderer().render(theExpr);
    }

    private void ctxOpen(TupleExpr theExpr) {
        Var aContext = this.mContexts.get(theExpr);
        if (aContext != null) {
            this.mJoinBuffer.append(this.indent()).append("GRAPH ");
            if (aContext.hasValue()) {
                this.mJoinBuffer.append(RenderUtils.getSPARQLQueryString(aContext.getValue()));
            } else {
                this.mJoinBuffer.append("?").append(aContext.getName());
            }
            this.mJoinBuffer.append(" {\n");
            this.mIndent += 2;
        }
    }

    private void ctxClose(TupleExpr theExpr) {
        Var aContext = this.mContexts.get(theExpr);
        if (aContext != null) {
            this.mJoinBuffer.append("}");
            this.mIndent -= 2;
        }
    }

    @Override
    public void meet(Join theJoin) throws Exception {
        this.ctxOpen(theJoin);
        theJoin.getLeftArg().visit(this);
        theJoin.getRightArg().visit(this);
        this.ctxClose(theJoin);
    }

    @Override
    public void meet(LeftJoin theJoin) throws Exception {
        boolean aNeedsNewScope;
        this.ctxOpen(theJoin);
        boolean bl = aNeedsNewScope = theJoin.getParentNode() != null && (theJoin.getParentNode() instanceof Join || theJoin.getParentNode() instanceof LeftJoin);
        if (aNeedsNewScope) {
            this.mJoinBuffer.append("{\n");
        }
        theJoin.getLeftArg().visit(this);
        this.mJoinBuffer.append(this.indent()).append("OPTIONAL {\n");
        this.mIndent += 2;
        theJoin.getRightArg().visit(this);
        if (theJoin.getCondition() != null) {
            this.mJoinBuffer.append(this.indent()).append("filter").append(this.renderValueExpr(theJoin.getCondition())).append("\n");
        }
        this.mIndent -= 2;
        this.mJoinBuffer.append(this.indent()).append("}.\n");
        if (aNeedsNewScope) {
            this.mJoinBuffer.append("}.\n");
        }
        this.ctxClose(theJoin);
    }

    private String renderTupleExpr(TupleExpr theExpr) throws Exception {
        SparqlTupleExprRenderer aRenderer = new SparqlTupleExprRenderer();
        aRenderer.mIndent = this.mIndent;
        aRenderer.mContexts = new HashMap<TupleExpr, Var>(this.mContexts);
        return aRenderer.render(theExpr);
    }

    @Override
    public void meet(Union theOp) throws Exception {
        String aRight;
        this.ctxOpen(theOp);
        String aLeft = this.renderTupleExpr(theOp.getLeftArg());
        if (aLeft.endsWith("\n")) {
            aLeft = aLeft.substring(0, aLeft.length() - 1);
        }
        if ((aRight = this.renderTupleExpr(theOp.getRightArg())).endsWith("\n")) {
            aRight = aRight.substring(0, aRight.length() - 1);
        }
        this.mJoinBuffer.append(this.indent()).append("{\n").append(aLeft).append("\n").append(this.indent()).append("}\n").append(this.indent()).append("union\n").append(this.indent()).append("{\n").append(aRight).append("\n").append(this.indent()).append("}.\n");
        this.ctxClose(theOp);
    }

    @Override
    public void meet(Difference theOp) throws Exception {
        String aLeft = this.renderTupleExpr(theOp.getLeftArg());
        String aRight = this.renderTupleExpr(theOp.getRightArg());
        this.mJoinBuffer.append("\n{").append(aLeft).append("}").append("\nminus\n").append("{").append(aRight).append("}.\n");
    }

    @Override
    public void meet(Intersection theOp) throws Exception {
        String aLeft = this.renderTupleExpr(theOp.getLeftArg());
        String aRight = this.renderTupleExpr(theOp.getRightArg());
        this.mJoinBuffer.append("\n").append(aLeft).append("}").append("\nintersection\n").append("{").append(aRight).append("}.\n");
    }

    @Override
    public void meet(Filter theFilter) throws Exception {
        this.ctxOpen(theFilter);
        if (theFilter.getArg() != null) {
            theFilter.getArg().visit(this);
        }
        boolean aNeedsNewScope = theFilter.getParentNode() != null && (theFilter.getParentNode() instanceof Join || theFilter.getParentNode() instanceof LeftJoin);
        String aFilter = this.renderValueExpr(theFilter.getCondition());
        if (theFilter.getCondition() instanceof ValueConstant || theFilter.getCondition() instanceof Var) {
            aFilter = "(" + aFilter + ")";
        }
        this.mJoinBuffer.append(this.indent());
        this.mJoinBuffer.append("filter ").append(aFilter).append(".");
        this.mJoinBuffer.append("\n");
        this.ctxClose(theFilter);
    }

    @Override
    public void meet(StatementPattern thePattern) throws Exception {
        this.ctxOpen(thePattern);
        this.mJoinBuffer.append(this.indent()).append(this.renderPattern(thePattern));
        this.ctxClose(thePattern);
    }

    String renderPattern(StatementPattern thePattern) throws Exception {
        return this.renderValueExpr(thePattern.getSubjectVar()) + " " + this.renderValueExpr(thePattern.getPredicateVar()) + " " + "" + this.renderValueExpr(thePattern.getObjectVar()) + ".\n";
    }
}

