/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail.config;

import org.openrdf.repository.Repository;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryFactory;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.config.RepositoryResolver;
import org.openrdf.repository.sail.config.RepositoryResolverClient;
import org.openrdf.repository.sail.config.SailRepositoryConfig;
import org.openrdf.sail.Sail;
import org.openrdf.sail.StackableSail;
import org.openrdf.sail.config.DelegatingSailImplConfig;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailFactory;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.config.SailRegistry;

public class SailRepositoryFactory
implements RepositoryFactory,
RepositoryResolverClient {
    public static final String REPOSITORY_TYPE = "openrdf:SailRepository";
    private RepositoryResolver resolver;

    @Override
    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    @Override
    public RepositoryImplConfig getConfig() {
        return new SailRepositoryConfig();
    }

    @Override
    public Repository getRepository(RepositoryImplConfig config) throws RepositoryConfigException {
        if (config instanceof SailRepositoryConfig) {
            SailRepositoryConfig sailRepConfig = (SailRepositoryConfig)config;
            try {
                Sail sail = this.createSailStack(sailRepConfig.getSailImplConfig());
                return new SailRepository(sail);
            }
            catch (SailConfigException e) {
                throw new RepositoryConfigException(e.getMessage(), e);
            }
        }
        throw new RepositoryConfigException("Invalid configuration class: " + config.getClass());
    }

    private Sail createSailStack(SailImplConfig config) throws RepositoryConfigException, SailConfigException {
        SailImplConfig delegateConfig;
        Sail sail = this.createSail(config);
        if (config instanceof DelegatingSailImplConfig && (delegateConfig = ((DelegatingSailImplConfig)config).getDelegate()) != null) {
            this.addDelegate(delegateConfig, sail);
        }
        return sail;
    }

    private Sail createSail(SailImplConfig config) throws RepositoryConfigException, SailConfigException {
        SailFactory sailFactory = (SailFactory)SailRegistry.getInstance().get(config.getType());
        if (sailFactory instanceof RepositoryResolverClient) {
            ((RepositoryResolverClient)((Object)sailFactory)).setRepositoryResolver(this.resolver);
        }
        if (sailFactory != null) {
            return sailFactory.getSail(config);
        }
        throw new RepositoryConfigException("Unsupported Sail type: " + config.getType());
    }

    private void addDelegate(SailImplConfig config, Sail sail) throws RepositoryConfigException, SailConfigException {
        Sail delegateSail = this.createSailStack(config);
        try {
            ((StackableSail)sail).setBaseSail(delegateSail);
        }
        catch (ClassCastException e) {
            throw new RepositoryConfigException("Delegate configured but " + sail.getClass() + " is not a StackableSail");
        }
    }

    @Override
    public void setRepositoryResolver(RepositoryResolver resolver) {
        this.resolver = resolver;
    }
}

