/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.UnionIteration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.federation.Federation;
import org.openrdf.sail.federation.PrefixHashSet;
import org.openrdf.sail.federation.evaluation.FederationStrategy;
import org.openrdf.sail.federation.optimizers.EmptyPatternOptimizer;
import org.openrdf.sail.federation.optimizers.FederationJoinOptimizer;
import org.openrdf.sail.federation.optimizers.OwnedTupleExprPruner;
import org.openrdf.sail.federation.optimizers.PrepareOwnedTupleExpr;
import org.openrdf.sail.federation.optimizers.QueryModelPruner;
import org.openrdf.sail.federation.optimizers.QueryMultiJoinOptimizer;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailConnectionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFederationConnection
extends SailConnectionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFederationConnection.class);
    private final Federation federation;
    private final ValueFactory valueFactory;
    protected final List<RepositoryConnection> members;

    public AbstractFederationConnection(Federation federation, List<RepositoryConnection> members) {
        super(new SailBase(){

            @Override
            public boolean isWritable() throws SailException {
                return false;
            }

            @Override
            public ValueFactory getValueFactory() {
                return null;
            }

            @Override
            protected void shutDownInternal() throws SailException {
            }

            @Override
            protected SailConnection getConnectionInternal() throws SailException {
                return null;
            }

            @Override
            protected void connectionClosed(SailConnection connection) {
            }
        });
        this.federation = federation;
        this.valueFactory = ValueFactoryImpl.getInstance();
        this.members = new ArrayList<RepositoryConnection>(members.size());
        for (RepositoryConnection member : members) {
            this.members.add(member);
        }
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Override
    public void closeInternal() throws SailException {
        this.excute(new Procedure(){

            @Override
            public void run(RepositoryConnection con) throws RepositoryException {
                con.close();
            }
        });
    }

    @Override
    public CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        CloseableIteration<Resource, SailException> cursor = this.union(new Function<Resource>(){

            @Override
            public CloseableIteration<? extends Resource, RepositoryException> call(RepositoryConnection member) throws RepositoryException {
                return member.getContextIDs();
            }
        });
        cursor = new DistinctIteration<Resource, SailException>(cursor);
        return cursor;
    }

    @Override
    public String getNamespaceInternal(String prefix) throws SailException {
        try {
            String namespace = null;
            for (RepositoryConnection member : this.members) {
                String candidate = member.getNamespace(prefix);
                if (namespace == null) {
                    namespace = candidate;
                    continue;
                }
                if (candidate == null || candidate.equals(namespace)) continue;
                namespace = null;
                break;
            }
            return namespace;
        }
        catch (RepositoryException e) {
            throw new SailException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        HashMap<String, Namespace> namespaces = new HashMap<String, Namespace>();
        HashSet<String> prefixes = new HashSet<String>();
        try {
            for (RepositoryConnection member : this.members) {
                RepositoryResult<Namespace> memberNamespaces = member.getNamespaces();
                try {
                    while (memberNamespaces.hasNext()) {
                        Namespace next = memberNamespaces.next();
                        String prefix = next.getPrefix();
                        if (prefixes.add(prefix)) {
                            namespaces.put(prefix, next);
                            continue;
                        }
                        if (next.getName().equals(((Namespace)namespaces.get(prefix)).getName())) continue;
                        namespaces.remove(prefix);
                    }
                }
                finally {
                    memberNamespaces.close();
                }
            }
        }
        catch (RepositoryException e) {
            throw new SailException(e);
        }
        return new CloseableIteratorIteration(namespaces.values().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeInternal(Resource ... contexts) throws SailException {
        long l;
        if (this.federation.isDistinct()) {
            long size = 0L;
            for (RepositoryConnection member : this.members) {
                size += member.size(contexts);
            }
            return size;
        }
        CloseableIteration<? extends Statement, SailException> cursor = this.getStatements(null, null, null, true, contexts);
        try {
            long size = 0L;
            while (cursor.hasNext()) {
                cursor.next();
                ++size;
            }
            l = size;
        }
        catch (Throwable throwable) {
            try {
                cursor.close();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new SailException(e);
            }
        }
        cursor.close();
        return l;
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatementsInternal(final Resource subj, final URI pred, final Value obj, final boolean includeInferred, final Resource ... contexts) throws SailException {
        CloseableIteration<Statement, SailException> cursor = this.union(new Function<Statement>(){

            @Override
            public CloseableIteration<? extends Statement, RepositoryException> call(RepositoryConnection member) throws RepositoryException {
                return member.getStatements(subj, pred, obj, includeInferred, contexts);
            }
        });
        if (!this.federation.isDistinct() && !this.isLocal(pred)) {
            cursor = new DistinctIteration<Statement, SailException>(cursor);
        }
        return cursor;
    }

    @Override
    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr query, Dataset dataset, BindingSet bindings, boolean inf) throws SailException {
        FederationTripleSource tripleSource = new FederationTripleSource(inf);
        FederationStrategy strategy = new FederationStrategy(this.federation, tripleSource, dataset);
        TupleExpr qry = this.optimize(query, dataset, bindings, strategy);
        try {
            return ((EvaluationStrategyImpl)strategy).evaluate(qry, EmptyBindingSet.getInstance());
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    private TupleExpr optimize(TupleExpr parsed, Dataset dataset, BindingSet bindings, EvaluationStrategyImpl strategy) throws SailException {
        LOGGER.trace("Incoming query model:\n{}", (Object)parsed.toString());
        QueryRoot query = new QueryRoot(parsed.clone());
        new BindingAssigner().optimize(query, dataset, bindings);
        new ConstantOptimizer(strategy).optimize(query, dataset, bindings);
        new CompareOptimizer().optimize(query, dataset, bindings);
        new ConjunctiveConstraintSplitter().optimize(query, dataset, bindings);
        new DisjunctiveConstraintOptimizer().optimize(query, dataset, bindings);
        new SameTermFilterOptimizer().optimize(query, dataset, bindings);
        new QueryModelPruner().optimize(query, dataset, bindings);
        new QueryMultiJoinOptimizer().optimize(query, dataset, bindings);
        new EmptyPatternOptimizer(this.members).optimize(query, dataset, bindings);
        boolean distinct = this.federation.isDistinct();
        PrefixHashSet local = this.federation.getLocalPropertySpace();
        new FederationJoinOptimizer(this.members, distinct, local).optimize(query, dataset, bindings);
        new OwnedTupleExprPruner().optimize(query, dataset, bindings);
        new QueryModelPruner().optimize(query, dataset, bindings);
        new QueryMultiJoinOptimizer().optimize(query, dataset, bindings);
        new PrepareOwnedTupleExpr().optimize(query, dataset, bindings);
        LOGGER.trace("Optimized query model:\n{}", (Object)((Object)query).toString());
        return query;
    }

    void excute(Procedure operation) throws SailException {
        RepositoryException storeExc = null;
        RuntimeException runtimeExc = null;
        for (RepositoryConnection member : this.members) {
            try {
                operation.run(member);
            }
            catch (RepositoryException e) {
                LOGGER.error("Failed to execute procedure on federation members", (Throwable)e);
                if (storeExc != null) continue;
                storeExc = e;
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to execute procedure on federation members", (Throwable)e);
                if (runtimeExc != null) continue;
                runtimeExc = e;
            }
        }
        if (storeExc != null) {
            throw new SailException(storeExc);
        }
        if (runtimeExc != null) {
            throw runtimeExc;
        }
    }

    private <E> CloseableIteration<? extends E, SailException> union(Function<E> function) throws SailException {
        ArrayList<CloseableIteration<E, RepositoryException>> cursors = new ArrayList<CloseableIteration<E, RepositoryException>>(this.members.size());
        try {
            for (RepositoryConnection member : this.members) {
                cursors.add(function.call(member));
            }
            UnionIteration result = new UnionIteration(cursors);
            return new ExceptionConvertingIteration<E, SailException>(result){

                @Override
                protected SailException convert(Exception e) {
                    return new SailException(e);
                }
            };
        }
        catch (RepositoryException e) {
            this.closeAll(cursors);
            throw new SailException(e);
        }
        catch (RuntimeException e) {
            this.closeAll(cursors);
            throw e;
        }
    }

    private boolean isLocal(URI pred) {
        if (pred == null) {
            return false;
        }
        PrefixHashSet hash = this.federation.getLocalPropertySpace();
        if (hash == null) {
            return false;
        }
        return hash.match(pred.stringValue());
    }

    private void closeAll(Iterable<? extends CloseableIteration<?, RepositoryException>> cursors) {
        for (CloseableIteration<?, RepositoryException> cursor : cursors) {
            try {
                cursor.close();
            }
            catch (RepositoryException e) {
                LOGGER.error("Failed to close cursor", (Throwable)e);
            }
        }
    }

    private static interface Function<E> {
        public CloseableIteration<? extends E, RepositoryException> call(RepositoryConnection var1) throws RepositoryException;
    }

    static interface Procedure {
        public void run(RepositoryConnection var1) throws RepositoryException;
    }

    private class FederationTripleSource
    implements TripleSource {
        private final boolean inf;

        public FederationTripleSource(boolean includeInferred) {
            this.inf = includeInferred;
        }

        @Override
        public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
            try {
                CloseableIteration<? extends Statement, SailException> result = AbstractFederationConnection.this.getStatements(subj, pred, obj, this.inf, contexts);
                return new ExceptionConvertingIteration<Statement, QueryEvaluationException>(result){

                    @Override
                    protected QueryEvaluationException convert(Exception e) {
                        return new QueryEvaluationException(e);
                    }
                };
            }
            catch (SailException e) {
                throw new QueryEvaluationException(e);
            }
        }

        @Override
        public ValueFactory getValueFactory() {
            return AbstractFederationConnection.this.valueFactory;
        }
    }
}

