/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.algebra.BNodeColumn;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.DatatypeColumn;
import org.openrdf.sail.rdbms.algebra.DateTimeColumn;
import org.openrdf.sail.rdbms.algebra.DoubleValue;
import org.openrdf.sail.rdbms.algebra.FalseValue;
import org.openrdf.sail.rdbms.algebra.HashColumn;
import org.openrdf.sail.rdbms.algebra.IdColumn;
import org.openrdf.sail.rdbms.algebra.JoinItem;
import org.openrdf.sail.rdbms.algebra.LabelColumn;
import org.openrdf.sail.rdbms.algebra.LanguageColumn;
import org.openrdf.sail.rdbms.algebra.LongLabelColumn;
import org.openrdf.sail.rdbms.algebra.LongURIColumn;
import org.openrdf.sail.rdbms.algebra.NumberValue;
import org.openrdf.sail.rdbms.algebra.NumericColumn;
import org.openrdf.sail.rdbms.algebra.RefIdColumn;
import org.openrdf.sail.rdbms.algebra.SqlAbs;
import org.openrdf.sail.rdbms.algebra.SqlAnd;
import org.openrdf.sail.rdbms.algebra.SqlCase;
import org.openrdf.sail.rdbms.algebra.SqlCast;
import org.openrdf.sail.rdbms.algebra.SqlCompare;
import org.openrdf.sail.rdbms.algebra.SqlConcat;
import org.openrdf.sail.rdbms.algebra.SqlEq;
import org.openrdf.sail.rdbms.algebra.SqlIsNull;
import org.openrdf.sail.rdbms.algebra.SqlLike;
import org.openrdf.sail.rdbms.algebra.SqlLowerCase;
import org.openrdf.sail.rdbms.algebra.SqlMathExpr;
import org.openrdf.sail.rdbms.algebra.SqlNot;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.SqlOr;
import org.openrdf.sail.rdbms.algebra.SqlRegex;
import org.openrdf.sail.rdbms.algebra.SqlShift;
import org.openrdf.sail.rdbms.algebra.StringValue;
import org.openrdf.sail.rdbms.algebra.TrueValue;
import org.openrdf.sail.rdbms.algebra.URIColumn;
import org.openrdf.sail.rdbms.algebra.UnionItem;
import org.openrdf.sail.rdbms.algebra.base.BinarySqlOperator;
import org.openrdf.sail.rdbms.algebra.base.FromItem;
import org.openrdf.sail.rdbms.algebra.base.SqlConstant;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.UnarySqlOperator;
import org.openrdf.sail.rdbms.algebra.base.ValueColumnBase;
import org.openrdf.sail.rdbms.evaluation.SqlBracketBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlCaseBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlCastBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlExprBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlJoinBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlQueryBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlRegexBuilder;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;

public class QueryBuilder {
    private SqlQueryBuilder query;
    private RdbmsValueFactory vf;
    private boolean usingHashTable;

    public QueryBuilder(SqlQueryBuilder builder) {
        this.query = builder;
    }

    public void setValueFactory(RdbmsValueFactory vf) {
        this.vf = vf;
    }

    public void setUsingHashTable(boolean usingHashTable) {
        this.usingHashTable = usingHashTable;
    }

    public void distinct() {
        this.query.distinct();
    }

    public QueryBuilder filter(ColumnVar var, Value val) throws RdbmsException {
        String alias = var.getAlias();
        String column = var.getColumn();
        this.query.filter().and().columnEquals(alias, column, this.vf.getInternalId(val));
        return this;
    }

    public void from(FromItem from) throws RdbmsException, UnsupportedRdbmsOperatorException {
        this.from(this.query, from);
    }

    public List<?> getParameters() {
        return this.query.findParameters(new ArrayList<Object>());
    }

    public void limit(Long limit) {
        this.query.limit(limit);
    }

    public void offset(Long offset) {
        this.query.offset(offset);
    }

    public void orderBy(SqlExpr expr, boolean isAscending) throws UnsupportedRdbmsOperatorException {
        SqlExprBuilder orderBy = this.query.orderBy();
        this.dispatch(expr, orderBy);
        if (!isAscending) {
            orderBy.append(" DESC");
        }
    }

    public QueryBuilder select(SqlExpr expr) throws UnsupportedRdbmsOperatorException {
        this.dispatch(expr, this.query.select());
        return this;
    }

    public String toString() {
        return this.query.toString();
    }

    private void append(BNodeColumn var, SqlExprBuilder filter) {
        String alias = this.getBNodeAlias(var.getRdbmsVar());
        filter.column(alias, "value");
    }

    private void append(DatatypeColumn var, SqlExprBuilder filter) {
        if (var.getRdbmsVar().isResource()) {
            filter.appendNull();
        } else {
            String alias = this.getDatatypeAlias(var.getRdbmsVar());
            filter.column(alias, "value");
        }
    }

    private void append(DateTimeColumn var, SqlExprBuilder filter) {
        if (var.getRdbmsVar().isResource()) {
            filter.appendNull();
        } else {
            String alias = this.getDateTimeAlias(var.getRdbmsVar());
            filter.column(alias, "value");
        }
    }

    private void append(DoubleValue expr, SqlExprBuilder filter) {
        filter.appendNumeric((Number)expr.getValue());
    }

    private void append(FalseValue expr, SqlExprBuilder filter) {
        filter.appendBoolean(false);
    }

    private void append(HashColumn var, SqlExprBuilder filter) {
        if (this.usingHashTable) {
            String alias = this.getHashAlias(var.getRdbmsVar());
            filter.column(alias, "value");
        } else {
            filter.column(var.getAlias(), var.getColumn());
        }
    }

    private void append(IdColumn expr, SqlExprBuilder filter) {
        filter.column(expr.getAlias(), expr.getColumn());
    }

    private void append(LabelColumn var, SqlExprBuilder filter) {
        if (var.getRdbmsVar().isResource()) {
            filter.appendNull();
        } else {
            String alias = this.getLabelAlias(var.getRdbmsVar());
            filter.column(alias, "value");
        }
    }

    private void append(LongLabelColumn var, SqlExprBuilder filter) {
        if (var.getRdbmsVar().isResource()) {
            filter.appendNull();
        } else {
            String alias = this.getLongLabelAlias(var.getRdbmsVar());
            filter.column(alias, "value");
        }
    }

    private void append(LanguageColumn var, SqlExprBuilder filter) {
        if (var.getRdbmsVar().isResource()) {
            filter.appendNull();
        } else {
            String alias = this.getLanguageAlias(var.getRdbmsVar());
            filter.column(alias, "value");
        }
    }

    private void append(LongURIColumn uri, SqlExprBuilder filter) {
        ColumnVar var = uri.getRdbmsVar();
        String alias = this.getLongURIAlias(var);
        filter.column(alias, "value");
    }

    private void append(NumberValue expr, SqlExprBuilder filter) {
        filter.number((Number)expr.getValue());
    }

    private void append(NumericColumn var, SqlExprBuilder filter) {
        if (var.getRdbmsVar().isResource()) {
            filter.appendNull();
        } else {
            String alias = this.getNumericAlias(var.getRdbmsVar());
            filter.column(alias, "value");
        }
    }

    private void append(RefIdColumn expr, SqlExprBuilder filter) {
        filter.column(expr.getAlias(), expr.getColumn());
    }

    private void append(SqlAbs expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        SqlBracketBuilder abs = filter.abs();
        this.dispatch(expr.getArg(), abs);
        abs.close();
    }

    private void append(SqlAnd expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        this.dispatch(expr.getLeftArg(), filter);
        filter.and();
        this.dispatch(expr.getRightArg(), filter);
    }

    private void append(SqlCase expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        SqlCaseBuilder caseExpr = filter.caseBegin();
        for (SqlCase.Entry e : expr.getEntries()) {
            caseExpr.when();
            this.dispatch(e.getCondition(), filter);
            caseExpr.then();
            this.dispatch(e.getResult(), filter);
        }
        caseExpr.end();
    }

    private void append(SqlCast expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        SqlCastBuilder cast = filter.cast(expr.getType());
        this.dispatch(expr.getArg(), cast);
        cast.close();
    }

    private void append(SqlCompare expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        this.dispatch(expr.getLeftArg(), filter);
        filter.appendOperator(expr.getOperator());
        this.dispatch(expr.getRightArg(), filter);
    }

    private void append(SqlConcat expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        SqlBracketBuilder open = filter.open();
        this.dispatch(expr.getLeftArg(), open);
        open.concat();
        this.dispatch(expr.getRightArg(), open);
        open.close();
    }

    private void append(SqlEq expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        this.dispatch(expr.getLeftArg(), filter);
        filter.eq();
        this.dispatch(expr.getRightArg(), filter);
    }

    private void append(SqlIsNull expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        this.dispatch(expr.getArg(), filter);
        filter.isNull();
    }

    private void append(SqlLike expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        this.dispatch(expr.getLeftArg(), filter);
        filter.like();
        this.dispatch(expr.getRightArg(), filter);
    }

    private void append(SqlLowerCase expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        SqlBracketBuilder lower = filter.lowerCase();
        this.dispatch(expr.getArg(), lower);
        lower.close();
    }

    private void append(SqlMathExpr expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        this.dispatch(expr.getLeftArg(), filter);
        filter.math(expr.getOperator());
        this.dispatch(expr.getRightArg(), filter);
    }

    private void append(SqlNot expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        if (expr.getArg() instanceof SqlIsNull) {
            SqlIsNull arg = (SqlIsNull)expr.getArg();
            this.dispatch(arg.getArg(), filter);
            filter.isNotNull();
        } else {
            SqlBracketBuilder open = filter.not();
            this.dispatch(expr.getArg(), open);
            open.close();
        }
    }

    private void append(SqlNull expr, SqlExprBuilder filter) {
        filter.appendNull();
    }

    private void append(SqlOr expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        SqlBracketBuilder open = filter.open();
        this.dispatch(expr.getLeftArg(), open);
        open.or();
        this.dispatch(expr.getRightArg(), open);
        open.close();
    }

    private void append(SqlRegex expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        SqlRegexBuilder regex = filter.regex();
        this.dispatch(expr.getArg(), regex.value());
        this.dispatch(expr.getPatternArg(), regex.pattern());
        SqlExpr flags = expr.getFlagsArg();
        if (flags != null) {
            this.dispatch(flags, regex.flags());
        }
        regex.close();
    }

    private void append(SqlShift expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        SqlBracketBuilder mod = filter.mod(expr.getRange());
        SqlBracketBuilder open = mod.open();
        this.dispatch(expr.getArg(), open);
        open.rightShift(expr.getRightShift());
        open.close();
        mod.plus(expr.getRange());
        mod.close();
    }

    private void append(StringValue expr, SqlExprBuilder filter) {
        filter.varchar((String)expr.getValue());
    }

    private void append(TrueValue expr, SqlExprBuilder filter) {
        filter.appendBoolean(true);
    }

    private void append(URIColumn uri, SqlExprBuilder filter) {
        ColumnVar var = uri.getRdbmsVar();
        String alias = this.getURIAlias(var);
        filter.column(alias, "value");
    }

    private void dispatch(SqlExpr expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        if (expr instanceof ValueColumnBase) {
            this.dispatchValueColumnBase((ValueColumnBase)expr, filter);
        } else if (expr instanceof IdColumn) {
            this.append((IdColumn)expr, filter);
        } else if (expr instanceof SqlConstant) {
            this.dispatchSqlConstant((SqlConstant)expr, filter);
        } else if (expr instanceof UnarySqlOperator) {
            this.dispatchUnarySqlOperator((UnarySqlOperator)expr, filter);
        } else if (expr instanceof BinarySqlOperator) {
            this.dispatchBinarySqlOperator((BinarySqlOperator)expr, filter);
        } else {
            this.dispatchOther(expr, filter);
        }
    }

    private void dispatchBinarySqlOperator(BinarySqlOperator expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        if (expr instanceof SqlAnd) {
            this.append((SqlAnd)expr, filter);
        } else if (expr instanceof SqlEq) {
            this.append((SqlEq)expr, filter);
        } else if (expr instanceof SqlOr) {
            this.append((SqlOr)expr, filter);
        } else if (expr instanceof SqlCompare) {
            this.append((SqlCompare)expr, filter);
        } else if (expr instanceof SqlRegex) {
            this.append((SqlRegex)expr, filter);
        } else if (expr instanceof SqlConcat) {
            this.append((SqlConcat)expr, filter);
        } else if (expr instanceof SqlMathExpr) {
            this.append((SqlMathExpr)expr, filter);
        } else if (expr instanceof SqlLike) {
            this.append((SqlLike)expr, filter);
        } else {
            throw this.unsupported(expr);
        }
    }

    private void dispatchOther(SqlExpr expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        if (!(expr instanceof SqlCase)) {
            throw this.unsupported(expr);
        }
        this.append((SqlCase)expr, filter);
    }

    private void dispatchSqlConstant(SqlConstant<?> expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        if (expr instanceof DoubleValue) {
            this.append((DoubleValue)expr, filter);
        } else if (expr instanceof FalseValue) {
            this.append((FalseValue)expr, filter);
        } else if (expr instanceof TrueValue) {
            this.append((TrueValue)expr, filter);
        } else if (expr instanceof NumberValue) {
            this.append((NumberValue)expr, filter);
        } else if (expr instanceof SqlNull) {
            this.append((SqlNull)expr, filter);
        } else if (expr instanceof StringValue) {
            this.append((StringValue)expr, filter);
        } else {
            throw this.unsupported(expr);
        }
    }

    private void dispatchUnarySqlOperator(UnarySqlOperator expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        if (expr instanceof SqlAbs) {
            this.append((SqlAbs)expr, filter);
        } else if (expr instanceof SqlIsNull) {
            this.append((SqlIsNull)expr, filter);
        } else if (expr instanceof SqlNot) {
            this.append((SqlNot)expr, filter);
        } else if (expr instanceof SqlShift) {
            this.append((SqlShift)expr, filter);
        } else if (expr instanceof SqlLowerCase) {
            this.append((SqlLowerCase)expr, filter);
        } else if (expr instanceof SqlCast) {
            this.append((SqlCast)expr, filter);
        } else {
            throw this.unsupported(expr);
        }
    }

    private void dispatchValueColumnBase(ValueColumnBase expr, SqlExprBuilder filter) throws UnsupportedRdbmsOperatorException {
        if (expr instanceof BNodeColumn) {
            this.append((BNodeColumn)expr, filter);
        } else if (expr instanceof DatatypeColumn) {
            this.append((DatatypeColumn)expr, filter);
        } else if (expr instanceof HashColumn) {
            this.append((HashColumn)expr, filter);
        } else if (expr instanceof DateTimeColumn) {
            this.append((DateTimeColumn)expr, filter);
        } else if (expr instanceof LabelColumn) {
            this.append((LabelColumn)expr, filter);
        } else if (expr instanceof LongLabelColumn) {
            this.append((LongLabelColumn)expr, filter);
        } else if (expr instanceof LongURIColumn) {
            this.append((LongURIColumn)expr, filter);
        } else if (expr instanceof LanguageColumn) {
            this.append((LanguageColumn)expr, filter);
        } else if (expr instanceof NumericColumn) {
            this.append((NumericColumn)expr, filter);
        } else if (expr instanceof URIColumn) {
            this.append((URIColumn)expr, filter);
        } else if (expr instanceof RefIdColumn) {
            this.append((RefIdColumn)expr, filter);
        } else {
            throw this.unsupported(expr);
        }
    }

    private void from(SqlQueryBuilder subquery, FromItem item) throws RdbmsException, UnsupportedRdbmsOperatorException {
        assert (!item.isLeft()) : item;
        String alias = item.getAlias();
        if (item instanceof JoinItem) {
            String tableName = ((JoinItem)item).getTableName();
            this.subJoinAndFilter(subquery.from(tableName, alias), item);
        } else {
            this.subJoinAndFilter(subquery.from(alias), item);
        }
    }

    private String getBNodeAlias(ColumnVar var) {
        return "b" + this.getDBName(var);
    }

    private String getDatatypeAlias(ColumnVar var) {
        return "d" + this.getDBName(var);
    }

    private String getDateTimeAlias(ColumnVar var) {
        return "t" + this.getDBName(var);
    }

    private String getDBName(ColumnVar var) {
        String name = var.getName();
        if (name.indexOf(45) >= 0) {
            return name.replace('-', '_');
        }
        return "_" + name;
    }

    private String getHashAlias(ColumnVar var) {
        return "h" + this.getDBName(var);
    }

    private String getLabelAlias(ColumnVar var) {
        return "l" + this.getDBName(var);
    }

    private String getLongLabelAlias(ColumnVar var) {
        return "ll" + this.getDBName(var);
    }

    private String getLongURIAlias(ColumnVar var) {
        return "lu" + this.getDBName(var);
    }

    private String getLanguageAlias(ColumnVar var) {
        return "g" + this.getDBName(var);
    }

    private String getNumericAlias(ColumnVar var) {
        return "n" + this.getDBName(var);
    }

    private String getURIAlias(ColumnVar var) {
        return "u" + this.getDBName(var);
    }

    private void join(SqlJoinBuilder query, FromItem join) throws RdbmsException, UnsupportedRdbmsOperatorException {
        String alias = join.getAlias();
        if (join instanceof JoinItem) {
            String tableName = ((JoinItem)join).getTableName();
            if (join.isLeft()) {
                this.subJoinAndFilter(query.leftjoin(tableName, alias), join);
            } else {
                this.subJoinAndFilter(query.join(tableName, alias), join);
            }
        } else if (join.isLeft()) {
            this.subJoinAndFilter(query.leftjoin(alias), join);
        } else {
            this.subJoinAndFilter(query.join(alias), join);
        }
    }

    private SqlJoinBuilder subJoinAndFilter(SqlJoinBuilder query, FromItem from) throws RdbmsException, UnsupportedRdbmsOperatorException {
        if (from instanceof UnionItem) {
            UnionItem union = (UnionItem)from;
            List<String> names = union.getSelectVarNames();
            List<ColumnVar> vars = union.appendVars(new ArrayList<ColumnVar>());
            SqlQueryBuilder subquery = query.subquery();
            for (FromItem item : union.getUnion()) {
                int n = names.size();
                for (int i = 0; i < n; ++i) {
                    ColumnVar var = item.getVar(names.get(i));
                    SqlExprBuilder select = subquery.select();
                    if (var == null) {
                        select.appendNull();
                    } else if (var.isImplied()) {
                        select.appendNumeric(this.vf.getInternalId(var.getValue()));
                    } else {
                        select.column(var.getAlias(), var.getColumn());
                    }
                    select.as(vars.get(i).getColumn());
                }
                this.from(subquery, item);
                subquery = subquery.union();
            }
        }
        for (FromItem join : from.getJoins()) {
            this.join(query, join);
        }
        for (SqlExpr expr : from.getFilters()) {
            this.dispatch(expr, query.on().and());
        }
        return query;
    }

    private UnsupportedRdbmsOperatorException unsupported(Object object) throws UnsupportedRdbmsOperatorException {
        return new UnsupportedRdbmsOperatorException(object.toString());
    }
}

