/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.evaluation;

import java.util.List;
import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.SqlExprBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlJoinBuilder;

public class SqlQueryBuilder {
    private QueryBuilderFactory factory;
    protected boolean distinct;
    protected SqlExprBuilder select;
    protected SqlJoinBuilder from;
    protected StringBuilder group = new StringBuilder();
    protected SqlExprBuilder order;
    protected SqlQueryBuilder union;
    protected Long offset;
    protected Long limit;

    public SqlQueryBuilder(QueryBuilderFactory factory) {
        this.factory = factory;
        this.select = factory.createSqlExprBuilder();
        this.order = factory.createSqlExprBuilder();
    }

    public List<Object> findParameters(List<Object> parameters) {
        parameters.addAll(this.select.getParameters());
        if (this.from != null) {
            this.from.findParameters(parameters);
        }
        if (this.union != null) {
            this.union.findParameters(parameters);
        }
        parameters.addAll(this.order.getParameters());
        return parameters;
    }

    public void distinct() {
        this.distinct = true;
    }

    public SqlExprBuilder select() {
        if (!this.select.isEmpty()) {
            this.select.append(",\n ");
        }
        return this.select;
    }

    public SqlJoinBuilder from(String table, String alias) {
        assert (this.from == null) : alias;
        this.from = this.factory.createSqlJoinBuilder(table, alias);
        return this.from;
    }

    public SqlJoinBuilder from(String alias) {
        assert (this.from == null) : alias;
        this.from = this.factory.createSqlJoinBuilder(null, alias);
        return this.from;
    }

    public SqlExprBuilder filter() {
        assert (this.from != null);
        return this.from.on();
    }

    public SqlQueryBuilder groupBy(String ... expressions) {
        for (String expr : expressions) {
            if (this.group.length() == 0) {
                this.group.append("\nGROUP BY ");
            } else {
                this.group.append(", ");
            }
            this.group.append(expr);
        }
        return this;
    }

    public SqlQueryBuilder union() {
        assert (this.union == null) : this.union;
        this.union = this.factory.createSqlQueryBuilder();
        return this.union;
    }

    public boolean isEmpty() {
        return this.select.isEmpty() && this.from == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        if (this.select.isEmpty()) {
            sb.append("*");
        } else {
            sb.append(this.select.toSql());
        }
        if (this.from != null) {
            sb.append("\nFROM ").append(this.from.getFromClause());
            if (!this.from.on().isEmpty()) {
                sb.append("\nWHERE ");
                sb.append(this.from.on().toSql());
            }
        }
        sb.append((CharSequence)this.group);
        if (this.union != null && !this.union.isEmpty()) {
            sb.append("\nUNION ALL ");
            sb.append(this.union.toString());
        }
        if (!this.order.isEmpty()) {
            sb.append("\nORDER BY ").append(this.order.toSql());
        }
        if (this.limit != null) {
            sb.append("\nLIMIT ").append(this.limit);
        }
        if (this.offset != null) {
            sb.append("\nOFFSET ").append(this.offset);
        }
        return sb.toString();
    }

    public SqlExprBuilder orderBy() {
        if (!this.order.isEmpty()) {
            this.order.append(",\n ");
        }
        return this.order;
    }

    public void offset(Long offset) {
        this.offset = offset;
        if (this.limit == null) {
            this.limit = Long.MAX_VALUE;
        }
    }

    public void limit(Long limit) {
        this.limit = limit;
    }
}

