/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.optimizers;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.sail.rdbms.algebra.BNodeColumn;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.DatatypeColumn;
import org.openrdf.sail.rdbms.algebra.DateTimeColumn;
import org.openrdf.sail.rdbms.algebra.HashColumn;
import org.openrdf.sail.rdbms.algebra.IdColumn;
import org.openrdf.sail.rdbms.algebra.JoinItem;
import org.openrdf.sail.rdbms.algebra.LabelColumn;
import org.openrdf.sail.rdbms.algebra.LanguageColumn;
import org.openrdf.sail.rdbms.algebra.LongLabelColumn;
import org.openrdf.sail.rdbms.algebra.LongURIColumn;
import org.openrdf.sail.rdbms.algebra.NumericColumn;
import org.openrdf.sail.rdbms.algebra.RefIdColumn;
import org.openrdf.sail.rdbms.algebra.SelectQuery;
import org.openrdf.sail.rdbms.algebra.SqlEq;
import org.openrdf.sail.rdbms.algebra.URIColumn;
import org.openrdf.sail.rdbms.algebra.UnionItem;
import org.openrdf.sail.rdbms.algebra.base.FromItem;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.schema.BNodeTable;
import org.openrdf.sail.rdbms.schema.HashTable;
import org.openrdf.sail.rdbms.schema.LiteralTable;
import org.openrdf.sail.rdbms.schema.URITable;

public class ValueJoinOptimizer
extends RdbmsQueryModelVisitorBase<RuntimeException>
implements QueryOptimizer {
    private URITable uris;
    private BNodeTable bnodes;
    private LiteralTable literals;
    private HashTable hashes;
    private FromItem join;
    private FromItem parent;
    private List<FromItem> stack = new ArrayList<FromItem>();
    private SelectQuery query;

    public void setUriTable(URITable uris) {
        this.uris = uris;
    }

    public void setBnodeTable(BNodeTable bnodes) {
        this.bnodes = bnodes;
    }

    public void setLiteralTable(LiteralTable literals) {
        this.literals = literals;
    }

    public void setHashTable(HashTable hashes) {
        this.hashes = hashes;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        this.join = null;
        tupleExpr.visit(this);
    }

    @Override
    public void meetFromItem(FromItem node) throws RuntimeException {
        FromItem top = this.parent;
        this.parent = this.join;
        this.join = node;
        super.meetFromItem(node);
        this.join = this.parent;
        this.parent = top;
    }

    @Override
    public void meet(UnionItem node) throws RuntimeException {
        this.stack.add(node);
        super.meet(node);
        this.stack.remove(this.stack.size() - 1);
    }

    @Override
    public void meet(SelectQuery node) throws RuntimeException {
        this.query = node;
        this.parent = node.getFrom();
        this.join = node.getFrom();
        super.meet(node);
        this.join = null;
        this.parent = null;
        this.query = null;
    }

    @Override
    public void meet(HashColumn node) throws RuntimeException {
        if (this.hashes == null || this.hashes.getName() == null) {
            super.meet(node);
        } else {
            ColumnVar var = node.getRdbmsVar();
            String alias = "h" + this.getDBName(var);
            String tableName = this.hashes.getName();
            this.join(var, alias, tableName, false);
        }
    }

    @Override
    public void meet(BNodeColumn node) throws RuntimeException {
        ColumnVar var = node.getRdbmsVar();
        String alias = "b" + this.getDBName(var);
        String tableName = this.bnodes.getName();
        this.join(var, alias, tableName);
    }

    @Override
    public void meet(DatatypeColumn node) throws RuntimeException {
        ColumnVar var = node.getRdbmsVar();
        String alias = "d" + this.getDBName(var);
        String tableName = this.literals.getDatatypeTable().getName();
        this.join(var, alias, tableName);
    }

    @Override
    public void meet(DateTimeColumn node) throws RuntimeException {
        ColumnVar var = node.getRdbmsVar();
        String alias = "t" + this.getDBName(var);
        String tableName = this.literals.getDateTimeTable().getName();
        this.join(var, alias, tableName);
    }

    @Override
    public void meet(LabelColumn node) throws RuntimeException {
        ColumnVar var = node.getRdbmsVar();
        String alias = "l" + this.getDBName(var);
        String tableName = this.literals.getLabelTable().getName();
        this.join(var, alias, tableName);
    }

    @Override
    public void meet(LongLabelColumn node) throws RuntimeException {
        ColumnVar var = node.getRdbmsVar();
        String alias = "ll" + this.getDBName(var);
        String tableName = this.literals.getLongLabelTable().getName();
        this.join(var, alias, tableName);
    }

    @Override
    public void meet(LanguageColumn node) throws RuntimeException {
        ColumnVar var = node.getRdbmsVar();
        String alias = "g" + this.getDBName(var);
        String tableName = this.literals.getLanguageTable().getName();
        this.join(var, alias, tableName);
    }

    @Override
    public void meet(NumericColumn node) throws RuntimeException {
        ColumnVar var = node.getRdbmsVar();
        String alias = "n" + this.getDBName(var);
        String tableName = this.literals.getNumericTable().getName();
        this.join(var, alias, tableName);
    }

    @Override
    public void meet(LongURIColumn node) throws RuntimeException {
        ColumnVar var = node.getRdbmsVar();
        String alias = "lu" + this.getDBName(var);
        String tableName = this.uris.getLongTableName();
        this.join(var, alias, tableName);
    }

    @Override
    public void meet(URIColumn node) throws RuntimeException {
        ColumnVar var = node.getRdbmsVar();
        String alias = "u" + this.getDBName(var);
        String tableName = this.uris.getShortTableName();
        this.join(var, alias, tableName);
    }

    private CharSequence getDBName(ColumnVar var) {
        String name = var.getName();
        if (name.indexOf(45) >= 0) {
            return name.replace('-', '_');
        }
        return "_" + name;
    }

    private void join(ColumnVar var, String alias, String tableName) {
        this.join(var, alias, tableName, true);
    }

    private void join(ColumnVar var, String alias, String tableName, boolean left) {
        if (!this.isJoined(alias)) {
            FromItem valueJoin = this.valueJoin(alias, tableName, var, left);
            if (this.join == this.parent || this.join.getFromItem(var.getAlias()) != null) {
                this.join.addJoin(valueJoin);
            } else {
                this.parent.addJoinBefore(valueJoin, this.join);
            }
        }
    }

    private boolean isJoined(String alias) {
        if (this.stack.isEmpty()) {
            return this.query.getFromItem(alias) != null;
        }
        return this.stack.get(this.stack.size() - 1).getFromItem(alias) != null;
    }

    private FromItem valueJoin(String alias, String tableName, ColumnVar using, boolean left) {
        JoinItem j = new JoinItem(alias, tableName);
        j.setLeft(left);
        j.addFilter(new SqlEq(new IdColumn(alias), new RefIdColumn(using)));
        return j;
    }
}

