/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.io.Serializable;

public class BooleanListBitVector
extends AbstractBitVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BooleanList list;

    protected static final void ensureIntegerIndex(long index) {
        if (index > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This BitVector implementation accepts integer indices only");
        }
    }

    public static BooleanListBitVector getInstance(long capacity) {
        if (capacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This BitVector implementation accepts integer indices only");
        }
        return new BooleanListBitVector((int)capacity);
    }

    public static BooleanListBitVector getInstance() {
        return new BooleanListBitVector(0);
    }

    public static BooleanListBitVector of(int ... bit) {
        BooleanListBitVector bitVector = BooleanListBitVector.getInstance(bit.length);
        for (int b : bit) {
            bitVector.add(b);
        }
        return bitVector;
    }

    protected BooleanListBitVector(BooleanList list) {
        this.list = list;
    }

    protected BooleanListBitVector(int capacity) {
        this((BooleanList)new BooleanArrayList(capacity));
    }

    public static BooleanListBitVector wrap(BooleanList list) {
        return new BooleanListBitVector(list);
    }

    public long length() {
        return this.list.size();
    }

    public boolean set(long index, boolean value) {
        BooleanListBitVector.ensureIntegerIndex(index);
        return this.list.set((int)index, value);
    }

    public boolean getBoolean(long index) {
        BooleanListBitVector.ensureIntegerIndex(index);
        return this.list.getBoolean((int)index);
    }

    public void add(long index, boolean value) {
        BooleanListBitVector.ensureIntegerIndex(index);
        this.list.add((int)index, value);
    }

    public boolean removeBoolean(long index) {
        BooleanListBitVector.ensureIntegerIndex(index);
        return this.list.removeBoolean((int)index);
    }

    public BitVector copy(long from, long to) {
        BitVectors.ensureFromTo(this.length(), from, to);
        return new BooleanListBitVector(this.list.subList((int)from, (int)to));
    }

    public BitVector copy() {
        return new BooleanListBitVector((BooleanList)new BooleanArrayList(this.list));
    }

    public BitVector ensureCapacity(long numBits) {
        if (numBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This BitVector implementation accepts integer indices only");
        }
        this.list.size((int)numBits);
        return this;
    }

    public BitVector length(long numBits) {
        if (numBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This BitVector implementation accepts integer indices only");
        }
        this.list.size((int)numBits);
        return this;
    }
}

