/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.lang;

import it.unimi.dsi.lang.ObjectParser;
import java.util.Set;
import junit.framework.TestCase;
import test.it.unimi.dsi.lang.TwoStrings;

public class ObjectParserTest
extends TestCase {
    public void testObject() throws Exception {
        ObjectParserTest.assertEquals(Object.class, ObjectParser.fromSpec("java.lang.Object").getClass());
        ObjectParserTest.assertEquals(Object.class, ObjectParser.fromSpec("java.lang.Object()").getClass());
        ObjectParserTest.assertEquals(Object.class, ObjectParser.fromSpec("Object", Object.class, new String[]{"java.lang"}).getClass());
        ObjectParserTest.assertEquals(Object.class, ObjectParser.fromSpec("Object", Object.class, new String[]{"foo", "java.lang"}).getClass());
    }

    public void testString() throws Exception {
        ObjectParserTest.assertEquals((Object)"foo", (Object)ObjectParser.fromSpec("java.lang.String(foo)"));
        ObjectParserTest.assertEquals((Object)"foo", (Object)ObjectParser.fromSpec("java.lang.String(\"foo\")"));
        ObjectParserTest.assertEquals((Object)"foo", (Object)ObjectParser.fromSpec("java.lang.String( foo)"));
        ObjectParserTest.assertEquals((Object)"foo", (Object)ObjectParser.fromSpec("java.lang.String( \"foo\")"));
        ObjectParserTest.assertEquals((Object)"foo", (Object)ObjectParser.fromSpec("java.lang.String( foo )"));
        ObjectParserTest.assertEquals((Object)"foo", (Object)ObjectParser.fromSpec("java.lang.String( \"f\\oo\" )"));
        ObjectParserTest.assertEquals((Object)"f\\oo", (Object)ObjectParser.fromSpec("java.lang.String( f\\oo )"));
        ObjectParserTest.assertEquals((Object)"foo", (Object)ObjectParser.fromSpec("java.lang.String( \"foo\" )"));
        ObjectParserTest.assertEquals((Object)"fo\"o", (Object)ObjectParser.fromSpec("java.lang.String(\"fo\\\"o\")"));
        boolean error = false;
        try {
            ObjectParser.fromSpec("java.lang.String(\"fo\"o\")");
        }
        catch (IllegalArgumentException thisIsWhatWeWant) {
            error = true;
        }
        ObjectParserTest.assertTrue((boolean)error);
        error = false;
        try {
            ObjectParser.fromSpec("java.lang.String(fo");
        }
        catch (IllegalArgumentException thisIsWhatWeWant) {
            error = true;
        }
        ObjectParserTest.assertTrue((boolean)error);
        error = false;
        try {
            ObjectParser.fromSpec("java.lang.String()", Set.class);
        }
        catch (ClassCastException thisIsWhatWeWant) {
            error = true;
        }
        ObjectParserTest.assertTrue((boolean)error);
        ObjectParserTest.assertEquals((Object)"", (Object)ObjectParser.fromSpec("java.lang.String()"));
        ObjectParserTest.assertEquals((Object)"", (Object)ObjectParser.fromSpec("java.lang.String"));
        ObjectParserTest.assertEquals((Object)")foo", (Object)ObjectParser.fromSpec("java.lang.String()foo)"));
    }

    public void testTwoStrings() throws Exception {
        Object context = new Object();
        ObjectParserTest.assertEquals((Object)new TwoStrings("foo", "bar"), (Object)ObjectParser.fromSpec("test.it.unimi.dsi.lang.TwoStrings(\"foo\", \"bar\")"));
        ObjectParserTest.assertEquals((Object)new TwoStrings("foo", "bar"), (Object)ObjectParser.fromSpec("test.it.unimi.dsi.lang.TwoStrings(foo, bar)"));
        ObjectParserTest.assertEquals((Object)new TwoStrings("foo", "bar"), (Object)ObjectParser.fromSpec("test.it.unimi.dsi.lang.TwoStrings( foo , bar )"));
        ObjectParserTest.assertEquals((Object)new TwoStrings("", ""), (Object)ObjectParser.fromSpec("test.it.unimi.dsi.lang.TwoStrings(,)"));
        ObjectParserTest.assertEquals((Object)new TwoStrings("", ""), (Object)ObjectParser.fromSpec("test.it.unimi.dsi.lang.TwoStrings( , )"));
        ObjectParserTest.assertEquals((Object)new TwoStrings("", ""), (Object)ObjectParser.fromSpec("test.it.unimi.dsi.lang.TwoStrings( ,\"\" )"));
        ObjectParserTest.assertEquals((Object)new TwoStrings("foo", "foo"), (Object)ObjectParser.fromSpec("test.it.unimi.dsi.lang.TwoStrings(foo)", Object.class, null, new String[]{"getInstance"}));
        ObjectParserTest.assertEquals((Object)new TwoStrings("3", "3"), (Object)ObjectParser.fromSpec("test.it.unimi.dsi.lang.TwoStrings(foo,bar,boo)", Object.class, null, new String[]{"getInstance"}));
        ObjectParserTest.assertEquals((Object)new TwoStrings("foo", "3"), (Object)ObjectParser.fromSpec("test.it.unimi.dsi.lang.TwoStrings(foo,bar,boo)", Object.class));
        ObjectParserTest.assertEquals((Object)new TwoStrings(context, "foo", "bar"), (Object)ObjectParser.fromSpec(context, "test.it.unimi.dsi.lang.TwoStrings(\"foo\", \"bar\")"));
        ObjectParserTest.assertEquals((Object)new TwoStrings(context, "foo", "bar"), (Object)ObjectParser.fromSpec(context, "test.it.unimi.dsi.lang.TwoStrings(foo, bar)"));
        ObjectParserTest.assertEquals((Object)new TwoStrings(context, "foo", "bar"), (Object)ObjectParser.fromSpec(context, "test.it.unimi.dsi.lang.TwoStrings( foo , bar )"));
        ObjectParserTest.assertEquals((Object)new TwoStrings(context, "", ""), (Object)ObjectParser.fromSpec(context, "test.it.unimi.dsi.lang.TwoStrings(,)"));
        ObjectParserTest.assertEquals((Object)new TwoStrings(context, "", ""), (Object)ObjectParser.fromSpec(context, "test.it.unimi.dsi.lang.TwoStrings( , )"));
        ObjectParserTest.assertEquals((Object)new TwoStrings(context, "", ""), (Object)ObjectParser.fromSpec(context, "test.it.unimi.dsi.lang.TwoStrings( ,\"\" )"));
        ObjectParserTest.assertEquals((Object)new TwoStrings(context, "foo", "foo"), (Object)ObjectParser.fromSpec(context, "test.it.unimi.dsi.lang.TwoStrings(foo)", Object.class, null, new String[]{"getInstance"}));
        ObjectParserTest.assertEquals((Object)new TwoStrings(context, "3", "3"), (Object)ObjectParser.fromSpec(context, "test.it.unimi.dsi.lang.TwoStrings(foo,bar,boo)", Object.class, null, new String[]{"getInstance"}));
        ObjectParserTest.assertEquals((Object)new TwoStrings(context, "foo", "3"), (Object)ObjectParser.fromSpec(context, "test.it.unimi.dsi.lang.TwoStrings(foo,bar,boo)", Object.class));
    }
}

