/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.CloseableIterable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public abstract class BaseTest
extends TestCase {
    double timer = -1.0;

    public static <T> T getOnlyElement(Iterator<T> iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        T element = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("Iterator has multiple elmenets");
        }
        return element;
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return BaseTest.getOnlyElement(iterable.iterator());
    }

    public static int count(Iterator iterator) {
        int counter = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++counter;
        }
        return counter;
    }

    public static int count(Iterable iterable) {
        return BaseTest.count(iterable.iterator());
    }

    public static int count(CloseableIterable iterable) {
        return BaseTest.count(iterable.iterator());
    }

    public static <T> List<T> asList(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T object : iterable) {
            list.add(object);
        }
        return list;
    }

    public double stopWatch() {
        if (this.timer == -1.0) {
            this.timer = (double)System.nanoTime() / 1000000.0;
            return -1.0;
        }
        double temp = (double)System.nanoTime() / 1000000.0 - this.timer;
        this.timer = -1.0;
        return temp;
    }

    public static void printPerformance(String name, Integer events, String eventName, double timeInMilliseconds) {
        if (null != events) {
            System.out.println("\t" + name + ": " + events + " " + eventName + " in " + timeInMilliseconds + "ms");
        } else {
            System.out.println("\t" + name + ": " + eventName + " in " + timeInMilliseconds + "ms");
        }
    }

    public static void printTestPerformance(String testName, double timeInMilliseconds) {
        System.out.println("*** TOTAL TIME [" + testName + "]: " + timeInMilliseconds + " ***");
    }

    public static void equalIterators(Iterator itty1, Iterator itty2) {
        BaseTest.assertEquals((boolean)itty1.hasNext(), (boolean)itty2.hasNext());
        while (itty1.hasNext()) {
            BaseTest.assertEquals((boolean)itty1.hasNext(), (boolean)itty2.hasNext());
            BaseTest.assertEquals(itty1.next(), itty2.next());
        }
        BaseTest.assertEquals((boolean)itty1.hasNext(), (boolean)itty2.hasNext());
    }

    protected static void deleteDirectory(File directory) {
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    BaseTest.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
            directory.delete();
        }
        if (directory.exists()) {
            throw new RuntimeException("unable to delete directory " + directory.getAbsolutePath());
        }
    }

    public File computeTestDataRoot() {
        String clsUri = ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".class";
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(clsUri);
        String clsPath = url.getPath();
        File root = new File(clsPath.substring(0, clsPath.length() - clsUri.length()));
        return new File(root.getParentFile(), "test-data");
    }
}

