/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Contains;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class GraphQueryTestSuite
extends TestSuite {
    public GraphQueryTestSuite() {
    }

    public GraphQueryTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testGraphQueryForVertices() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIndex.booleanValue() && graph instanceof KeyIndexableGraph) {
            ((KeyIndexableGraph)graph).createKeyIndex("name", Vertex.class, new Parameter[0]);
        }
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex vertex = graph.addVertex(null);
            vertex.setProperty("name", (Object)"marko");
            vertex.setProperty("age", (Object)33);
            vertex = graph.addVertex(null);
            vertex.setProperty("name", (Object)"matthias");
            vertex.setProperty("age", (Object)28);
            graph.addVertex(null);
            Iterable vertices = graph.query().vertices();
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(vertices), (int)3);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(vertices), (int)3);
            HashSet<String> names = new HashSet<String>();
            for (Vertex v : vertices) {
                names.add((String)v.getProperty("name"));
            }
            GraphQueryTestSuite.assertEquals((int)names.size(), (int)3);
            GraphQueryTestSuite.assertTrue((boolean)names.contains("marko"));
            GraphQueryTestSuite.assertTrue((boolean)names.contains(null));
            GraphQueryTestSuite.assertTrue((boolean)names.contains("matthias"));
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().limit(0).vertices()), (int)0);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().limit(1).vertices()), (int)1);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().limit(2).vertices()), (int)2);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().limit(3).vertices()), (int)3);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().limit(4).vertices()), (int)3);
            vertices = graph.query().has("name", (Object)"marko").vertices();
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(vertices), (int)1);
            vertices = graph.query().has("age", (Predicate)Compare.GREATER_THAN_EQUAL, (Object)29).vertices();
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(vertices), (int)1);
            GraphQueryTestSuite.assertEquals((Object)((Vertex)vertices.iterator().next()).getProperty("name"), (Object)"marko");
            GraphQueryTestSuite.assertEquals((Object)((Vertex)vertices.iterator().next()).getProperty("age"), (Object)33);
            vertices = graph.query().has("age", (Predicate)Compare.GREATER_THAN_EQUAL, (Object)28).vertices();
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(vertices), (int)2);
            names = new HashSet();
            for (Vertex v : vertices) {
                names.add((String)v.getProperty("name"));
            }
            GraphQueryTestSuite.assertEquals((int)names.size(), (int)2);
            GraphQueryTestSuite.assertTrue((boolean)names.contains("marko"));
            GraphQueryTestSuite.assertTrue((boolean)names.contains("matthias"));
            vertices = graph.query().interval("age", (Comparable)Integer.valueOf(28), (Comparable)Integer.valueOf(33)).vertices();
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(vertices), (int)1);
            GraphQueryTestSuite.assertEquals((Object)((Vertex)vertices.iterator().next()).getProperty("name"), (Object)"matthias");
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().hasNot("age").vertices()), (int)1);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("age", (Object)28).has("name", (Object)"matthias").vertices()), (int)1);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("age", (Object)28).has("name", (Object)"matthias").has("name", (Object)"matthias").vertices()), (int)1);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().interval("age", (Comparable)Integer.valueOf(28), (Comparable)Integer.valueOf(32)).has("name", (Object)"marko").vertices()), (int)0);
        }
        graph.shutdown();
    }

    public void testGraphQueryForEdges() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIndex.booleanValue() && graph instanceof KeyIndexableGraph) {
            ((KeyIndexableGraph)graph).createKeyIndex("type", Edge.class, new Parameter[0]);
        }
        if (graph.getFeatures().supportsEdgeProperties.booleanValue() && graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex marko = graph.addVertex(null);
            marko.setProperty("name", (Object)"marko");
            Vertex matthias = graph.addVertex(null);
            matthias.setProperty("name", (Object)"matthias");
            Vertex stephen = graph.addVertex(null);
            stephen.setProperty("name", (Object)"stephen");
            Edge edge = marko.addEdge("knows", stephen);
            edge.setProperty("type", (Object)"tinkerpop");
            edge.setProperty("weight", (Object)1.0);
            edge = marko.addEdge("knows", matthias);
            edge.setProperty("type", (Object)"aurelius");
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().edges()), (int)2);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().limit(0).edges()), (int)0);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().limit(1).edges()), (int)1);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().limit(2).edges()), (int)2);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().limit(3).edges()), (int)2);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("type", (Object)"tinkerpop").has("type", (Object)"tinkerpop").edges()), (int)1);
            GraphQueryTestSuite.assertEquals((Object)((Edge)graph.query().has("type", (Object)"tinkerpop").edges().iterator().next()).getProperty("weight"), (Object)1.0);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("type", (Object)"aurelius").edges()), (int)1);
            GraphQueryTestSuite.assertEquals((int)((Edge)graph.query().has("type", (Object)"aurelius").edges().iterator().next()).getPropertyKeys().size(), (int)1);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().hasNot("weight").edges()), (int)1);
            GraphQueryTestSuite.assertEquals((Object)((Edge)graph.query().hasNot("weight").edges().iterator().next()).getProperty("type"), (Object)"aurelius");
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("weight", (Object)1.0).edges()), (int)1);
            GraphQueryTestSuite.assertEquals((Object)((Edge)graph.query().has("weight", (Object)1.0).edges().iterator().next()).getProperty("type"), (Object)"tinkerpop");
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("weight", (Object)1.0).has("type", (Object)"tinkerpop").edges()), (int)1);
            GraphQueryTestSuite.assertEquals((Object)((Edge)graph.query().has("weight", (Object)1.0).has("type", (Object)"tinkerpop").edges().iterator().next()).getProperty("type"), (Object)"tinkerpop");
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("weight", (Object)1.0).has("type", (Object)"aurelius").edges()), (int)0);
            GraphQueryTestSuite.assertEquals((Object)((Edge)graph.query().interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.1)).edges().iterator().next()).getProperty("type"), (Object)"tinkerpop");
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).edges()), (int)0);
        }
        graph.shutdown();
    }

    public void testGraphQueryForHasOR() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIndex.booleanValue() && graph instanceof KeyIndexableGraph) {
            ((KeyIndexableGraph)graph).createKeyIndex("type", Edge.class, new Parameter[0]);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsEdgeProperties.booleanValue() && graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex marko = graph.addVertex(null);
            marko.setProperty("name", (Object)"marko");
            Vertex matthias = graph.addVertex(null);
            matthias.setProperty("name", (Object)"matthias");
            Vertex stephen = graph.addVertex(null);
            stephen.setProperty("name", (Object)"stephen");
            Edge edge = marko.addEdge("knows", stephen);
            edge.setProperty("type", (Object)"tinkerpop");
            edge.setProperty("weight", (Object)1.0);
            edge = marko.addEdge("knows", matthias);
            edge.setProperty("type", (Object)"aurelius");
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("type", (Predicate)Contains.IN, Arrays.asList("tinkerpop", "aurelius")).edges()), (int)2);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("type", (Predicate)Contains.IN, Arrays.asList("tinkerpop", "aurelius")).has("type", (Object)"tinkerpop").edges()), (int)1);
            GraphQueryTestSuite.assertEquals((int)GraphQueryTestSuite.count(graph.query().has("type", (Predicate)Contains.IN, Arrays.asList("tinkerpop", "aurelius")).has("type", (Object)"tinkerpop").has("type", (Object)"aurelius").edges()), (int)0);
            GraphQueryTestSuite.assertEquals((Object)((Edge)graph.query().has("weight").edges().iterator().next()).getProperty("type"), (Object)"tinkerpop");
            GraphQueryTestSuite.assertEquals((Object)((Edge)graph.query().has("weight").edges().iterator().next()).getProperty("weight"), (Object)1.0);
            GraphQueryTestSuite.assertEquals((Object)((Edge)graph.query().hasNot("weight").edges().iterator().next()).getProperty("type"), (Object)"aurelius");
            GraphQueryTestSuite.assertNull((Object)((Edge)graph.query().hasNot("weight").edges().iterator().next()).getProperty("weight"));
            List result = GraphQueryTestSuite.asList(graph.query().has("name", (Predicate)Contains.IN, Arrays.asList("marko", "stephen")).vertices());
            GraphQueryTestSuite.assertEquals((int)result.size(), (int)2);
            GraphQueryTestSuite.assertTrue((boolean)result.contains(marko));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(stephen));
            result = GraphQueryTestSuite.asList(graph.query().has("name", (Predicate)Contains.IN, Arrays.asList("marko", "stephen", "matthias", "josh", "peter")).vertices());
            GraphQueryTestSuite.assertEquals((int)result.size(), (int)3);
            GraphQueryTestSuite.assertTrue((boolean)result.contains(marko));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(stephen));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(matthias));
            result = GraphQueryTestSuite.asList(graph.query().has("name").vertices());
            GraphQueryTestSuite.assertEquals((int)result.size(), (int)3);
            GraphQueryTestSuite.assertTrue((boolean)result.contains(marko));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(stephen));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(matthias));
            result = GraphQueryTestSuite.asList(graph.query().hasNot("name").vertices());
            GraphQueryTestSuite.assertEquals((int)result.size(), (int)0);
            result = GraphQueryTestSuite.asList(graph.query().hasNot("blah").vertices());
            GraphQueryTestSuite.assertEquals((int)result.size(), (int)3);
            GraphQueryTestSuite.assertTrue((boolean)result.contains(marko));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(stephen));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(matthias));
            result = GraphQueryTestSuite.asList(graph.query().has("name", (Predicate)Contains.NOT_IN, Arrays.asList("bill", "sam")).vertices());
            GraphQueryTestSuite.assertEquals((int)result.size(), (int)3);
            GraphQueryTestSuite.assertTrue((boolean)result.contains(marko));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(stephen));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(matthias));
            result = GraphQueryTestSuite.asList(graph.query().has("name", (Predicate)Contains.IN, Arrays.asList("bill", "matthias", "stephen", "marko")).vertices());
            GraphQueryTestSuite.assertEquals((int)result.size(), (int)3);
            GraphQueryTestSuite.assertTrue((boolean)result.contains(marko));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(stephen));
            GraphQueryTestSuite.assertTrue((boolean)result.contains(matthias));
        }
        graph.shutdown();
    }
}

