/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.BaseTest;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import java.util.Collection;

public abstract class TestSuite
extends BaseTest {
    protected GraphTest graphTest;

    public TestSuite() {
    }

    public TestSuite(GraphTest graphTest) {
        this.graphTest = graphTest;
    }

    protected void vertexCount(Graph graph, int expectedCount) {
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            TestSuite.assertEquals((int)TestSuite.count(graph.getVertices()), (int)expectedCount);
        }
    }

    protected void containsVertices(Graph graph, Collection<Vertex> vertices) {
        for (Vertex v : vertices) {
            Vertex vp = graph.getVertex(v.getId());
            if (vp != null && vp.getId().equals(v.getId())) continue;
            TestSuite.fail((String)("Graph does not contain vertex: '" + v + "'"));
        }
    }

    protected void edgeCount(Graph graph, int expectedCount) {
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            TestSuite.assertEquals((int)TestSuite.count(graph.getEdges()), (int)expectedCount);
        }
    }
}

