/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.gml;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.util.io.gml.GMLReader;
import com.tinkerpop.blueprints.util.io.graphml.GraphMigrator;
import java.util.HashSet;

public class GMLReaderTestSuite
extends TestSuite {
    public GMLReaderTestSuite() {
    }

    public GMLReaderTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testReadingTinkerGraph() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            this.stopWatch();
            GMLReader gmlReader = new GMLReader(graph);
            gmlReader.inputGraph(GMLReader.class.getResourceAsStream("graph-example-1.gml"));
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)"1").getEdges(Direction.OUT, new String[0])), (int)3);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)"1").getEdges(Direction.IN, new String[0])), (int)0);
            Vertex marko = graph.getVertex((Object)"1");
            GMLReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GMLReaderTestSuite.assertEquals((Object)marko.getProperty("age"), (Object)29);
            int counter = 0;
            for (Edge e : graph.getVertex((Object)"1").getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("2")) {
                    GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                    ++counter;
                    continue;
                }
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GMLReaderTestSuite.assertEquals((int)0, (int)Math.round(((Number)e.getProperty("weight")).floatValue()));
                    GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("4")) continue;
                GMLReaderTestSuite.assertEquals((int)1, (int)Math.round(((Number)e.getProperty("weight")).floatValue()));
                GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                ++counter;
            }
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)"4").getEdges(Direction.OUT, new String[0])), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)"4").getEdges(Direction.IN, new String[0])), (int)1);
            Vertex josh = graph.getVertex((Object)"4");
            GMLReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GMLReaderTestSuite.assertEquals((Object)josh.getProperty("age"), (Object)32);
            for (Edge e : graph.getVertex((Object)"4").getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GMLReaderTestSuite.assertEquals((int)0, (int)Math.round(((Number)e.getProperty("weight")).floatValue()));
                    GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("5")) continue;
                GMLReaderTestSuite.assertEquals((int)1, (int)Math.round(((Number)e.getProperty("weight")).floatValue()));
                GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                ++counter;
            }
            GMLReaderTestSuite.assertEquals((int)counter, (int)5);
        }
        graph.shutdown();
    }

    public void testTinkerGraphEdges() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            this.stopWatch();
            GMLReader gmlReader = new GMLReader(graph);
            gmlReader.inputGraph(GMLReader.class.getResourceAsStream("graph-example-1.gml"));
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            HashSet<String> edgeValues = new HashSet<String>();
            int count = 0;
            for (Edge e : graph.getEdges()) {
                ++count;
                edgeIds.add(e.getId().toString());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                    edgeValues.add(e.getProperty(key).toString());
                }
            }
            GMLReaderTestSuite.assertEquals((int)count, (int)6);
            GMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)1);
            GMLReaderTestSuite.assertEquals((int)edgeValues.size(), (int)4);
        }
        graph.shutdown();
    }

    public void testTinkerGraphVertices() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GMLReader(graph).inputGraph(GMLReader.class.getResourceAsStream("graph-example-1.gml"));
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            HashSet<String> vertexNames = new HashSet<String>();
            int count = 0;
            for (Vertex v : graph.getVertices()) {
                ++count;
                vertexNames.add(v.getProperty("name").toString());
            }
            GMLReaderTestSuite.assertEquals((int)count, (int)6);
            GMLReaderTestSuite.assertEquals((int)vertexNames.size(), (int)6);
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("marko"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("josh"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("peter"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("vadas"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("ripple"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("lop"));
        }
        graph.shutdown();
    }

    public void testTinkerGraphSoftwareVertices() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GMLReader(graph).inputGraph(GMLReader.class.getResourceAsStream("graph-example-1.gml"));
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            HashSet<Vertex> softwareVertices = new HashSet<Vertex>();
            int count = 0;
            for (Vertex v : graph.getVertices()) {
                ++count;
                String name = v.getProperty("name").toString();
                if (!name.equals("lop") && !name.equals("ripple")) continue;
                softwareVertices.add(v);
            }
            GMLReaderTestSuite.assertEquals((int)count, (int)6);
            GMLReaderTestSuite.assertEquals((int)softwareVertices.size(), (int)2);
            for (Vertex v : softwareVertices) {
                GMLReaderTestSuite.assertEquals((Object)v.getProperty("lang"), (Object)"java");
            }
        }
        graph.shutdown();
    }

    public void testTinkerGraphVertexAndEdges() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            GMLReader gmlReader = new GMLReader(graph);
            gmlReader.inputGraph(GMLReader.class.getResourceAsStream("graph-example-1.gml"));
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            Vertex marko = null;
            Vertex peter = null;
            Vertex josh = null;
            Vertex vadas = null;
            Vertex lop = null;
            Vertex ripple = null;
            int count = 0;
            for (Vertex v : graph.getVertices()) {
                ++count;
                String name = v.getProperty("name").toString();
                if (name.equals("marko")) {
                    marko = v;
                    continue;
                }
                if (name.equals("peter")) {
                    peter = v;
                    continue;
                }
                if (name.equals("josh")) {
                    josh = v;
                    continue;
                }
                if (name.equals("vadas")) {
                    vadas = v;
                    continue;
                }
                if (name.equals("lop")) {
                    lop = v;
                    continue;
                }
                if (name.equals("ripple")) {
                    ripple = v;
                    continue;
                }
                GMLReaderTestSuite.assertTrue((boolean)false);
            }
            GMLReaderTestSuite.assertEquals((int)count, (int)6);
            GMLReaderTestSuite.assertTrue((null != marko ? 1 : 0) != 0);
            GMLReaderTestSuite.assertTrue((null != peter ? 1 : 0) != 0);
            GMLReaderTestSuite.assertTrue((null != josh ? 1 : 0) != 0);
            GMLReaderTestSuite.assertTrue((null != vadas ? 1 : 0) != 0);
            GMLReaderTestSuite.assertTrue((null != lop ? 1 : 0) != 0);
            GMLReaderTestSuite.assertTrue((null != ripple ? 1 : 0) != 0);
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getEdges()), (int)6);
            }
            HashSet<Vertex> vertices = new HashSet<Vertex>();
            GMLReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GMLReaderTestSuite.assertEquals((int)((Number)marko.getProperty("age")).intValue(), (int)29);
            GMLReaderTestSuite.assertEquals((int)marko.getPropertyKeys().size(), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(marko.getEdges(Direction.OUT, new String[0])), (int)3);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(marko.getEdges(Direction.IN, new String[0])), (int)0);
            for (Edge e : marko.getEdges(Direction.OUT, new String[0])) {
                vertices.add(e.getVertex(Direction.IN));
            }
            GMLReaderTestSuite.assertEquals((int)vertices.size(), (int)3);
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(lop));
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(josh));
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(vadas));
            vertices = new HashSet();
            GMLReaderTestSuite.assertEquals((Object)peter.getProperty("name"), (Object)"peter");
            GMLReaderTestSuite.assertEquals((int)((Number)peter.getProperty("age")).intValue(), (int)35);
            GMLReaderTestSuite.assertEquals((int)peter.getPropertyKeys().size(), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(peter.getEdges(Direction.OUT, new String[0])), (int)1);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(peter.getEdges(Direction.IN, new String[0])), (int)0);
            for (Edge e : peter.getEdges(Direction.OUT, new String[0])) {
                vertices.add(e.getVertex(Direction.IN));
            }
            GMLReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(lop));
            vertices = new HashSet();
            GMLReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GMLReaderTestSuite.assertEquals((int)((Number)josh.getProperty("age")).intValue(), (int)32);
            GMLReaderTestSuite.assertEquals((int)josh.getPropertyKeys().size(), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(josh.getEdges(Direction.OUT, new String[0])), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(josh.getEdges(Direction.IN, new String[0])), (int)1);
            for (Edge e : josh.getEdges(Direction.OUT, new String[0])) {
                vertices.add(e.getVertex(Direction.IN));
            }
            GMLReaderTestSuite.assertEquals((int)vertices.size(), (int)2);
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(lop));
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(ripple));
            vertices = new HashSet();
            for (Edge e : josh.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GMLReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(marko));
            vertices = new HashSet();
            GMLReaderTestSuite.assertEquals((Object)vadas.getProperty("name"), (Object)"vadas");
            GMLReaderTestSuite.assertEquals((int)((Number)vadas.getProperty("age")).intValue(), (int)27);
            GMLReaderTestSuite.assertEquals((int)vadas.getPropertyKeys().size(), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(vadas.getEdges(Direction.OUT, new String[0])), (int)0);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(vadas.getEdges(Direction.IN, new String[0])), (int)1);
            for (Edge e : vadas.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GMLReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(marko));
            vertices = new HashSet();
            GMLReaderTestSuite.assertEquals((Object)lop.getProperty("name"), (Object)"lop");
            GMLReaderTestSuite.assertEquals((Object)lop.getProperty("lang"), (Object)"java");
            GMLReaderTestSuite.assertEquals((int)lop.getPropertyKeys().size(), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(lop.getEdges(Direction.OUT, new String[0])), (int)0);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(lop.getEdges(Direction.IN, new String[0])), (int)3);
            for (Edge e : lop.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GMLReaderTestSuite.assertEquals((int)vertices.size(), (int)3);
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(marko));
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(josh));
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(peter));
            vertices = new HashSet();
            GMLReaderTestSuite.assertEquals((Object)ripple.getProperty("name"), (Object)"ripple");
            GMLReaderTestSuite.assertEquals((Object)ripple.getProperty("lang"), (Object)"java");
            GMLReaderTestSuite.assertEquals((int)ripple.getPropertyKeys().size(), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(ripple.getEdges(Direction.OUT, new String[0])), (int)0);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(ripple.getEdges(Direction.IN, new String[0])), (int)1);
            for (Edge e : ripple.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GMLReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GMLReaderTestSuite.assertTrue((boolean)vertices.contains(josh));
        }
        graph.shutdown();
    }

    public void testReadingTinkerGraphExample3() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue() && graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            GMLReader gmlReader = new GMLReader(graph);
            gmlReader.setEdgeIdKey("id");
            gmlReader.inputGraph(GMLReader.class.getResourceAsStream("graph-example-3.gml"), 1000);
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)1).getEdges(Direction.OUT, new String[0])), (int)3);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)1).getEdges(Direction.IN, new String[0])), (int)0);
            Vertex marko = graph.getVertex((Object)1);
            GMLReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GMLReaderTestSuite.assertEquals((Object)marko.getProperty("age"), (Object)29);
            GMLReaderTestSuite.assertEquals((Object)marko.getProperty("id2"), (Object)2);
            int counter = 0;
            for (Edge e : graph.getVertex((Object)1).getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("2")) {
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)8);
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), (Object)"has high fived");
                    GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                    GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"7");
                    ++counter;
                    continue;
                }
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GMLReaderTestSuite.assertEquals((int)0, (int)Math.round(((Number)e.getProperty("weight")).floatValue()));
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)10);
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), (Object)"has high fived");
                    GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"9");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("4")) continue;
                GMLReaderTestSuite.assertEquals((int)1, (int)Math.round(((Number)e.getProperty("weight")).floatValue()));
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)9);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), (Object)"has high fived");
                GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"8");
                ++counter;
            }
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)2).getEdges(Direction.OUT, new String[0])), (int)0);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)2).getEdges(Direction.IN, new String[0])), (int)1);
            Vertex vadas = graph.getVertex((Object)2);
            GMLReaderTestSuite.assertEquals((Object)vadas.getProperty("name"), (Object)"vadas");
            GMLReaderTestSuite.assertEquals((Object)vadas.getProperty("age"), (Object)27);
            GMLReaderTestSuite.assertEquals((Object)vadas.getProperty("id2"), (Object)3);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)3).getEdges(Direction.OUT, new String[0])), (int)0);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)3).getEdges(Direction.IN, new String[0])), (int)3);
            Vertex lop = graph.getVertex((Object)3);
            GMLReaderTestSuite.assertEquals((Object)lop.getProperty("name"), (Object)"lop");
            GMLReaderTestSuite.assertEquals((Object)lop.getProperty("lang"), (Object)"java");
            GMLReaderTestSuite.assertEquals((Object)lop.getProperty("id2"), (Object)4);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)4).getEdges(Direction.OUT, new String[0])), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)4).getEdges(Direction.IN, new String[0])), (int)1);
            Vertex josh = graph.getVertex((Object)4);
            GMLReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GMLReaderTestSuite.assertEquals((Object)josh.getProperty("age"), (Object)32);
            for (Edge e : graph.getVertex((Object)4).getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GMLReaderTestSuite.assertEquals((int)Math.round(((Number)e.getProperty("weight")).floatValue()), (int)0);
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)13);
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), null);
                    GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"11");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("5")) continue;
                GMLReaderTestSuite.assertEquals((int)Math.round(((Number)e.getProperty("weight")).floatValue()), (int)1);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)11);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), (Object)"has high fived");
                GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"10");
                ++counter;
            }
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)5).getEdges(Direction.OUT, new String[0])), (int)0);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)5).getEdges(Direction.IN, new String[0])), (int)1);
            Vertex ripple = graph.getVertex((Object)5);
            GMLReaderTestSuite.assertEquals((Object)ripple.getProperty("name"), (Object)"ripple");
            GMLReaderTestSuite.assertEquals((Object)ripple.getProperty("lang"), (Object)"java");
            GMLReaderTestSuite.assertEquals((Object)ripple.getProperty("id2"), (Object)7);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)6).getEdges(Direction.OUT, new String[0])), (int)1);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(graph.getVertex((Object)6).getEdges(Direction.IN, new String[0])), (int)0);
            Vertex peter = graph.getVertex((Object)6);
            GMLReaderTestSuite.assertEquals((Object)peter.getProperty("name"), (Object)"peter");
            GMLReaderTestSuite.assertEquals((Object)peter.getProperty("age"), (Object)35);
            for (Edge e : graph.getVertex((Object)6).getEdges(Direction.OUT, new String[0])) {
                if (!e.getVertex(Direction.IN).getId().equals("3")) continue;
                GMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), null);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), null);
                GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"12");
                ++counter;
            }
            GMLReaderTestSuite.assertEquals((int)counter, (int)6);
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            HashSet<String> vertexNames = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : graph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                vertexNames.add(v.getProperty("name").toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : graph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("id2"), (boolean)true);
            GMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)4);
            GMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("id2"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("label2"), (boolean)true);
            GMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)3);
        }
        graph.shutdown();
    }

    public void testReadingTinkerGraphExample3MappingLabels() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            GMLReader r = new GMLReader(graph);
            r.setEdgeLabelKey("label2");
            r.setEdgeIdKey("id");
            r.inputGraph(GMLReader.class.getResourceAsStream("graph-example-3.gml"), 1000);
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            HashSet<String> vertexNames = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : graph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                vertexNames.add(v.getProperty("name").toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            HashSet<String> edgeLabels = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : graph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                edgeLabels.add(e.getLabel());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("id2"), (boolean)true);
            GMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)4);
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("marko"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("josh"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("peter"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("vadas"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("ripple"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("lop"));
            GMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("id2"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("label2"), (boolean)false);
            GMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)2);
            GMLReaderTestSuite.assertEquals((int)edgeLabels.size(), (int)2);
            GMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("has high fived"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("knows"), (boolean)false);
            GMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("created"), (boolean)true);
        }
        graph.shutdown();
    }

    public void testReadingTinkerGraphExample3MappingIDs() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            GMLReader r = new GMLReader(graph);
            r.setVertexIdKey("id2");
            r.setEdgeIdKey("id2");
            r.inputGraph(GMLReader.class.getResourceAsStream("graph-example-3.gml"), 1000);
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            HashSet<String> vertexNames = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : graph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                vertexNames.add(v.getProperty("name").toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            HashSet<String> edgeLabels = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : graph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                edgeLabels.add(e.getLabel());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("id2"), (boolean)false);
            GMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)3);
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("marko"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("josh"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("peter"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("vadas"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("ripple"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("lop"));
            GMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("id2"), (boolean)false);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("label2"), (boolean)true);
            GMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)2);
            GMLReaderTestSuite.assertEquals((int)edgeLabels.size(), (int)2);
            GMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("has high fived"), (boolean)false);
            GMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("knows"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("created"), (boolean)true);
        }
        graph.shutdown();
    }

    public void testReadingTinkerGraphExample3MappingAll() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            GMLReader r = new GMLReader(graph);
            r.setVertexIdKey("id2");
            r.setEdgeIdKey("id2");
            r.setEdgeLabelKey("label2");
            r.inputGraph(GMLReader.class.getResourceAsStream("graph-example-3.gml"), 1000);
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            HashSet<String> vertexNames = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : graph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                vertexNames.add(v.getProperty("name").toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            HashSet<String> edgeLabels = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : graph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                edgeLabels.add(e.getLabel());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("id2"), (boolean)false);
            GMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)3);
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("marko"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("josh"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("peter"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("vadas"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("ripple"));
            GMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("lop"));
            GMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("id2"), (boolean)false);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("label2"), (boolean)false);
            GMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)1);
            GMLReaderTestSuite.assertEquals((int)edgeLabels.size(), (int)2);
            GMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("has high fived"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("knows"), (boolean)false);
            GMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("created"), (boolean)true);
        }
        graph.shutdown();
    }

    public void testMigratingTinkerGraphExample3() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue() && graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            GMLReader gmlReader = new GMLReader(graph);
            gmlReader.setEdgeIdKey("id");
            gmlReader.inputGraph(GMLReader.class.getResourceAsStream("graph-example-3.gml"), 1000);
            GMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            this.stopWatch();
            TinkerGraph toGraph = new TinkerGraph();
            GraphMigrator.migrateGraph((Graph)graph, (Graph)toGraph);
            GMLReaderTestSuite.printPerformance(toGraph.toString(), null, "graph-example-3 migrated", this.stopWatch());
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)1).getEdges(Direction.OUT, new String[0])), (int)3);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)1).getEdges(Direction.IN, new String[0])), (int)0);
            Vertex marko = toGraph.getVertex((Object)1);
            GMLReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GMLReaderTestSuite.assertEquals((Object)marko.getProperty("age"), (Object)29);
            GMLReaderTestSuite.assertEquals((Object)marko.getProperty("id2"), (Object)2);
            int counter = 0;
            for (Edge e : toGraph.getVertex((Object)1).getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("2")) {
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)8);
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), (Object)"has high fived");
                    GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                    GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"7");
                    ++counter;
                    continue;
                }
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)10);
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), (Object)"has high fived");
                    GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"9");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("4")) continue;
                GMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)1);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)9);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), (Object)"has high fived");
                GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"8");
                ++counter;
            }
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)2).getEdges(Direction.OUT, new String[0])), (int)0);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)2).getEdges(Direction.IN, new String[0])), (int)1);
            Vertex vadas = toGraph.getVertex((Object)2);
            GMLReaderTestSuite.assertEquals((Object)vadas.getProperty("name"), (Object)"vadas");
            GMLReaderTestSuite.assertEquals((Object)vadas.getProperty("age"), (Object)27);
            GMLReaderTestSuite.assertEquals((Object)vadas.getProperty("id2"), (Object)3);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)3).getEdges(Direction.OUT, new String[0])), (int)0);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)3).getEdges(Direction.IN, new String[0])), (int)3);
            Vertex lop = toGraph.getVertex((Object)3);
            GMLReaderTestSuite.assertEquals((Object)lop.getProperty("name"), (Object)"lop");
            GMLReaderTestSuite.assertEquals((Object)lop.getProperty("lang"), (Object)"java");
            GMLReaderTestSuite.assertEquals((Object)lop.getProperty("id2"), (Object)4);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)4).getEdges(Direction.OUT, new String[0])), (int)2);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)4).getEdges(Direction.IN, new String[0])), (int)1);
            Vertex josh = toGraph.getVertex((Object)4);
            GMLReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GMLReaderTestSuite.assertEquals((Object)josh.getProperty("age"), (Object)32);
            for (Edge e : toGraph.getVertex((Object)4).getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)13);
                    GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), null);
                    GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"11");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("5")) continue;
                GMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)1);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), (Object)11);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), (Object)"has high fived");
                GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"10");
                ++counter;
            }
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)5).getEdges(Direction.OUT, new String[0])), (int)0);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)5).getEdges(Direction.IN, new String[0])), (int)1);
            Vertex ripple = toGraph.getVertex((Object)5);
            GMLReaderTestSuite.assertEquals((Object)ripple.getProperty("name"), (Object)"ripple");
            GMLReaderTestSuite.assertEquals((Object)ripple.getProperty("lang"), (Object)"java");
            GMLReaderTestSuite.assertEquals((Object)ripple.getProperty("id2"), (Object)7);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)6).getEdges(Direction.OUT, new String[0])), (int)1);
            GMLReaderTestSuite.assertEquals((int)GMLReaderTestSuite.count(toGraph.getVertex((Object)6).getEdges(Direction.IN, new String[0])), (int)0);
            Vertex peter = toGraph.getVertex((Object)6);
            GMLReaderTestSuite.assertEquals((Object)peter.getProperty("name"), (Object)"peter");
            GMLReaderTestSuite.assertEquals((Object)peter.getProperty("age"), (Object)35);
            for (Edge e : toGraph.getVertex((Object)6).getEdges(Direction.OUT, new String[0])) {
                if (!e.getVertex(Direction.IN).getId().equals("3")) continue;
                GMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("id2"), null);
                GMLReaderTestSuite.assertEquals((Object)e.getProperty("label2"), null);
                GMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"12");
                ++counter;
            }
            GMLReaderTestSuite.assertEquals((int)counter, (int)6);
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : toGraph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : toGraph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("id2"), (boolean)true);
            GMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)4);
            GMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("id2"), (boolean)true);
            GMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("label2"), (boolean)true);
            GMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)3);
        }
        graph.shutdown();
    }
}

