/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.graphml;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLReader;
import com.tinkerpop.blueprints.util.io.graphml.GraphMigrator;
import java.util.HashSet;

public class GraphMLReaderTestSuite
extends TestSuite {
    public GraphMLReaderTestSuite() {
    }

    public GraphMLReaderTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testReadingTinkerGraph() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            this.stopWatch();
            new GraphMLReader(graph).inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-1.xml"));
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"1").getEdges(Direction.OUT, new String[0])), (int)3);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"1").getEdges(Direction.IN, new String[0])), (int)0);
            Vertex marko = graph.getVertex((Object)"1");
            GraphMLReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GraphMLReaderTestSuite.assertEquals((Object)marko.getProperty("age"), (Object)29);
            int counter = 0;
            for (Edge e : graph.getVertex((Object)"1").getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("2")) {
                    GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                    GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"7");
                    ++counter;
                    continue;
                }
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                    GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"9");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("4")) continue;
                GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)1);
                GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"8");
                ++counter;
            }
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"4").getEdges(Direction.OUT, new String[0])), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"4").getEdges(Direction.IN, new String[0])), (int)1);
            Vertex josh = graph.getVertex((Object)"4");
            GraphMLReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GraphMLReaderTestSuite.assertEquals((Object)josh.getProperty("age"), (Object)32);
            for (Edge e : graph.getVertex((Object)"4").getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                    GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"11");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("5")) continue;
                GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)1);
                GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"10");
                ++counter;
            }
            GraphMLReaderTestSuite.assertEquals((int)counter, (int)5);
        }
        graph.shutdown();
    }

    public void testTinkerGraphEdges() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            this.stopWatch();
            new GraphMLReader(graph).inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-1.xml"));
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            HashSet<String> edgeValues = new HashSet<String>();
            int count = 0;
            for (Edge e : graph.getEdges()) {
                ++count;
                edgeIds.add(e.getId().toString());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                    edgeValues.add(e.getProperty(key).toString());
                }
            }
            GraphMLReaderTestSuite.assertEquals((int)count, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)1);
            GraphMLReaderTestSuite.assertEquals((int)edgeValues.size(), (int)4);
        }
        graph.shutdown();
    }

    public void testTinkerGraphVertices() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GraphMLReader(graph).inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-1.xml"));
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            HashSet<String> vertexNames = new HashSet<String>();
            int count = 0;
            for (Vertex v : graph.getVertices()) {
                ++count;
                vertexNames.add(v.getProperty("name").toString());
            }
            GraphMLReaderTestSuite.assertEquals((int)count, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)vertexNames.size(), (int)6);
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("marko"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("josh"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("peter"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("vadas"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("ripple"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("lop"));
        }
        graph.shutdown();
    }

    public void testTinkerGraphSoftwareVertices() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GraphMLReader(graph).inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-1.xml"));
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            HashSet<Vertex> softwareVertices = new HashSet<Vertex>();
            int count = 0;
            for (Vertex v : graph.getVertices()) {
                ++count;
                String name = v.getProperty("name").toString();
                if (!name.equals("lop") && !name.equals("ripple")) continue;
                softwareVertices.add(v);
            }
            GraphMLReaderTestSuite.assertEquals((int)count, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)softwareVertices.size(), (int)2);
            for (Vertex v : softwareVertices) {
                GraphMLReaderTestSuite.assertEquals((Object)v.getProperty("lang"), (Object)"java");
            }
        }
        graph.shutdown();
    }

    public void testTinkerGraphVertexAndEdges() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GraphMLReader(graph).inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-1.xml"));
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            Vertex marko = null;
            Vertex peter = null;
            Vertex josh = null;
            Vertex vadas = null;
            Vertex lop = null;
            Vertex ripple = null;
            int count = 0;
            for (Vertex v : graph.getVertices()) {
                ++count;
                String name = v.getProperty("name").toString();
                if (name.equals("marko")) {
                    marko = v;
                    continue;
                }
                if (name.equals("peter")) {
                    peter = v;
                    continue;
                }
                if (name.equals("josh")) {
                    josh = v;
                    continue;
                }
                if (name.equals("vadas")) {
                    vadas = v;
                    continue;
                }
                if (name.equals("lop")) {
                    lop = v;
                    continue;
                }
                if (name.equals("ripple")) {
                    ripple = v;
                    continue;
                }
                GraphMLReaderTestSuite.assertTrue((boolean)false);
            }
            GraphMLReaderTestSuite.assertEquals((int)count, (int)6);
            GraphMLReaderTestSuite.assertTrue((null != marko ? 1 : 0) != 0);
            GraphMLReaderTestSuite.assertTrue((null != peter ? 1 : 0) != 0);
            GraphMLReaderTestSuite.assertTrue((null != josh ? 1 : 0) != 0);
            GraphMLReaderTestSuite.assertTrue((null != vadas ? 1 : 0) != 0);
            GraphMLReaderTestSuite.assertTrue((null != lop ? 1 : 0) != 0);
            GraphMLReaderTestSuite.assertTrue((null != ripple ? 1 : 0) != 0);
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getEdges()), (int)6);
            }
            HashSet<Vertex> vertices = new HashSet<Vertex>();
            GraphMLReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GraphMLReaderTestSuite.assertEquals((int)((Number)marko.getProperty("age")).intValue(), (int)29);
            GraphMLReaderTestSuite.assertEquals((int)marko.getPropertyKeys().size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(marko.getEdges(Direction.OUT, new String[0])), (int)3);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(marko.getEdges(Direction.IN, new String[0])), (int)0);
            for (Edge e : marko.getEdges(Direction.OUT, new String[0])) {
                vertices.add(e.getVertex(Direction.IN));
            }
            GraphMLReaderTestSuite.assertEquals((int)vertices.size(), (int)3);
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(lop));
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(josh));
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(vadas));
            vertices = new HashSet();
            GraphMLReaderTestSuite.assertEquals((Object)peter.getProperty("name"), (Object)"peter");
            GraphMLReaderTestSuite.assertEquals((int)((Number)peter.getProperty("age")).intValue(), (int)35);
            GraphMLReaderTestSuite.assertEquals((int)peter.getPropertyKeys().size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(peter.getEdges(Direction.OUT, new String[0])), (int)1);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(peter.getEdges(Direction.IN, new String[0])), (int)0);
            for (Edge e : peter.getEdges(Direction.OUT, new String[0])) {
                vertices.add(e.getVertex(Direction.IN));
            }
            GraphMLReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(lop));
            vertices = new HashSet();
            GraphMLReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GraphMLReaderTestSuite.assertEquals((int)((Number)josh.getProperty("age")).intValue(), (int)32);
            GraphMLReaderTestSuite.assertEquals((int)josh.getPropertyKeys().size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(josh.getEdges(Direction.OUT, new String[0])), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(josh.getEdges(Direction.IN, new String[0])), (int)1);
            for (Edge e : josh.getEdges(Direction.OUT, new String[0])) {
                vertices.add(e.getVertex(Direction.IN));
            }
            GraphMLReaderTestSuite.assertEquals((int)vertices.size(), (int)2);
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(lop));
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(ripple));
            vertices = new HashSet();
            for (Edge e : josh.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GraphMLReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(marko));
            vertices = new HashSet();
            GraphMLReaderTestSuite.assertEquals((Object)vadas.getProperty("name"), (Object)"vadas");
            GraphMLReaderTestSuite.assertEquals((int)((Number)vadas.getProperty("age")).intValue(), (int)27);
            GraphMLReaderTestSuite.assertEquals((int)vadas.getPropertyKeys().size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(vadas.getEdges(Direction.OUT, new String[0])), (int)0);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(vadas.getEdges(Direction.IN, new String[0])), (int)1);
            for (Edge e : vadas.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GraphMLReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(marko));
            vertices = new HashSet();
            GraphMLReaderTestSuite.assertEquals((Object)lop.getProperty("name"), (Object)"lop");
            GraphMLReaderTestSuite.assertEquals((Object)lop.getProperty("lang"), (Object)"java");
            GraphMLReaderTestSuite.assertEquals((int)lop.getPropertyKeys().size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(lop.getEdges(Direction.OUT, new String[0])), (int)0);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(lop.getEdges(Direction.IN, new String[0])), (int)3);
            for (Edge e : lop.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GraphMLReaderTestSuite.assertEquals((int)vertices.size(), (int)3);
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(marko));
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(josh));
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(peter));
            vertices = new HashSet();
            GraphMLReaderTestSuite.assertEquals((Object)ripple.getProperty("name"), (Object)"ripple");
            GraphMLReaderTestSuite.assertEquals((Object)ripple.getProperty("lang"), (Object)"java");
            GraphMLReaderTestSuite.assertEquals((int)ripple.getPropertyKeys().size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(ripple.getEdges(Direction.OUT, new String[0])), (int)0);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(ripple.getEdges(Direction.IN, new String[0])), (int)1);
            for (Edge e : ripple.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GraphMLReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GraphMLReaderTestSuite.assertTrue((boolean)vertices.contains(josh));
        }
        graph.shutdown();
    }

    public void testReadingTinkerGraphExample3() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue() && graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GraphMLReader(graph).inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-3.xml"), 1000);
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"1").getEdges(Direction.OUT, new String[0])), (int)3);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"1").getEdges(Direction.IN, new String[0])), (int)0);
            Vertex marko = graph.getVertex((Object)"1");
            GraphMLReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GraphMLReaderTestSuite.assertEquals((Object)marko.getProperty("age"), (Object)29);
            GraphMLReaderTestSuite.assertEquals((Object)marko.getProperty("_id"), (Object)2);
            int counter = 0;
            for (Edge e : graph.getVertex((Object)"1").getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("2")) {
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)8);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), (Object)"has high fived");
                    GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                    GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"7");
                    ++counter;
                    continue;
                }
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)10);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), (Object)"has high fived");
                    GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"9");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("4")) continue;
                GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)1);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)9);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), (Object)"has high fived");
                GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"8");
                ++counter;
            }
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"2").getEdges(Direction.OUT, new String[0])), (int)0);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"2").getEdges(Direction.IN, new String[0])), (int)1);
            Vertex vadas = graph.getVertex((Object)"2");
            GraphMLReaderTestSuite.assertEquals((Object)vadas.getProperty("name"), (Object)"vadas");
            GraphMLReaderTestSuite.assertEquals((Object)vadas.getProperty("age"), (Object)27);
            GraphMLReaderTestSuite.assertEquals((Object)vadas.getProperty("_id"), (Object)3);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"3").getEdges(Direction.OUT, new String[0])), (int)0);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"3").getEdges(Direction.IN, new String[0])), (int)3);
            Vertex lop = graph.getVertex((Object)"3");
            GraphMLReaderTestSuite.assertEquals((Object)lop.getProperty("name"), (Object)"lop");
            GraphMLReaderTestSuite.assertEquals((Object)lop.getProperty("lang"), (Object)"java");
            GraphMLReaderTestSuite.assertEquals((Object)lop.getProperty("_id"), (Object)4);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"4").getEdges(Direction.OUT, new String[0])), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"4").getEdges(Direction.IN, new String[0])), (int)1);
            Vertex josh = graph.getVertex((Object)"4");
            GraphMLReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GraphMLReaderTestSuite.assertEquals((Object)josh.getProperty("age"), (Object)32);
            for (Edge e : graph.getVertex((Object)"4").getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)13);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), null);
                    GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"11");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("5")) continue;
                GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)1);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)11);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), (Object)"has high fived");
                GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"10");
                ++counter;
            }
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"5").getEdges(Direction.OUT, new String[0])), (int)0);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"5").getEdges(Direction.IN, new String[0])), (int)1);
            Vertex ripple = graph.getVertex((Object)"5");
            GraphMLReaderTestSuite.assertEquals((Object)ripple.getProperty("name"), (Object)"ripple");
            GraphMLReaderTestSuite.assertEquals((Object)ripple.getProperty("lang"), (Object)"java");
            GraphMLReaderTestSuite.assertEquals((Object)ripple.getProperty("_id"), (Object)7);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"6").getEdges(Direction.OUT, new String[0])), (int)1);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(graph.getVertex((Object)"6").getEdges(Direction.IN, new String[0])), (int)0);
            Vertex peter = graph.getVertex((Object)"6");
            GraphMLReaderTestSuite.assertEquals((Object)peter.getProperty("name"), (Object)"peter");
            GraphMLReaderTestSuite.assertEquals((Object)peter.getProperty("age"), (Object)35);
            for (Edge e : graph.getVertex((Object)"6").getEdges(Direction.OUT, new String[0])) {
                if (!e.getVertex(Direction.IN).getId().equals("3")) continue;
                GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), null);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), null);
                GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"12");
                ++counter;
            }
            GraphMLReaderTestSuite.assertEquals((int)counter, (int)6);
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            HashSet<String> vertexNames = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : graph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                vertexNames.add(v.getProperty("name").toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : graph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GraphMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("_id"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)4);
            GraphMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_id"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_label"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)3);
        }
        graph.shutdown();
    }

    public void testReadingTinkerGraphExample3MappingLabels() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            GraphMLReader r = new GraphMLReader(graph);
            r.setEdgeLabelKey("_label");
            r.inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-3.xml"), 1000);
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            HashSet<String> vertexNames = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : graph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                vertexNames.add(v.getProperty("name").toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            HashSet<String> edgeLabels = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : graph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                edgeLabels.add(e.getLabel());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GraphMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("_id"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)4);
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("marko"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("josh"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("peter"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("vadas"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("ripple"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("lop"));
            GraphMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_id"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_label"), (boolean)false);
            GraphMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)edgeLabels.size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("has high fived"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("knows"), (boolean)false);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("created"), (boolean)true);
        }
        graph.shutdown();
    }

    public void testReadingTinkerGraphExample3MappingIDs() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            GraphMLReader r = new GraphMLReader(graph);
            r.setVertexIdKey("_id");
            r.setEdgeIdKey("_id");
            r.inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-3.xml"), 1000);
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            HashSet<String> vertexNames = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : graph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                vertexNames.add(v.getProperty("name").toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            HashSet<String> edgeLabels = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : graph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                edgeLabels.add(e.getLabel());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GraphMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("_id"), (boolean)false);
            GraphMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)3);
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("marko"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("josh"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("peter"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("vadas"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("ripple"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("lop"));
            GraphMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_id"), (boolean)false);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_label"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)edgeLabels.size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("has high fived"), (boolean)false);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("knows"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("created"), (boolean)true);
        }
        graph.shutdown();
    }

    public void testReadingTinkerGraphExample3MappingAll() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            GraphMLReader r = new GraphMLReader(graph);
            r.setVertexIdKey("_id");
            r.setEdgeIdKey("_id");
            r.setEdgeLabelKey("_label");
            r.inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-3.xml"), 1000);
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            HashSet<String> vertexNames = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : graph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                vertexNames.add(v.getProperty("name").toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            HashSet<String> edgeLabels = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : graph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                edgeLabels.add(e.getLabel());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GraphMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("_id"), (boolean)false);
            GraphMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)3);
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("marko"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("josh"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("peter"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("vadas"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("ripple"));
            GraphMLReaderTestSuite.assertTrue((boolean)vertexNames.contains("lop"));
            GraphMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_id"), (boolean)false);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_label"), (boolean)false);
            GraphMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)1);
            GraphMLReaderTestSuite.assertEquals((int)edgeLabels.size(), (int)2);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("has high fived"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("knows"), (boolean)false);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeLabels.contains("created"), (boolean)true);
        }
        graph.shutdown();
    }

    public void testMigratingTinkerGraphExample3() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue() && graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GraphMLReader(graph).inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-3.xml"), 1000);
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-3 loaded", this.stopWatch());
            this.stopWatch();
            TinkerGraph toGraph = new TinkerGraph();
            GraphMigrator.migrateGraph((Graph)graph, (Graph)toGraph);
            GraphMLReaderTestSuite.printPerformance(toGraph.toString(), null, "graph-example-3 migrated", this.stopWatch());
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"1").getEdges(Direction.OUT, new String[0])), (int)3);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"1").getEdges(Direction.IN, new String[0])), (int)0);
            Vertex marko = toGraph.getVertex((Object)"1");
            GraphMLReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GraphMLReaderTestSuite.assertEquals((Object)marko.getProperty("age"), (Object)29);
            GraphMLReaderTestSuite.assertEquals((Object)marko.getProperty("_id"), (Object)2);
            int counter = 0;
            for (Edge e : toGraph.getVertex((Object)"1").getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("2")) {
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)8);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), (Object)"has high fived");
                    GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                    GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"7");
                    ++counter;
                    continue;
                }
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)10);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), (Object)"has high fived");
                    GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"9");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("4")) continue;
                GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)1);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)9);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), (Object)"has high fived");
                GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"8");
                ++counter;
            }
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"2").getEdges(Direction.OUT, new String[0])), (int)0);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"2").getEdges(Direction.IN, new String[0])), (int)1);
            Vertex vadas = toGraph.getVertex((Object)"2");
            GraphMLReaderTestSuite.assertEquals((Object)vadas.getProperty("name"), (Object)"vadas");
            GraphMLReaderTestSuite.assertEquals((Object)vadas.getProperty("age"), (Object)27);
            GraphMLReaderTestSuite.assertEquals((Object)vadas.getProperty("_id"), (Object)3);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"3").getEdges(Direction.OUT, new String[0])), (int)0);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"3").getEdges(Direction.IN, new String[0])), (int)3);
            Vertex lop = toGraph.getVertex((Object)"3");
            GraphMLReaderTestSuite.assertEquals((Object)lop.getProperty("name"), (Object)"lop");
            GraphMLReaderTestSuite.assertEquals((Object)lop.getProperty("lang"), (Object)"java");
            GraphMLReaderTestSuite.assertEquals((Object)lop.getProperty("_id"), (Object)4);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"4").getEdges(Direction.OUT, new String[0])), (int)2);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"4").getEdges(Direction.IN, new String[0])), (int)1);
            Vertex josh = toGraph.getVertex((Object)"4");
            GraphMLReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GraphMLReaderTestSuite.assertEquals((Object)josh.getProperty("age"), (Object)32);
            for (Edge e : toGraph.getVertex((Object)"4").getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().equals("3")) {
                    GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)13);
                    GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), null);
                    GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"11");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().equals("5")) continue;
                GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)1);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), (Object)11);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), (Object)"has high fived");
                GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"10");
                ++counter;
            }
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"5").getEdges(Direction.OUT, new String[0])), (int)0);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"5").getEdges(Direction.IN, new String[0])), (int)1);
            Vertex ripple = toGraph.getVertex((Object)"5");
            GraphMLReaderTestSuite.assertEquals((Object)ripple.getProperty("name"), (Object)"ripple");
            GraphMLReaderTestSuite.assertEquals((Object)ripple.getProperty("lang"), (Object)"java");
            GraphMLReaderTestSuite.assertEquals((Object)ripple.getProperty("_id"), (Object)7);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"6").getEdges(Direction.OUT, new String[0])), (int)1);
            GraphMLReaderTestSuite.assertEquals((int)GraphMLReaderTestSuite.count(toGraph.getVertex((Object)"6").getEdges(Direction.IN, new String[0])), (int)0);
            Vertex peter = toGraph.getVertex((Object)"6");
            GraphMLReaderTestSuite.assertEquals((Object)peter.getProperty("name"), (Object)"peter");
            GraphMLReaderTestSuite.assertEquals((Object)peter.getProperty("age"), (Object)35);
            for (Edge e : toGraph.getVertex((Object)"6").getEdges(Direction.OUT, new String[0])) {
                if (!e.getVertex(Direction.IN).getId().equals("3")) continue;
                GraphMLReaderTestSuite.assertEquals((int)Math.round(((Float)e.getProperty("weight")).floatValue()), (int)0);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_id"), null);
                GraphMLReaderTestSuite.assertEquals((Object)e.getProperty("_label"), null);
                GraphMLReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GraphMLReaderTestSuite.assertEquals((Object)e.getId(), (Object)"12");
                ++counter;
            }
            GraphMLReaderTestSuite.assertEquals((int)counter, (int)6);
            HashSet<String> vertexIds = new HashSet<String>();
            HashSet<String> vertexKeys = new HashSet<String>();
            int vertexCount = 0;
            for (Vertex v : toGraph.getVertices()) {
                ++vertexCount;
                vertexIds.add(v.getId().toString());
                for (String key : v.getPropertyKeys()) {
                    vertexKeys.add(key);
                }
            }
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            int edgeCount = 0;
            for (Edge e : toGraph.getEdges()) {
                ++edgeCount;
                edgeIds.add(e.getId().toString());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                }
            }
            GraphMLReaderTestSuite.assertEquals((int)vertexCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)vertexIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("name"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("age"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("lang"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)vertexKeys.contains("_id"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((int)vertexKeys.size(), (int)4);
            GraphMLReaderTestSuite.assertEquals((int)edgeCount, (int)6);
            GraphMLReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("weight"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_id"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((boolean)edgeKeys.contains("_label"), (boolean)true);
            GraphMLReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)3);
        }
        graph.shutdown();
    }

    public void testAllGraphMLTypeCastsAndDataMappings() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            this.stopWatch();
            new GraphMLReader(graph).inputGraph(GraphMLReader.class.getResourceAsStream("graph-example-4.xml"));
            GraphMLReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-4 loaded", this.stopWatch());
            Vertex onlyOne = graph.getVertex((Object)"1");
            GraphMLReaderTestSuite.assertNotNull((Object)onlyOne);
            GraphMLReaderTestSuite.assertEquals((Object)123.45, (Object)onlyOne.getProperty("d"));
            GraphMLReaderTestSuite.assertEquals((Object)"some-string", (Object)onlyOne.getProperty("s"));
            GraphMLReaderTestSuite.assertEquals((Object)29, (Object)onlyOne.getProperty("i"));
            GraphMLReaderTestSuite.assertEquals((Object)true, (Object)onlyOne.getProperty("b"));
            GraphMLReaderTestSuite.assertEquals((Object)10000000L, (Object)onlyOne.getProperty("l"));
            GraphMLReaderTestSuite.assertEquals((Object)Float.valueOf(123.54f), (Object)onlyOne.getProperty("f"));
            GraphMLReaderTestSuite.assertEquals((Object)"junk", (Object)onlyOne.getProperty("n"));
        }
        graph.shutdown();
    }
}

