/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.javaspi.text;

import com.ibm.icu.impl.DateNumberFormat;
import com.ibm.icu.impl.javaspi.ICULocaleServiceProvider;
import com.ibm.icu.impl.jdkadapter.SimpleDateFormatICU;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.util.Locale;

public class DateFormatProviderICU
extends DateFormatProvider {
    private static final int NONE = -1;

    @Override
    public java.text.DateFormat getDateInstance(int style, Locale locale) {
        return this.getInstance(style, -1, locale);
    }

    @Override
    public java.text.DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
        return this.getInstance(dateStyle, timeStyle, locale);
    }

    @Override
    public java.text.DateFormat getTimeInstance(int style, Locale locale) {
        return this.getInstance(-1, style, locale);
    }

    @Override
    public Locale[] getAvailableLocales() {
        return ICULocaleServiceProvider.getAvailableLocales();
    }

    private java.text.DateFormat getInstance(int dstyle, int tstyle, Locale locale) {
        Locale actual = ICULocaleServiceProvider.canonicalize(locale);
        DateFormat icuDfmt = dstyle == -1 ? DateFormat.getTimeInstance((int)tstyle, (Locale)actual) : (tstyle == -1 ? DateFormat.getDateInstance((int)dstyle, (Locale)actual) : DateFormat.getDateTimeInstance((int)dstyle, (int)tstyle, (Locale)actual));
        if (!(icuDfmt instanceof SimpleDateFormat)) {
            return null;
        }
        DecimalFormatSymbols decfs = ICULocaleServiceProvider.getDecimalFormatSymbolsForLocale(actual);
        if (decfs != null) {
            NumberFormat icuNfmt = icuDfmt.getNumberFormat();
            if (icuNfmt instanceof DecimalFormat) {
                ((DecimalFormat)icuNfmt).setDecimalFormatSymbols(decfs);
            } else if (icuNfmt instanceof DateNumberFormat) {
                ((DateNumberFormat)icuNfmt).setZeroDigit(decfs.getDigit());
            }
            icuDfmt.setNumberFormat(icuNfmt);
        }
        return SimpleDateFormatICU.wrap((SimpleDateFormat)icuDfmt);
    }
}

