/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.javaspi.text;

import com.ibm.icu.impl.javaspi.ICULocaleServiceProvider;
import com.ibm.icu.impl.jdkadapter.DecimalFormatICU;
import com.ibm.icu.impl.jdkadapter.NumberFormatICU;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.text.spi.NumberFormatProvider;
import java.util.Locale;

public class NumberFormatProviderICU
extends NumberFormatProvider {
    private final int NUMBER = 0;
    private final int INTEGER = 1;
    private final int CURRENCY = 2;
    private final int PERCENT = 3;

    @Override
    public java.text.NumberFormat getCurrencyInstance(Locale locale) {
        return this.getInstance(2, locale);
    }

    @Override
    public java.text.NumberFormat getIntegerInstance(Locale locale) {
        return this.getInstance(1, locale);
    }

    @Override
    public java.text.NumberFormat getNumberInstance(Locale locale) {
        return this.getInstance(0, locale);
    }

    @Override
    public java.text.NumberFormat getPercentInstance(Locale locale) {
        return this.getInstance(3, locale);
    }

    @Override
    public Locale[] getAvailableLocales() {
        return ICULocaleServiceProvider.getAvailableLocales();
    }

    private java.text.NumberFormat getInstance(int type, Locale locale) {
        NumberFormat icuNfmt;
        Locale actual = ICULocaleServiceProvider.canonicalize(locale);
        switch (type) {
            case 0: {
                icuNfmt = NumberFormat.getNumberInstance((Locale)actual);
                break;
            }
            case 1: {
                icuNfmt = NumberFormat.getIntegerInstance((Locale)actual);
                break;
            }
            case 2: {
                icuNfmt = NumberFormat.getCurrencyInstance((Locale)actual);
                break;
            }
            case 3: {
                icuNfmt = NumberFormat.getPercentInstance((Locale)actual);
                break;
            }
            default: {
                return null;
            }
        }
        if (!(icuNfmt instanceof DecimalFormat)) {
            return null;
        }
        java.text.NumberFormat nf = null;
        nf = ICULocaleServiceProvider.useDecimalFormat() ? DecimalFormatICU.wrap((DecimalFormat)icuNfmt) : NumberFormatICU.wrap(icuNfmt);
        DecimalFormatSymbols decfs = ICULocaleServiceProvider.getDecimalFormatSymbolsForLocale(actual);
        if (decfs != null) {
            ((DecimalFormat)icuNfmt).setDecimalFormatSymbols(decfs);
        }
        return nf;
    }
}

