/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.jdkadapter;

import com.ibm.icu.impl.jdkadapter.CollationKeyICU;
import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;

public class CollatorICU
extends java.text.Collator {
    private Collator fIcuCollator;

    private CollatorICU(Collator icuCollator) {
        this.fIcuCollator = icuCollator;
    }

    public static java.text.Collator wrap(Collator icuCollator) {
        return new CollatorICU(icuCollator);
    }

    public Collator unwrap() {
        return this.fIcuCollator;
    }

    @Override
    public Object clone() {
        CollatorICU other = (CollatorICU)super.clone();
        try {
            other.fIcuCollator = (Collator)this.fIcuCollator.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("clone() is not supported by this ICU Collator.");
        }
        return other;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.fIcuCollator.compare(o1, o2);
    }

    @Override
    public int compare(String source, String target) {
        return this.fIcuCollator.compare(source, target);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof CollatorICU) {
            return ((CollatorICU)that).fIcuCollator.equals(this.fIcuCollator);
        }
        return false;
    }

    @Override
    public boolean equals(String source, String target) {
        return this.fIcuCollator.equals(source, target);
    }

    @Override
    public java.text.CollationKey getCollationKey(String source) {
        CollationKey icuCollKey = this.fIcuCollator.getCollationKey(source);
        return CollationKeyICU.wrap(icuCollKey);
    }

    @Override
    public int getDecomposition() {
        int mode = 0;
        if (this.fIcuCollator.getStrength() == 15) {
            return 2;
        }
        int icuMode = this.fIcuCollator.getDecomposition();
        if (icuMode == 17) {
            mode = 1;
        }
        return mode;
    }

    @Override
    public int getStrength() {
        int strength;
        int icuStrength = this.fIcuCollator.getStrength();
        switch (icuStrength) {
            case 15: {
                strength = 3;
                break;
            }
            case 0: {
                strength = 0;
                break;
            }
            case 1: {
                strength = 1;
                break;
            }
            case 2: {
                strength = 2;
                break;
            }
            case 3: {
                strength = 2;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown strength is used by the ICU Collator.");
            }
        }
        return strength;
    }

    @Override
    public int hashCode() {
        return this.fIcuCollator.hashCode();
    }

    @Override
    public void setDecomposition(int decompositionMode) {
        switch (decompositionMode) {
            case 1: {
                this.fIcuCollator.setDecomposition(17);
                break;
            }
            case 0: {
                this.fIcuCollator.setDecomposition(16);
                break;
            }
            case 2: {
                this.fIcuCollator.setStrength(15);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid decomposition mode.");
            }
        }
    }

    @Override
    public void setStrength(int newStrength) {
        switch (newStrength) {
            case 3: {
                this.fIcuCollator.setStrength(15);
                break;
            }
            case 0: {
                this.fIcuCollator.setStrength(0);
                break;
            }
            case 1: {
                this.fIcuCollator.setStrength(1);
                break;
            }
            case 2: {
                this.fIcuCollator.setStrength(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid strength.");
            }
        }
    }
}

