/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.jdkadapter;

import com.ibm.icu.impl.jdkadapter.DecimalFormatSymbolsICU;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DecimalFormatICU
extends DecimalFormat {
    private static final long serialVersionUID = 6441573352964019403L;
    private com.ibm.icu.text.DecimalFormat fIcuDecfmt;

    private DecimalFormatICU(com.ibm.icu.text.DecimalFormat icuDecfmt) {
        this.fIcuDecfmt = icuDecfmt;
    }

    public static DecimalFormat wrap(com.ibm.icu.text.DecimalFormat icuDecfmt) {
        return new DecimalFormatICU(icuDecfmt);
    }

    public com.ibm.icu.text.DecimalFormat unwrap() {
        return this.fIcuDecfmt;
    }

    @Override
    public void applyLocalizedPattern(String pattern) {
        this.fIcuDecfmt.applyLocalizedPattern(pattern);
    }

    @Override
    public void applyPattern(String pattern) {
        this.fIcuDecfmt.applyPattern(pattern);
    }

    @Override
    public Object clone() {
        DecimalFormatICU other = (DecimalFormatICU)super.clone();
        other.fIcuDecfmt = (com.ibm.icu.text.DecimalFormat)this.fIcuDecfmt.clone();
        return other;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DecimalFormatICU) {
            return ((DecimalFormatICU)obj).fIcuDecfmt.equals((Object)this.fIcuDecfmt);
        }
        return false;
    }

    @Override
    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        return this.fIcuDecfmt.format(number, result, fieldPosition);
    }

    @Override
    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        return this.fIcuDecfmt.format(number, result, fieldPosition);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        AttributedCharacterIterator aci = this.fIcuDecfmt.formatToCharacterIterator(obj);
        StringBuilder sb = new StringBuilder(aci.getEndIndex() - aci.getBeginIndex());
        char c = aci.first();
        do {
            sb.append(c);
        } while ((c = aci.next()) != '\uffff');
        AttributedString resstr = new AttributedString(sb.toString());
        Map<AttributedCharacterIterator.Attribute, Object> attributes = null;
        int index = aci.getBeginIndex();
        int residx = 0;
        while (aci.setIndex(index) != '\uffff') {
            attributes = aci.getAttributes();
            if (attributes == null) continue;
            int end = aci.getRunLimit();
            HashMap<AttributedCharacterIterator.Attribute, Object> jdkAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            Set<AttributedCharacterIterator.Attribute> keys = attributes.keySet();
            for (AttributedCharacterIterator.Attribute key : keys) {
                AttributedCharacterIterator.Attribute jdkKey = DecimalFormatICU.mapAttribute(key);
                Object jdkVal = attributes.get(key);
                if (jdkVal instanceof AttributedCharacterIterator.Attribute) {
                    jdkVal = DecimalFormatICU.mapAttribute((AttributedCharacterIterator.Attribute)jdkVal);
                }
                jdkAttributes.put(jdkKey, jdkVal);
            }
            int resend = residx + (end - index);
            resstr.addAttributes(jdkAttributes, residx, resend);
            index = end;
            residx = resend;
        }
        return resstr.getIterator();
    }

    @Override
    public java.util.Currency getCurrency() {
        Currency icuCurrency = this.fIcuDecfmt.getCurrency();
        if (icuCurrency == null) {
            return null;
        }
        return java.util.Currency.getInstance(icuCurrency.getCurrencyCode());
    }

    @Override
    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return DecimalFormatSymbolsICU.wrap(this.fIcuDecfmt.getDecimalFormatSymbols());
    }

    @Override
    public int getGroupingSize() {
        return this.fIcuDecfmt.getGroupingSize();
    }

    @Override
    public int getMaximumFractionDigits() {
        return this.fIcuDecfmt.getMaximumFractionDigits();
    }

    @Override
    public int getMaximumIntegerDigits() {
        return this.fIcuDecfmt.getMaximumIntegerDigits();
    }

    @Override
    public int getMinimumFractionDigits() {
        return this.fIcuDecfmt.getMinimumFractionDigits();
    }

    @Override
    public int getMinimumIntegerDigits() {
        return this.fIcuDecfmt.getMinimumIntegerDigits();
    }

    @Override
    public int getMultiplier() {
        return this.fIcuDecfmt.getMultiplier();
    }

    @Override
    public String getNegativePrefix() {
        return this.fIcuDecfmt.getNegativePrefix();
    }

    @Override
    public String getNegativeSuffix() {
        return this.fIcuDecfmt.getNegativeSuffix();
    }

    @Override
    public String getPositivePrefix() {
        return this.fIcuDecfmt.getPositivePrefix();
    }

    @Override
    public String getPositiveSuffix() {
        return this.fIcuDecfmt.getPositiveSuffix();
    }

    @Override
    public RoundingMode getRoundingMode() {
        int icuMode = this.fIcuDecfmt.getRoundingMode();
        RoundingMode mode = RoundingMode.UP;
        switch (icuMode) {
            case 2: {
                mode = RoundingMode.CEILING;
                break;
            }
            case 1: {
                mode = RoundingMode.DOWN;
                break;
            }
            case 3: {
                mode = RoundingMode.FLOOR;
                break;
            }
            case 5: {
                mode = RoundingMode.HALF_DOWN;
                break;
            }
            case 6: {
                mode = RoundingMode.HALF_EVEN;
                break;
            }
            case 4: {
                mode = RoundingMode.HALF_UP;
                break;
            }
            case 7: {
                mode = RoundingMode.UNNECESSARY;
                break;
            }
            case 0: {
                mode = RoundingMode.UP;
            }
        }
        return mode;
    }

    @Override
    public int hashCode() {
        return this.fIcuDecfmt.hashCode();
    }

    @Override
    public boolean isDecimalSeparatorAlwaysShown() {
        return this.fIcuDecfmt.isDecimalSeparatorAlwaysShown();
    }

    @Override
    public boolean isParseBigDecimal() {
        return this.fIcuDecfmt.isParseBigDecimal();
    }

    @Override
    public Number parse(String text, ParsePosition pos) {
        return this.fIcuDecfmt.parse(text, pos);
    }

    @Override
    public void setCurrency(java.util.Currency currency) {
        if (currency == null) {
            this.fIcuDecfmt.setCurrency(null);
        } else {
            this.fIcuDecfmt.setCurrency(Currency.getInstance((String)currency.getCurrencyCode()));
        }
    }

    @Override
    public void setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        com.ibm.icu.text.DecimalFormatSymbols icuDecfs = null;
        if (newSymbols instanceof DecimalFormatSymbolsICU) {
            icuDecfs = ((DecimalFormatSymbolsICU)newSymbols).unwrap();
        } else {
            icuDecfs = this.fIcuDecfmt.getDecimalFormatSymbols();
            java.util.Currency currency = newSymbols.getCurrency();
            if (currency == null) {
                icuDecfs.setCurrency(null);
            } else {
                icuDecfs.setCurrency(Currency.getInstance((String)currency.getCurrencyCode()));
            }
            icuDecfs.setCurrencySymbol(newSymbols.getCurrencySymbol());
            icuDecfs.setDecimalSeparator(newSymbols.getDecimalSeparator());
            icuDecfs.setDigit(newSymbols.getDigit());
            icuDecfs.setExponentSeparator(newSymbols.getExponentSeparator());
            icuDecfs.setGroupingSeparator(newSymbols.getGroupingSeparator());
            icuDecfs.setInfinity(newSymbols.getInfinity());
            icuDecfs.setInternationalCurrencySymbol(newSymbols.getInternationalCurrencySymbol());
            icuDecfs.setMinusSign(newSymbols.getMinusSign());
            icuDecfs.setMonetaryDecimalSeparator(newSymbols.getMonetaryDecimalSeparator());
            icuDecfs.setNaN(newSymbols.getNaN());
            icuDecfs.setPatternSeparator(newSymbols.getPatternSeparator());
            icuDecfs.setPercent(newSymbols.getPercent());
            icuDecfs.setPerMill(newSymbols.getPerMill());
            icuDecfs.setZeroDigit(newSymbols.getZeroDigit());
        }
        this.fIcuDecfmt.setDecimalFormatSymbols(icuDecfs);
    }

    @Override
    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
        if (this.fIcuDecfmt != null) {
            this.fIcuDecfmt.setDecimalSeparatorAlwaysShown(newValue);
        }
    }

    @Override
    public void setGroupingSize(int newValue) {
        if (this.fIcuDecfmt != null) {
            this.fIcuDecfmt.setGroupingSize(newValue);
        }
    }

    @Override
    public void setMaximumFractionDigits(int newValue) {
        if (this.fIcuDecfmt != null) {
            this.fIcuDecfmt.setMaximumFractionDigits(newValue);
        }
    }

    @Override
    public void setMaximumIntegerDigits(int newValue) {
        if (this.fIcuDecfmt != null) {
            this.fIcuDecfmt.setMaximumIntegerDigits(newValue);
        }
    }

    @Override
    public void setMinimumFractionDigits(int newValue) {
        if (this.fIcuDecfmt != null) {
            this.fIcuDecfmt.setMinimumFractionDigits(newValue);
        }
    }

    @Override
    public void setMinimumIntegerDigits(int newValue) {
        if (this.fIcuDecfmt != null) {
            this.fIcuDecfmt.setMinimumIntegerDigits(newValue);
        }
    }

    @Override
    public void setMultiplier(int newValue) {
        this.fIcuDecfmt.setMultiplier(newValue);
    }

    @Override
    public void setNegativePrefix(String newValue) {
        this.fIcuDecfmt.setNegativePrefix(newValue);
    }

    @Override
    public void setNegativeSuffix(String newValue) {
        this.fIcuDecfmt.setNegativeSuffix(newValue);
    }

    @Override
    public void setParseBigDecimal(boolean newValue) {
        this.fIcuDecfmt.setParseBigDecimal(newValue);
    }

    @Override
    public void setPositivePrefix(String newValue) {
        this.fIcuDecfmt.setPositivePrefix(newValue);
    }

    @Override
    public void setPositiveSuffix(String newValue) {
        this.fIcuDecfmt.setPositiveSuffix(newValue);
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        if (roundingMode.equals((Object)RoundingMode.CEILING)) {
            this.fIcuDecfmt.setRoundingMode(2);
        } else if (roundingMode.equals((Object)RoundingMode.DOWN)) {
            this.fIcuDecfmt.setRoundingMode(1);
        } else if (roundingMode.equals((Object)RoundingMode.FLOOR)) {
            this.fIcuDecfmt.setRoundingMode(3);
        } else if (roundingMode.equals((Object)RoundingMode.HALF_DOWN)) {
            this.fIcuDecfmt.setRoundingMode(5);
        } else if (roundingMode.equals((Object)RoundingMode.HALF_EVEN)) {
            this.fIcuDecfmt.setRoundingMode(6);
        } else if (roundingMode.equals((Object)RoundingMode.HALF_UP)) {
            this.fIcuDecfmt.setRoundingMode(4);
        } else if (roundingMode.equals((Object)RoundingMode.UNNECESSARY)) {
            this.fIcuDecfmt.setRoundingMode(7);
        } else if (roundingMode.equals((Object)RoundingMode.UP)) {
            this.fIcuDecfmt.setRoundingMode(0);
        } else {
            throw new IllegalArgumentException("Invalid rounding mode was specified.");
        }
    }

    @Override
    public String toLocalizedPattern() {
        return this.fIcuDecfmt.toLocalizedPattern();
    }

    @Override
    public String toPattern() {
        return this.fIcuDecfmt.toPattern();
    }

    @Override
    public boolean isGroupingUsed() {
        return this.fIcuDecfmt.isGroupingUsed();
    }

    @Override
    public boolean isParseIntegerOnly() {
        return this.fIcuDecfmt.isParseIntegerOnly();
    }

    @Override
    public void setGroupingUsed(boolean newValue) {
        if (this.fIcuDecfmt != null) {
            this.fIcuDecfmt.setGroupingUsed(newValue);
        }
    }

    @Override
    public void setParseIntegerOnly(boolean value) {
        this.fIcuDecfmt.setParseIntegerOnly(value);
    }

    private static AttributedCharacterIterator.Attribute mapAttribute(AttributedCharacterIterator.Attribute icuAttribute) {
        AttributedCharacterIterator.Attribute jdkAttribute = icuAttribute;
        if (icuAttribute == NumberFormat.Field.CURRENCY) {
            jdkAttribute = NumberFormat.Field.CURRENCY;
        } else if (icuAttribute == NumberFormat.Field.DECIMAL_SEPARATOR) {
            jdkAttribute = NumberFormat.Field.DECIMAL_SEPARATOR;
        } else if (icuAttribute == NumberFormat.Field.EXPONENT) {
            jdkAttribute = NumberFormat.Field.EXPONENT;
        } else if (icuAttribute == NumberFormat.Field.EXPONENT_SIGN) {
            jdkAttribute = NumberFormat.Field.EXPONENT_SIGN;
        } else if (icuAttribute == NumberFormat.Field.EXPONENT_SYMBOL) {
            jdkAttribute = NumberFormat.Field.EXPONENT_SYMBOL;
        } else if (icuAttribute == NumberFormat.Field.FRACTION) {
            jdkAttribute = NumberFormat.Field.FRACTION;
        } else if (icuAttribute == NumberFormat.Field.GROUPING_SEPARATOR) {
            jdkAttribute = NumberFormat.Field.GROUPING_SEPARATOR;
        } else if (icuAttribute == NumberFormat.Field.INTEGER) {
            jdkAttribute = NumberFormat.Field.INTEGER;
        } else if (icuAttribute == NumberFormat.Field.PERCENT) {
            jdkAttribute = NumberFormat.Field.PERCENT;
        } else if (icuAttribute == NumberFormat.Field.PERMILLE) {
            jdkAttribute = NumberFormat.Field.PERMILLE;
        } else if (icuAttribute == NumberFormat.Field.SIGN) {
            jdkAttribute = NumberFormat.Field.SIGN;
        }
        return jdkAttribute;
    }
}

