/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata;

import com.bigdata.Depends;
import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.util.InnerCause;
import com.bigdata.util.config.LogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.system.SystemUtil;

public class Banner {
    private static final Logger log = Logger.getLogger((String)"com.bigdata.Banner");
    private static final AtomicBoolean didBanner = new AtomicBoolean(false);
    private static final AtomicReference<Map<String, String>> buildInfoRef = new AtomicReference();
    private static final String banner = "\nBlazeGraph(TM) Graph Engine\n\n                   Flexible\n                   Reliable\n                  Affordable\n      Web-Scale Computing for the Enterprise\n\nCopyright SYSTAP, LLC 2006-2015.  All rights reserved.\n\n" + AbstractStatisticsCollector.fullyQualifiedHostName + "\n" + new Date() + "\n" + SystemUtil.operatingSystem() + "/" + SystemUtil.osVersion() + " " + SystemUtil.architecture() + "\n" + SystemUtil.cpuInfo() + " #CPU=" + SystemUtil.numProcessors() + "\n" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "\nfreeMemory=" + Runtime.getRuntime().freeMemory() + Banner.getBuildString() + "\n\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void banner() {
        if (didBanner.compareAndSet(false, true)) {
            boolean quiet = Boolean.getBoolean("com.bigdata.Banner.quiet");
            boolean nocatch = Boolean.getBoolean("com.bigdata.Banner.nocatch");
            if (!nocatch) {
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        log.error((Object)"Uncaught exception in thread", e);
                    }
                });
            }
            if (!quiet) {
                StringBuilder sb = new StringBuilder(banner);
                int maxNameLen = 0;
                int maxProjectLen = 0;
                int maxLicenseLen = 0;
                for (Depends.Dependency dependency : Depends.depends()) {
                    if (dependency.getName().length() > maxNameLen) {
                        maxNameLen = dependency.getName().length();
                    }
                    if (dependency.projectURL().length() > maxProjectLen) {
                        maxProjectLen = dependency.projectURL().length();
                    }
                    if (dependency.licenseURL().length() <= maxLicenseLen) continue;
                    maxLicenseLen = dependency.licenseURL().length();
                }
                maxNameLen = Math.min(80, maxNameLen);
                maxProjectLen = Math.min(80, maxProjectLen);
                maxLicenseLen = Math.min(80, maxLicenseLen);
                try (Formatter f = new Formatter(sb);){
                    String string = "%-" + maxNameLen + "s" + " %-" + maxLicenseLen + "s" + "\n";
                    f.format(string, "Dependency", "License");
                    for (Depends.Dependency dependency : Depends.depends()) {
                        f.format(string, dependency.getName(), dependency.licenseURL());
                    }
                }
                System.out.println(sb);
            }
            Banner.setDefaultLogLevel(quiet);
            if (!Boolean.getBoolean("com.bigdata.jmx.log4j.disable")) {
                try {
                    Class<?> cls = Class.forName("com.bigdata.jmx.JMXLog4jMBeanUtil");
                    Method m = cls.getMethod("registerLog4jMBeans", new Class[0]);
                    m.invoke(null, new Object[0]);
                }
                catch (Throwable t) {
                    log.info((Object)"Problem registering log4j mbean?", t);
                }
            }
        }
    }

    private static void setDefaultLogLevel(boolean quiet) {
        Logger defaultLog = LogUtil.getLog4jLogger("com.bigdata");
        if (defaultLog.getLevel() == null) {
            try {
                defaultLog.setLevel(Level.WARN);
                if (!quiet) {
                    log.warn((Object)("Defaulting log level to WARN: " + defaultLog.getName()));
                }
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, NoSuchMethodError.class)) {
                    log.error((Object)"Unable to raise the default log level to WARN. Logging is NOT properly configured. Severe performance penalty will result.");
                }
                throw new RuntimeException(t);
            }
        }
    }

    public static synchronized Map<String, String> getBuildInfo() {
        if (buildInfoRef.get() == null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            try {
                Class<?> cls = Class.forName("com.bigdata.BuildInfo");
                for (Field f : cls.getFields()) {
                    String name = f.getName();
                    int mod = f.getModifiers();
                    if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || !Modifier.isFinal(mod)) continue;
                    try {
                        Object obj = f.get(null);
                        if (obj == null) continue;
                        map.put(name, "" + obj);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn((Object)("Field: " + name + " : " + e));
                    }
                    catch (IllegalAccessException e) {
                        log.warn((Object)("Field: " + name + " : " + e));
                    }
                }
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)"Not found: com.bigdata.BuildInfo");
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
            buildInfoRef.compareAndSet(null, Collections.unmodifiableMap(map));
        }
        return buildInfoRef.get();
    }

    private static final String getBuildString() {
        if (Banner.getBuildInfo().isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append("\nbuildVersion=" + Banner.getBuildInfo().get("buildVersion"));
        return s.toString();
    }

    public static final String getVersion() {
        if (Banner.getBuildInfo().isEmpty()) {
            return null;
        }
        return Banner.getBuildInfo().get("buildVersion");
    }

    public static String getBanner() {
        return banner;
    }

    public static void main(String[] args) {
        Banner.banner();
    }

    public static interface BuildInfoMeta {
        public static final String buildVersion = "buildVersion";
        public static final String svnRevision = "svnRevision";
        public static final String svnURL = "svnURL";
        public static final String buildTimestamp = "buildTimestamp";
        public static final String buildUser = "buildUser";
        public static final String buildHost = "buildHost";
        public static final String osArch = "osArch";
        public static final String osName = "osName";
        public static final String osVersion = "osVersion";
    }

    public static interface Options {
        public static final String QUIET = "com.bigdata.Banner.quiet";
        public static final String NOCATCH = "com.bigdata.Banner.nocatch";
        public static final String LOG4J_MBEANS_DISABLE = "com.bigdata.jmx.log4j.disable";
    }
}

