/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata;

import com.bigdata.BigdataStatics;
import com.bigdata.btree.BytesUtil;
import com.bigdata.cache.HardReferenceGlobalLRURecycler;
import com.bigdata.cache.IGlobalLRU;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.TemporaryRawStore;
import com.bigdata.rawstore.AbstractRawStore;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rawstore.WormAddressManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LRUNexus {
    protected static final transient Logger log = Logger.getLogger(LRUNexus.class);
    public static final IGlobalLRU<Long, Object> INSTANCE;
    private static final CacheSettings settings;

    public static final boolean getIndexSegmentBuildPopulatesCache() {
        return settings != null && LRUNexus.settings.indexSegmentBuildPopulatesCache;
    }

    public static IGlobalLRU.ILRUCache<Long, Object> getCache(IRawStore store) {
        if (store == null) {
            throw new IllegalArgumentException();
        }
        if (INSTANCE == null) {
            return null;
        }
        IAddressManager am = store instanceof AbstractJournal ? ((AbstractJournal)store).getBufferStrategy().getAddressManager() : (store instanceof TemporaryRawStore ? new WormAddressManager(((TemporaryRawStore)store).getOffsetBits()) : (store instanceof AbstractRawStore ? ((AbstractRawStore)store).getAddressManager() : null));
        if (am instanceof IRawStore) {
            throw new AssertionError((Object)(am.getClass().getName() + " implements " + IRawStore.class.getName()));
        }
        return INSTANCE.getCache(store.getUUID(), am);
    }

    public static void main(String[] args) throws ClassNotFoundException {
        System.out.println(new CacheSettings(System.getProperties()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        IGlobalLRU<Long, Object> tmp = null;
        CacheSettings s = null;
        try {
            s = new CacheSettings(System.getProperties());
            if (BigdataStatics.debug || log.isInfoEnabled()) {
                String msg;
                String string = msg = s.enabled ? s.toString() : "LRUNexus is disabled";
                if (BigdataStatics.debug) {
                    System.err.println(msg);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)msg);
                }
            }
            tmp = s.newInstance();
        }
        catch (Throwable t) {
            log.error((Object)"LRUNexus disabled", t);
        }
        finally {
            INSTANCE = tmp;
            settings = s;
        }
    }

    public static class CacheSettings {
        public final boolean enabled;
        public final boolean indexSegmentBuildPopulatesCache;
        public final Class<? extends IGlobalLRU> cls;
        public final float loadFactor;
        public final int concurrencyLevel;
        public final boolean threadLocalBuffers;
        public final int initialCacheCapacity;
        public final int limitingCacheCapacity;
        public final float percentHeap;
        public final long maxHeap;
        public final long maximumBytesInMemory;
        public final double percentCleared;
        public final long minCleared;
        public final int minCacheSetSize;
        public final int queueCapacity;
        public final int nscan;
        public final int threadLocalBufferCapacity;
        public final AccessPolicyEnum accessPolicy;

        public CacheSettings(Properties properties) throws ClassNotFoundException {
            if (properties == null) {
                throw new IllegalArgumentException();
            }
            this.enabled = Boolean.valueOf(properties.getProperty(Options.ENABLED, "false"));
            this.indexSegmentBuildPopulatesCache = Boolean.valueOf(properties.getProperty(Options.INDEX_SEGMENT_BUILD_POPULATES_CACHE, "true"));
            this.cls = Class.forName(properties.getProperty(Options.CLASS, Options.DEFAULT_CLASS));
            boolean validClass = IGlobalLRU.class.isAssignableFrom(this.cls);
            if (!validClass) {
                throw new RuntimeException("Class does not implement " + IGlobalLRU.class.getName() + " : class=" + this.cls);
            }
            this.loadFactor = Float.valueOf(properties.getProperty(Options.LOAD_FACTOR, ".75")).floatValue();
            this.concurrencyLevel = Integer.valueOf(properties.getProperty(Options.CONCURRENCY_LEVEL, "16"));
            this.threadLocalBuffers = Boolean.valueOf(properties.getProperty(Options.THREAD_LOCAL_BUFFERS, "false"));
            this.initialCacheCapacity = Integer.valueOf(System.getProperty(Options.INITIAL_CAPACITY, "16"));
            this.limitingCacheCapacity = Integer.valueOf(System.getProperty(Options.LIMITING_CAPACITY, "2097152"));
            this.threadLocalBufferCapacity = Integer.valueOf(properties.getProperty(Options.THREAD_LOCAL_BUFFER_CAPACITY, "128"));
            this.accessPolicy = AccessPolicyEnum.valueOf(properties.getProperty(Options.ACCESS_POLICY, Options.DEFAULT_ACCESS_POLICY));
            this.percentHeap = Float.valueOf(properties.getProperty(Options.PERCENT_HEAP, ".1")).floatValue();
            if (this.percentHeap < 0.0f || this.percentHeap > 1.0f) {
                throw new IllegalArgumentException(Options.PERCENT_HEAP + " : must be in [0:1].");
            }
            this.maxHeap = BytesUtil.getByteCount(properties.getProperty(Options.MAX_HEAP, "0"));
            if (this.maxHeap < 0L) {
                throw new IllegalArgumentException(Options.MAX_HEAP + "=" + properties.getProperty(Options.MAX_HEAP, "0"));
            }
            this.maximumBytesInMemory = this.maxHeap == 0L && this.percentHeap != 0.0f ? (long)((float)Runtime.getRuntime().maxMemory() * this.percentHeap) : (this.maxHeap != 0L ? this.maxHeap : 0L);
            this.percentCleared = Double.valueOf(properties.getProperty(Options.PERCENT_CLEARED, ".01"));
            if (this.percentCleared < 0.0 || this.percentCleared > 1.0) {
                throw new IllegalArgumentException(Options.PERCENT_CLEARED + " : must be in [0:1].");
            }
            this.minCleared = (long)(this.percentCleared * (double)this.maximumBytesInMemory);
            this.minCacheSetSize = Integer.valueOf(properties.getProperty(Options.MIN_CACHE_SET_SIZE, "5"));
            int baseAverageRecordSize = 1024;
            int averageRecordSize = (int)(1024.0 * ((double)Integer.valueOf("32").intValue() / 32.0));
            long maximumQueueCapacityEstimate = this.maximumBytesInMemory / (long)averageRecordSize * 2L;
            if (BigdataStatics.debug) {
                System.err.println("averageRecordSize=" + averageRecordSize + ", maximumQueueCapacityEstimate=" + maximumQueueCapacityEstimate);
            }
            this.queueCapacity = (int)Math.min(Integer.MAX_VALUE, maximumQueueCapacityEstimate);
            this.nscan = 20;
        }

        public IGlobalLRU<Long, Object> newInstance() throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
            if (this.enabled && this.maximumBytesInMemory > 0L) {
                Constructor<? extends IGlobalLRU> ctor = this.cls.getConstructor(CacheSettings.class);
                return ctor.newInstance(this);
            }
            return null;
        }

        public String toString() {
            return super.toString() + "{" + "maxPercent=" + this.percentHeap + ", maxHeap=" + this.maxHeap + ", maximumBytesInMemory=" + this.maximumBytesInMemory + ", percentCleared=" + this.percentCleared + ", minCleared=" + this.minCleared + ", maxMemory=" + Runtime.getRuntime().maxMemory() + ", loadFactor=" + this.loadFactor + ", concurrencyLevel=" + this.concurrencyLevel + ", threadLocalBuffers=" + this.threadLocalBuffers + ", threadLocalBufferCapacity=" + this.threadLocalBufferCapacity + ", initialCacheCapacity=" + this.initialCacheCapacity + ", limitingCacheCapacity=" + this.limitingCacheCapacity + ", minCacheSetSize=" + this.minCacheSetSize + ", queueCapacity=" + this.queueCapacity + ", nscan=" + this.nscan + ", cls=" + this.cls.getName() + ", indexSegmentBuildPopulatesCache=" + this.indexSegmentBuildPopulatesCache + "}";
        }
    }

    public static enum AccessPolicyEnum {
        LRU,
        LIRS;

    }

    public static interface Options {
        public static final String ENABLED = LRUNexus.class.getName() + ".enabled";
        public static final String DEFAULT_ENABLED = "false";
        public static final String PERCENT_HEAP = LRUNexus.class.getName() + ".percentHeap";
        public static final String DEFAULT_PERCENT_HEAP = ".1";
        public static final String MAX_HEAP = LRUNexus.class.getName() + ".maxHeap";
        public static final String DEFAULT_MAX_HEAP = "0";
        public static final String PERCENT_CLEARED = LRUNexus.class.getName() + ".percentCleared";
        public static final String DEFAULT_PERCENT_CLEARED = ".01";
        public static final String CLASS = LRUNexus.class.getName() + ".class";
        public static final String DEFAULT_CLASS = HardReferenceGlobalLRURecycler.class.getName();
        public static final String LOAD_FACTOR = LRUNexus.class.getName() + ".loadFactor";
        public static final String DEFAULT_LOAD_FACTOR = ".75";
        public static final String CONCURRENCY_LEVEL = LRUNexus.class.getName() + ".concurrencyLevel";
        public static final String DEFAULT_CONCURRENCY_LEVEL = "16";
        public static final String THREAD_LOCAL_BUFFERS = LRUNexus.class.getName() + ".threadLocalBuffers";
        public static final String DEFAULT_THREAD_LOCAL_BUFFERS = "false";
        public static final String INITIAL_CAPACITY = LRUNexus.class.getName() + ".initialCapacity";
        public static final String DEFAULT_INITIAL_CAPACITY = "16";
        public static final String LIMITING_CAPACITY = LRUNexus.class.getName() + ".limitingCapacity";
        public static final String DEFAULT_LIMITING_CAPACITY = "2097152";
        public static final String THREAD_LOCAL_BUFFER_CAPACITY = LRUNexus.class.getName() + ".threadLocalBufferCapacity";
        public static final String DEFAULT_THREAD_LOCAL_BUFFER_CAPACITY = "128";
        public static final String ACCESS_POLICY = LRUNexus.class.getName() + ".accessPolicy";
        public static final String DEFAULT_ACCESS_POLICY = AccessPolicyEnum.LRU.toString();
        public static final String MIN_CACHE_SET_SIZE = LRUNexus.class.getName() + ".minCacheSetSize";
        public static final String DEFAULT_MIN_CACHE_SET_SIZE = "5";
        public static final String INDEX_SEGMENT_BUILD_POPULATES_CACHE = LRUNexus.class.getName() + ".indexSegmentBuildPopulatesCache";
        public static final String DEFAULT_INDEX_SEGMENT_BUILD_POPULATES_CACHE = "true";
    }
}

