/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataGraph;
import com.bigdata.blueprints.BigdataGraphAtom;
import com.bigdata.blueprints.BigdataGraphListener;
import com.bigdata.blueprints.BigdataRDFFactory;
import com.bigdata.blueprints.BlueprintsValueFactory;
import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.changesets.ChangeRecord;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.TransactionalGraph;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.openrdf.repository.RepositoryConnection;

public class BigdataGraphEmbedded
extends BigdataGraph
implements TransactionalGraph,
IChangeLog {
    final BigdataSailRepository repo;
    final List<BigdataGraphListener> listeners = Collections.synchronizedList(new LinkedList());
    protected final ThreadLocal<BigdataSailRepositoryConnection> cxn = new ThreadLocal<BigdataSailRepositoryConnection>(){

        @Override
        protected BigdataSailRepositoryConnection initialValue() {
            BigdataSailRepositoryConnection cxn = null;
            try {
                cxn = BigdataGraphEmbedded.this.repo.getUnisolatedConnection();
                cxn.setAutoCommit(false);
                cxn.addChangeLog(BigdataGraphEmbedded.this);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return cxn;
        }
    };
    protected static final Features FEATURES = new Features();
    private final List<IChangeRecord> removes = new LinkedList<IChangeRecord>();

    public BigdataGraphEmbedded(BigdataSail sail) {
        this(sail, BigdataRDFFactory.INSTANCE);
    }

    public BigdataGraphEmbedded(BigdataSail sail, BlueprintsValueFactory factory) {
        this(new BigdataSailRepository(sail), factory, new Properties());
    }

    public BigdataGraphEmbedded(BigdataSail sail, BlueprintsValueFactory factory, Properties props) {
        this(new BigdataSailRepository(sail), factory, props);
    }

    public BigdataGraphEmbedded(BigdataSailRepository repo) {
        this(repo, (BlueprintsValueFactory)BigdataRDFFactory.INSTANCE, new Properties());
    }

    public BigdataGraphEmbedded(BigdataSailRepository repo, BlueprintsValueFactory factory, Properties props) {
        super(factory, props);
        this.repo = repo;
    }

    public BigdataSailRepository getRepository() {
        return this.repo;
    }

    protected BigdataSailRepositoryConnection getWriteConnection() throws Exception {
        return this.cxn.get();
    }

    protected BigdataSailRepositoryConnection getReadConnection() throws Exception {
        return this.repo.getReadOnlyConnection();
    }

    public void commit() {
        try {
            RepositoryConnection cxn = (RepositoryConnection)this.cxn.get();
            cxn.commit();
            cxn.close();
            this.cxn.remove();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void rollback() {
        try {
            RepositoryConnection cxn = (RepositoryConnection)this.cxn.get();
            cxn.rollback();
            cxn.close();
            this.cxn.remove();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        try {
            this.repo.shutDown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void stopTransaction(TransactionalGraph.Conclusion arg0) {
    }

    public StringBuilder dumpStore() {
        return this.repo.getDatabase().dumpStore();
    }

    @Override
    public Features getFeatures() {
        return FEATURES;
    }

    public void addListener(BigdataGraphListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BigdataGraphListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeEvent(IChangeRecord record) {
        if (record.getChangeAction() == ChangeAction.REMOVED) {
            List<IChangeRecord> list = this.removes;
            synchronized (list) {
                this.removes.add(record);
            }
        } else {
            this.notify(record);
        }
    }

    protected void notify(IChangeRecord record) {
        BigdataGraphListener.BigdataGraphEdit edit = this.toGraphEdit(record);
        if (edit != null) {
            for (BigdataGraphListener listener : this.listeners) {
                listener.graphEdited(edit, record.toString());
            }
        }
    }

    protected BigdataGraphListener.BigdataGraphEdit toGraphEdit(IChangeRecord record) {
        BigdataGraphListener.BigdataGraphEdit.Action action;
        if (record.getChangeAction() == ChangeAction.INSERTED) {
            action = BigdataGraphListener.BigdataGraphEdit.Action.Add;
        } else if (record.getChangeAction() == ChangeAction.REMOVED) {
            action = BigdataGraphListener.BigdataGraphEdit.Action.Remove;
        } else {
            return null;
        }
        BigdataGraphAtom atom = super.toGraphAtom(record.getStatement());
        return new BigdataGraphListener.BigdataGraphEdit(action, atom);
    }

    protected List<IChangeRecord> materialize(List<IChangeRecord> records) {
        try {
            AbstractTripleStore db = this.cxn.get().getTripleStore();
            LinkedList<IChangeRecord> materialized = new LinkedList<IChangeRecord>();
            ISPO[] spos = new ISPO[records.size()];
            int i = 0;
            for (IChangeRecord rec : records) {
                spos[i++] = rec.getStatement();
            }
            BigdataStatementIterator it = db.asStatementIterator(new ChunkedArrayIterator<ISPO>(i, spos, null));
            for (IChangeRecord rec : records) {
                BigdataStatement stmt = (BigdataStatement)it.next();
                materialized.add(new ChangeRecord(stmt, rec.getChangeAction()));
            }
            return materialized;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void transactionBegin() {
        for (BigdataGraphListener listener : this.listeners) {
            listener.transactionBegin();
        }
    }

    @Override
    public void transactionPrepare() {
        for (BigdataGraphListener listener : this.listeners) {
            listener.transactionPrepare();
        }
    }

    @Override
    public void transactionCommited(long commitTime) {
        this.notifyRemoves();
        for (BigdataGraphListener listener : this.listeners) {
            listener.transactionCommited(commitTime);
        }
    }

    @Override
    public void transactionAborted() {
        this.notifyRemoves();
        for (BigdataGraphListener listener : this.listeners) {
            listener.transactionAborted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRemoves() {
        if (this.listeners.size() > 0) {
            List<IChangeRecord> removes;
            List<IChangeRecord> list = this.removes;
            synchronized (list) {
                removes = this.materialize(this.removes);
                this.removes.clear();
            }
            for (IChangeRecord remove : removes) {
                this.notify(remove);
            }
        } else {
            List<IChangeRecord> list = this.removes;
            synchronized (list) {
                this.removes.clear();
            }
        }
    }

    static {
        BigdataGraphEmbedded.FEATURES.supportsSerializableObjectProperty = BigdataGraph.FEATURES.supportsSerializableObjectProperty;
        BigdataGraphEmbedded.FEATURES.supportsBooleanProperty = BigdataGraph.FEATURES.supportsBooleanProperty;
        BigdataGraphEmbedded.FEATURES.supportsDoubleProperty = BigdataGraph.FEATURES.supportsDoubleProperty;
        BigdataGraphEmbedded.FEATURES.supportsFloatProperty = BigdataGraph.FEATURES.supportsFloatProperty;
        BigdataGraphEmbedded.FEATURES.supportsIntegerProperty = BigdataGraph.FEATURES.supportsIntegerProperty;
        BigdataGraphEmbedded.FEATURES.supportsPrimitiveArrayProperty = BigdataGraph.FEATURES.supportsPrimitiveArrayProperty;
        BigdataGraphEmbedded.FEATURES.supportsUniformListProperty = BigdataGraph.FEATURES.supportsUniformListProperty;
        BigdataGraphEmbedded.FEATURES.supportsMixedListProperty = BigdataGraph.FEATURES.supportsMixedListProperty;
        BigdataGraphEmbedded.FEATURES.supportsLongProperty = BigdataGraph.FEATURES.supportsLongProperty;
        BigdataGraphEmbedded.FEATURES.supportsMapProperty = BigdataGraph.FEATURES.supportsMapProperty;
        BigdataGraphEmbedded.FEATURES.supportsStringProperty = BigdataGraph.FEATURES.supportsStringProperty;
        BigdataGraphEmbedded.FEATURES.supportsDuplicateEdges = BigdataGraph.FEATURES.supportsDuplicateEdges;
        BigdataGraphEmbedded.FEATURES.supportsSelfLoops = BigdataGraph.FEATURES.supportsSelfLoops;
        BigdataGraphEmbedded.FEATURES.isPersistent = BigdataGraph.FEATURES.isPersistent;
        BigdataGraphEmbedded.FEATURES.isWrapper = BigdataGraph.FEATURES.isWrapper;
        BigdataGraphEmbedded.FEATURES.supportsVertexIteration = BigdataGraph.FEATURES.supportsVertexIteration;
        BigdataGraphEmbedded.FEATURES.supportsEdgeIteration = BigdataGraph.FEATURES.supportsEdgeIteration;
        BigdataGraphEmbedded.FEATURES.supportsVertexIndex = BigdataGraph.FEATURES.supportsVertexIndex;
        BigdataGraphEmbedded.FEATURES.supportsEdgeIndex = BigdataGraph.FEATURES.supportsEdgeIndex;
        BigdataGraphEmbedded.FEATURES.ignoresSuppliedIds = BigdataGraph.FEATURES.ignoresSuppliedIds;
        BigdataGraphEmbedded.FEATURES.supportsIndices = BigdataGraph.FEATURES.supportsIndices;
        BigdataGraphEmbedded.FEATURES.supportsKeyIndices = BigdataGraph.FEATURES.supportsKeyIndices;
        BigdataGraphEmbedded.FEATURES.supportsVertexKeyIndex = BigdataGraph.FEATURES.supportsVertexKeyIndex;
        BigdataGraphEmbedded.FEATURES.supportsEdgeKeyIndex = BigdataGraph.FEATURES.supportsEdgeKeyIndex;
        BigdataGraphEmbedded.FEATURES.supportsEdgeRetrieval = BigdataGraph.FEATURES.supportsEdgeRetrieval;
        BigdataGraphEmbedded.FEATURES.supportsVertexProperties = BigdataGraph.FEATURES.supportsVertexProperties;
        BigdataGraphEmbedded.FEATURES.supportsEdgeProperties = BigdataGraph.FEATURES.supportsEdgeProperties;
        BigdataGraphEmbedded.FEATURES.supportsThreadedTransactions = BigdataGraph.FEATURES.supportsThreadedTransactions;
        BigdataGraphEmbedded.FEATURES.supportsTransactions = true;
    }
}

