/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.tinkerpop.blueprints.Element;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartialElement
implements Element {
    private final String id;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public PartialElement(String id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object removeProperty(String key) {
        return this.properties.remove(key);
    }

    public void setProperty(String key, Object value) {
        if (this.properties.containsKey(key)) {
            Object o = this.properties.get(key);
            if (o instanceof List) {
                List list = (List)o;
                list.add(value);
            } else {
                LinkedList<Object> list = new LinkedList<Object>();
                list.add(o);
                list.add(value);
                this.properties.put(key, list);
            }
        } else {
            this.properties.put(key, value);
        }
    }

    public void copyProperties(PartialElement element) {
        this.properties.putAll(element.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: " + this.id);
        sb.append(", props: ");
        this.appendProps(sb);
        return sb.toString();
    }

    protected void appendProps(StringBuilder sb) {
        for (Map.Entry<String, Object> prop : this.properties.entrySet()) {
            sb.append(prop.getKey()).append("=").append(prop.getValue());
        }
    }
}

