/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.IVariable;
import com.bigdata.bop.NamedSolutionSetRefUtility;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import java.util.Arrays;
import java.util.UUID;

public class NamedSolutionSetRef
implements INamedSolutionSetRef {
    private static final long serialVersionUID = 1L;
    private final UUID queryId;
    private final String namespace;
    private final long timestamp;
    private final String localName;
    private final IVariable[] joinVars;
    private volatile transient String fqn;
    private transient int h;

    @Override
    public final UUID getQueryId() {
        return this.queryId;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public final String getLocalName() {
        return this.localName;
    }

    @Override
    public final IVariable[] getJoinVars() {
        return this.joinVars;
    }

    NamedSolutionSetRef(UUID queryId, String namedSet, IVariable[] joinVars) {
        if (queryId == null) {
            throw new IllegalArgumentException();
        }
        if (namedSet == null) {
            throw new IllegalArgumentException();
        }
        if (joinVars == null) {
            throw new IllegalArgumentException();
        }
        this.queryId = queryId;
        this.namespace = null;
        this.timestamp = -1L;
        this.localName = namedSet;
        this.joinVars = joinVars;
    }

    NamedSolutionSetRef(String namespace, long timestamp, String localName, IVariable[] joinVars) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (localName == null) {
            throw new IllegalArgumentException();
        }
        if (joinVars == null) {
            throw new IllegalArgumentException();
        }
        this.queryId = null;
        this.namespace = namespace;
        this.timestamp = timestamp;
        this.localName = localName;
        this.joinVars = joinVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFQN() {
        if (this.fqn == null) {
            String string = this.localName;
            synchronized (string) {
                this.fqn = this.namespace == null ? this.localName : NamedSolutionSetRefUtility.getFQN(this.namespace, this.localName, this.joinVars);
            }
        }
        return this.fqn;
    }

    public int hashCode() {
        if (this.h == 0) {
            this.h = (this.queryId == null ? this.namespace.hashCode() + (int)this.timestamp : this.queryId.hashCode()) + this.localName.hashCode() + Arrays.hashCode(this.joinVars);
        }
        return this.h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedSolutionSetRef)) {
            return false;
        }
        NamedSolutionSetRef t = (NamedSolutionSetRef)o;
        if (this.queryId != null) {
            if (!this.queryId.equals(t.queryId)) {
                return false;
            }
        } else {
            if (!this.namespace.equals(t.namespace)) {
                return false;
            }
            if (this.timestamp != t.timestamp) {
                return false;
            }
        }
        if (!this.localName.equals(t.localName)) {
            return false;
        }
        return Arrays.equals(this.joinVars, t.joinVars);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{localName=").append(this.localName);
        if (this.queryId == null) {
            sb.append(",namespace=").append(this.namespace);
            sb.append(",timestamp=").append(this.timestamp);
        } else {
            sb.append(",queryId=").append(this.queryId);
        }
        sb.append(",joinVars=").append(Arrays.toString(this.joinVars));
        sb.append("}");
        return sb.toString();
    }
}

