/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NamedSolutionSetRef;
import com.bigdata.bop.Var;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.solutions.ISolutionSet;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import com.bigdata.rdf.sparql.ast.ssets.ISolutionSetManager;
import com.bigdata.striterator.Chunkerator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.UUID;

public class NamedSolutionSetRefUtility {
    public static INamedSolutionSetRef newInstance(UUID queryId, String namedSet, IVariable[] joinVars) {
        return new NamedSolutionSetRef(queryId, namedSet, joinVars);
    }

    public static INamedSolutionSetRef newInstance(String namespace, long timestamp, String localName, IVariable[] joinVars) {
        return new NamedSolutionSetRef(namespace, timestamp, localName, joinVars);
    }

    public static INamedSolutionSetRef valueOf(String s) {
        int posNamedSet = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf("localName="));
        int posNamedSetEnd = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf(",", posNamedSet));
        String namedSet = s.substring(posNamedSet + 10, posNamedSetEnd);
        int posJoinVars = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf("joinVars=["));
        int posJoinVarsEnd = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf("]", posJoinVars));
        String joinVarsStr = s.substring(posJoinVars + 10, posJoinVarsEnd);
        String[] a = joinVarsStr.split(", ");
        IVariable[] joinVars = new IVariable[a.length];
        for (int i = 0; i < a.length; ++i) {
            joinVars[i] = Var.var(a[i]);
        }
        if (s.indexOf("queryId") != -1) {
            int posQueryId = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf("queryId="));
            int posQueryIdEnd = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf(",", posQueryId));
            String queryIdStr = s.substring(posQueryId + 8, posQueryIdEnd);
            UUID queryId = UUID.fromString(queryIdStr);
            return NamedSolutionSetRefUtility.newInstance(queryId, namedSet, joinVars);
        }
        int posNamespace = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf("namespace="));
        int posNamespaceEnd = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf(",", posNamespace));
        String namespace = s.substring(posNamespace + 10, posNamespaceEnd);
        int posTimestamp = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf("timestamp="));
        int posTimestampEnd = NamedSolutionSetRefUtility.assertIndex(s, s.indexOf(",", posTimestamp));
        String timestampStr = s.substring(posTimestamp + 10, posTimestampEnd);
        long timestamp = Long.valueOf(timestampStr);
        return NamedSolutionSetRefUtility.newInstance(namespace, timestamp, namedSet, joinVars);
    }

    private static int assertIndex(String s, int index) {
        if (index >= 0) {
            return index;
        }
        throw new IllegalArgumentException(s);
    }

    public static String getFQN(String namespace, String localName, IVariable[] joinVars) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (localName == null) {
            throw new IllegalArgumentException();
        }
        if (joinVars == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = NamedSolutionSetRefUtility.getPrefix(namespace, localName);
        if (joinVars.length != 0) {
            sb.append(".");
        }
        boolean first = true;
        for (IVariable v : joinVars) {
            if (first) {
                first = false;
            } else {
                sb.append("-");
            }
            sb.append(v.getName());
        }
        return sb.toString();
    }

    public static StringBuilder getPrefix(String namespace) {
        StringBuilder sb = new StringBuilder(96);
        sb.append(namespace);
        sb.append(".solutionSets");
        return sb;
    }

    public static StringBuilder getPrefix(String namespace, String localName) {
        StringBuilder sb = NamedSolutionSetRefUtility.getPrefix(namespace);
        sb.append(".");
        sb.append(localName);
        return sb;
    }

    public static ISolutionSetStats getSolutionSetStats(ISolutionSetManager sparqlCache, IBTreeManager localIndexManager, String namespace, long timestamp, String localName, IVariable[] joinVars) {
        ICheckpointProtocol index;
        ISolutionSetStats stats;
        if (localName == null) {
            throw new IllegalArgumentException();
        }
        if (sparqlCache != null && (stats = sparqlCache.getSolutionSetStats(localName)) != null) {
            return stats;
        }
        String fqn = NamedSolutionSetRefUtility.getFQN(namespace, localName, joinVars);
        AbstractJournal localJournal = (AbstractJournal)localIndexManager;
        if (timestamp == 0L) {
            index = localJournal.getUnisolatedIndex(fqn);
        } else if (TimestampUtility.isReadWriteTx(timestamp)) {
            long readsOnCommitTime = localJournal.getLocalTransactionManager().getTx(timestamp).getReadsOnCommitTime();
            index = localJournal.getIndexLocal(fqn, readsOnCommitTime);
        } else {
            index = TimestampUtility.isReadOnly(timestamp) ? localJournal.getIndexLocal(fqn, timestamp) : null;
        }
        if (index == null) {
            throw new RuntimeException("Unresolved solution set: namespace=" + namespace + ", timestamp=" + timestamp + ", localName=" + localName + ", joinVars=" + Arrays.toString(joinVars));
        }
        return ((ISolutionSet)index).getStats();
    }

    public static ICloseableIterator<IBindingSet[]> getSolutionSet(ISolutionSetManager sparqlCache, IBTreeManager localIndexManager, String namespace, long timestamp, String localName, IVariable[] joinVars, int chunkCapacity) {
        ICheckpointProtocol index;
        if (sparqlCache != null && sparqlCache.existsSolutions(localName)) {
            return sparqlCache.getSolutions(localName);
        }
        String fqn = NamedSolutionSetRefUtility.getFQN(namespace, localName, joinVars);
        AbstractJournal localJournal = (AbstractJournal)localIndexManager;
        if (timestamp == 0L) {
            index = localJournal.getUnisolatedIndex(fqn);
        } else if (TimestampUtility.isReadOnly(timestamp)) {
            index = localJournal.getIndexLocal(fqn, timestamp);
        } else {
            throw new AssertionError((Object)("localName=" + localName));
        }
        if (index == null) {
            throw new RuntimeException("Unresolved solution set: namespace=" + namespace + ", timestamp=" + timestamp + ", localName=" + localName + ", joinVars=" + Arrays.toString(joinVars));
        }
        ICloseableIterator<?> src = index.scan();
        return new Chunkerator<IBindingSet>(src, chunkCapacity, IBindingSet.class);
    }
}

