/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.controller;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpEvaluationContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.ISingleThreadedOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.INamedSubqueryOp;
import com.bigdata.bop.controller.NamedSetAnnotations;
import com.bigdata.bop.controller.SubqueryAnnotations;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.join.HTreeHashJoinAnnotations;
import com.bigdata.bop.join.HTreeHashJoinUtility;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.bop.join.NamedSolutionSetStats;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.util.concurrent.IHaltable;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.SingleValueIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class HTreeNamedSubqueryOp
extends PipelineOp
implements INamedSubqueryOp,
ISingleThreadedOp {
    private static final transient Logger log = Logger.getLogger(HTreeNamedSubqueryOp.class);
    private static final long serialVersionUID = 1L;

    public HTreeNamedSubqueryOp(HTreeNamedSubqueryOp op) {
        super(op);
    }

    public HTreeNamedSubqueryOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        IVariable[] joinVars;
        if (this.getEvaluationContext() != BOpEvaluationContext.CONTROLLER) {
            throw new IllegalArgumentException(BOp.Annotations.EVALUATION_CONTEXT + "=" + (Object)((Object)this.getEvaluationContext()));
        }
        this.assertMaxParallelOne();
        if (!this.isAtOnceEvaluation()) {
            throw new IllegalArgumentException();
        }
        this.getRequiredProperty(Annotations.SUBQUERY);
        this.getRequiredProperty("namedSetRef");
        for (IVariable var : joinVars = (IVariable[])this.getRequiredProperty(Annotations.JOIN_VARS)) {
            if (var != null) continue;
            throw new IllegalArgumentException(Annotations.JOIN_VARS);
        }
    }

    public HTreeNamedSubqueryOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    public BOpStats newStats() {
        return new NamedSolutionSetStats();
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ControllerTask(this, context));
    }

    private static class ControllerTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final NamedSolutionSetStats stats;
        private final PipelineOp subquery;
        private final INamedSolutionSetRef namedSetRef;
        private final IQueryAttributes attrs;
        private final boolean first;
        private final HTreeHashJoinUtility state;

        public ControllerTask(HTreeNamedSubqueryOp op, BOpContext<IBindingSet> context) {
            if (op == null) {
                throw new IllegalArgumentException();
            }
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.context = context;
            this.stats = (NamedSolutionSetStats)context.getStats();
            this.subquery = (PipelineOp)op.getRequiredProperty(Annotations.SUBQUERY);
            this.namedSetRef = (INamedSolutionSetRef)op.getRequiredProperty("namedSetRef");
            this.attrs = context.getQueryAttributes(this.namedSetRef.getQueryId());
            HTreeHashJoinUtility state = (HTreeHashJoinUtility)this.attrs.get(this.namedSetRef);
            if (state == null) {
                state = new HTreeHashJoinUtility(context.getMemoryManager(this.namedSetRef.getQueryId()), op, JoinTypeEnum.Normal);
                if (this.attrs.putIfAbsent(this.namedSetRef, state) != null) {
                    throw new AssertionError();
                }
                this.first = true;
            } else {
                this.first = false;
            }
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                IBindingSet[] bindingSets = BOpUtility.toArray(this.context.getSource(), this.stats);
                if (this.first) {
                    new SubqueryTask(bindingSets, this.subquery, this.context).call();
                }
                SingleValueIterator<IBindingSet[]> source = new SingleValueIterator<IBindingSet[]>(bindingSets);
                IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
                BOpUtility.copy(source, sink, null, null, null, null, null);
                sink.flush();
                Void void_ = null;
                return void_;
            }
            finally {
                this.context.getSource().close();
                this.context.getSink().close();
                if (this.context.getSink2() != null) {
                    this.context.getSink2().close();
                }
            }
        }

        private class SubqueryTask
        implements Callable<Void> {
            private final BOpContext<IBindingSet> parentContext;
            private final IBindingSet[] bindingSets;
            private final BOp subQueryOp;

            public SubqueryTask(IBindingSet[] bindingSets, BOp subQuery, BOpContext<IBindingSet> parentContext) {
                this.bindingSets = bindingSets;
                this.subQueryOp = subQuery;
                this.parentContext = parentContext;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                IHaltable runningSubquery = null;
                ICloseableIterator<IBindingSet[]> subquerySolutionItr = null;
                try {
                    QueryEngine queryEngine = this.parentContext.getRunningQuery().getQueryEngine();
                    runningSubquery = queryEngine.eval((BOp)((PipelineOp)this.subQueryOp), this.bindingSets);
                    try {
                        ((AbstractRunningQuery)this.parentContext.getRunningQuery()).addChild((IRunningQuery)runningSubquery);
                        subquerySolutionItr = runningSubquery.iterator();
                        long ncopied = ControllerTask.this.state.acceptSolutions(subquerySolutionItr, ControllerTask.this.stats);
                        runningSubquery.get();
                        ((ControllerTask)ControllerTask.this).stats.solutionSetSize.add(ncopied);
                        ControllerTask.this.state.saveSolutionSet();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Solution set " + ControllerTask.this.namedSetRef + " has " + ncopied + " solutions."));
                        }
                    }
                    catch (InterruptedException ex) {
                        runningSubquery.cancel(true);
                        throw ex;
                    }
                }
                catch (Throwable t) {
                    if (runningSubquery == null || runningSubquery.getCause() != null) {
                        throw new RuntimeException(ControllerTask.this.context.getRunningQuery().halt(runningSubquery == null ? t : runningSubquery.getCause()));
                    }
                }
                finally {
                    try {
                        if (runningSubquery != null) {
                            runningSubquery.cancel(true);
                        }
                    }
                    finally {
                        if (subquerySolutionItr != null) {
                            subquerySolutionItr.close();
                        }
                    }
                }
                return null;
            }
        }
    }

    public static interface Annotations
    extends SubqueryAnnotations,
    HTreeHashJoinAnnotations,
    NamedSetAnnotations {
    }
}

