/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.controller;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.SubqueryJoinAnnotations;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.util.concurrent.IHaltable;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class SubqueryOp
extends PipelineOp {
    private static final Logger log = Logger.getLogger(SubqueryOp.class);
    private static final long serialVersionUID = 1L;

    public SubqueryOp(SubqueryOp op) {
        super(op);
    }

    public SubqueryOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getRequiredProperty(Annotations.SUBQUERY);
        IVariable[] selectVars = (IVariable[])this.getProperty(Annotations.SELECT);
        if (selectVars != null && selectVars.length == 0) {
            throw new IllegalArgumentException(Annotations.SELECT + " is optional, but may not be empty.");
        }
        JoinTypeEnum joinType = (JoinTypeEnum)((Object)this.getRequiredProperty(Annotations.JOIN_TYPE));
        switch (joinType) {
            case Normal: 
            case Optional: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(Annotations.JOIN_TYPE + "=" + (Object)((Object)joinType));
            }
        }
    }

    public SubqueryOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ControllerTask(this, context));
    }

    private static class ControllerTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final JoinTypeEnum joinType;
        private final boolean aggregate;
        private final PipelineOp subquery;
        private final IVariable<?> askVar;
        private final IVariable<?>[] selectVars;
        private final IConstraint[] constraints;

        public ControllerTask(SubqueryOp controllerOp, BOpContext<IBindingSet> context) {
            if (controllerOp == null) {
                throw new IllegalArgumentException();
            }
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.context = context;
            this.joinType = (JoinTypeEnum)((Object)controllerOp.getRequiredProperty(Annotations.JOIN_TYPE));
            this.aggregate = controllerOp.getProperty(Annotations.IS_AGGREGATE, false);
            this.subquery = (PipelineOp)controllerOp.getRequiredProperty(Annotations.SUBQUERY);
            this.askVar = (IVariable)controllerOp.getProperty(Annotations.ASK_VAR);
            this.selectVars = (IVariable[])controllerOp.getProperty(Annotations.SELECT);
            this.constraints = (IConstraint[])controllerOp.getProperty(Annotations.CONSTRAINTS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                ICloseableIterator<IBindingSet[]> sitr = this.context.getSource();
                while (sitr.hasNext()) {
                    IBindingSet[] chunk;
                    for (IBindingSet bset : chunk = (IBindingSet[])sitr.next()) {
                        IRunningQuery runningSubquery = new SubqueryTask(bset, this.subquery, this.context).call();
                        if (!runningSubquery.isDone()) {
                            throw new AssertionError((Object)("Future not done: " + runningSubquery.toString()));
                        }
                    }
                }
                this.context.getSink().flush();
                Void void_ = null;
                return void_;
            }
            finally {
                this.context.getSource().close();
                this.context.getSink().close();
                if (this.context.getSink2() != null) {
                    this.context.getSink2().close();
                }
            }
        }

        private class SubqueryTask
        implements Callable<IRunningQuery> {
            private final BOpContext<IBindingSet> parentContext;
            private final IBindingSet parentSolutionIn;
            private final PipelineOp subQueryOp;

            public SubqueryTask(IBindingSet bset, PipelineOp subQuery, BOpContext<IBindingSet> parentContext) {
                this.parentSolutionIn = bset;
                this.subQueryOp = ControllerTask.this.aggregate ? BOpUtility.makeAggregateDistinct(subQuery) : subQuery;
                this.parentContext = parentContext;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRunningQuery call() throws Exception {
                IBindingSet childSolutionIn = this.parentSolutionIn.copy(ControllerTask.this.selectVars);
                IHaltable runningSubquery = null;
                ICloseableIterator<IBindingSet[]> subquerySolutionItr = null;
                try {
                    QueryEngine queryEngine = this.parentContext.getRunningQuery().getQueryEngine();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\nRunning subquery:\n        selectVars: " + Arrays.toString(ControllerTask.this.selectVars) + "\nparentSolution(in): " + this.parentSolutionIn + "\n childSolution(in): " + childSolutionIn));
                    }
                    runningSubquery = queryEngine.eval((BOp)this.subQueryOp, childSolutionIn);
                    long ncopied = 0L;
                    try {
                        ((AbstractRunningQuery)this.parentContext.getRunningQuery()).addChild((IRunningQuery)runningSubquery);
                        subquerySolutionItr = runningSubquery.iterator();
                        if (ControllerTask.this.askVar != null) {
                            XSDBooleanIV<BigdataLiteral> success = subquerySolutionItr.hasNext() ? XSDBooleanIV.TRUE : XSDBooleanIV.FALSE;
                            this.parentSolutionIn.set(ControllerTask.this.askVar, new Constant<XSDBooleanIV<BigdataLiteral>>(success));
                            this.parentContext.getSink().add(new IBindingSet[]{this.parentSolutionIn});
                            runningSubquery.cancel(true);
                            ncopied = 1L;
                        } else {
                            ncopied = BOpUtility.copy(subquerySolutionItr, this.parentContext.getSink(), null, this.parentSolutionIn, ControllerTask.this.selectVars, ControllerTask.this.constraints, this.parentContext.getStats());
                        }
                        runningSubquery.get();
                    }
                    catch (InterruptedException ex) {
                        runningSubquery.cancel(true);
                        throw ex;
                    }
                    if (ncopied == 0L && ControllerTask.this.joinType.isOptional()) {
                        IBlockingBuffer<IBindingSet[]> optionalSink = this.parentContext.getSink2() != null ? this.parentContext.getSink2() : this.parentContext.getSink();
                        optionalSink.add(new IBindingSet[]{this.parentSolutionIn});
                    }
                    IHaltable iHaltable = runningSubquery;
                    return iHaltable;
                }
                catch (Throwable t) {
                    if (runningSubquery == null || runningSubquery.getCause() != null) {
                        throw new RuntimeException(ControllerTask.this.context.getRunningQuery().halt(runningSubquery == null ? t : runningSubquery.getCause()));
                    }
                    IHaltable iHaltable = runningSubquery;
                    return iHaltable;
                }
                finally {
                    try {
                        if (runningSubquery != null) {
                            runningSubquery.cancel(true);
                        }
                    }
                    finally {
                        if (subquerySolutionItr != null) {
                            subquerySolutionItr.close();
                        }
                    }
                }
            }
        }
    }

    public static interface Annotations
    extends SubqueryJoinAnnotations {
        public static final String ASK_VAR = Annotations.class.getName() + ".askVar";
        public static final String SELECT = SubqueryJoinAnnotations.SELECT;
        public static final String IS_AGGREGATE = Annotations.class.getName() + ".isAggregate";
        public static final boolean DEFAULT_IS_AGGREGATE = false;
    }
}

