/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.bset.ConditionalRoutingOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.ChunkedRunningQuery;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueueStats;
import com.bigdata.bop.engine.RunState;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.PipelineJoin;
import com.bigdata.bop.join.PipelineJoinStats;
import com.bigdata.bop.joinGraph.rto.EdgeSample;
import com.bigdata.bop.joinGraph.rto.JGraph;
import com.bigdata.bop.joinGraph.rto.JoinGraph;
import com.bigdata.bop.joinGraph.rto.Path;
import com.bigdata.bop.joinGraph.rto.PathIds;
import com.bigdata.bop.rdf.join.ChunkedMaterializationOp;
import com.bigdata.bop.solutions.DropOp;
import com.bigdata.bop.solutions.GroupByOp;
import com.bigdata.bop.solutions.ProjectionOp;
import com.bigdata.bop.solutions.SliceOp;
import com.bigdata.btree.Tuple;
import com.bigdata.counters.render.XHTMLRenderer;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.striterator.IKeyOrder;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class QueryLog {
    private static final String NA = "N/A";
    private static final String TD = "<td>";
    private static final String TDx = "</td\n>";
    protected static final transient Logger log = Logger.getLogger(QueryLog.class);

    public static void logTableHeader() {
        if (log.isInfoEnabled()) {
            log.info((Object)QueryLog.getTableHeader());
        }
    }

    public static void log(IRunningQuery q) {
        if (!log.isInfoEnabled()) {
            return;
        }
        try {
            IRunningQuery[] children = q instanceof AbstractRunningQuery ? ((AbstractRunningQuery)q).getChildren() : null;
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            Map<Integer, QueueStats> queueStats = ((ChunkedRunningQuery)q).getQueueStats();
            QueryLog.logSummaryRow(q, queueStats, sb);
            QueryLog.logDetailRows(q, queueStats, sb);
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    IRunningQuery c = children[i];
                    Map<Integer, QueueStats> queueStats2 = ((ChunkedRunningQuery)c).getQueueStats();
                    QueryLog.logSummaryRow(c, queueStats2, sb);
                    QueryLog.logDetailRows(c, queueStats2, sb);
                }
            }
            log.info((Object)sb);
        }
        catch (RuntimeException t) {
            log.error((Object)t, (Throwable)t);
        }
    }

    private static void logDetailRows(IRunningQuery q, Map<Integer, QueueStats> queueStats, StringBuilder sb) {
        Integer[] order = BOpUtility.getEvaluationOrder(q.getQuery());
        int orderIndex = 0;
        for (Integer bopId : order) {
            sb.append(QueryLog.getTableRow(q, orderIndex, bopId, false, queueStats));
            ++orderIndex;
        }
    }

    private static void logSummaryRow(IRunningQuery q, Map<Integer, QueueStats> queueStats, StringBuilder sb) {
        sb.append(QueryLog.getTableRow(q, -1, q.getQuery().getId(), true, queueStats));
    }

    private static String getTableHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("queryId");
        sb.append("\tbeginTime");
        sb.append("\tdoneTime");
        sb.append("\tdeadline");
        sb.append("\telapsed");
        sb.append("\tserviceId");
        sb.append("\tcause");
        sb.append("\tbop");
        sb.append("\tevalOrder");
        sb.append("\tevalContext");
        sb.append("\tcontroller");
        sb.append("\tbopId");
        sb.append("\tpredId");
        sb.append("\tbopSummary");
        sb.append("\tpredSummary");
        sb.append("\tstaticBestKeyOrder");
        sb.append("\toverrideKeyOrder");
        sb.append("\tnvars");
        sb.append("\tfastRangeCount");
        sb.append("\trunState");
        sb.append("\tsumMillis");
        sb.append("\topCount");
        sb.append("\tnumRunning");
        sb.append("\tfanOut");
        sb.append("\tqueueShards");
        sb.append("\tqueueChunks");
        sb.append("\tqueueSolutions");
        sb.append("\tchunksIn");
        sb.append("\tunitsIn");
        sb.append("\tunitsInPerChunk");
        sb.append("\tchunksOut");
        sb.append("\tunitsOut");
        sb.append("\tunitsOutPerChunk");
        sb.append("\tmutationCount");
        sb.append("\ttypeErrors");
        sb.append("\tjoinRatio");
        sb.append("\taccessPathDups");
        sb.append("\taccessPathCount");
        sb.append("\taccessPathRangeCount");
        sb.append("\taccessPathChunksIn");
        sb.append("\taccessPathUnitsIn");
        sb.append("\tsolutions/ms");
        sb.append("\tmutations/ms");
        sb.append('\n');
        return sb.toString();
    }

    private static String getTableRow(IRunningQuery q, int evalOrder, Integer bopId, boolean summary, Map<Integer, QueueStats> queueStats) {
        QueueStats tmp;
        Integer predId;
        StringBuilder sb = new StringBuilder();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        long elapsed = q.getElapsed();
        UUID serviceId = q.getQueryEngine().getServiceUUID();
        Throwable cause = q.getCause();
        sb.append(q.getQueryId());
        sb.append('\t');
        sb.append(dateFormat.format(new Date(q.getStartTime())));
        sb.append('\t');
        sb.append(dateFormat.format(new Date(q.getDoneTime())));
        sb.append('\t');
        if (q.getDeadline() != Long.MAX_VALUE) {
            sb.append(dateFormat.format(new Date(q.getDeadline())));
        }
        sb.append('\t');
        sb.append(elapsed);
        sb.append('\t');
        sb.append(serviceId == null ? NA : serviceId.toString());
        sb.append('\t');
        if (cause != null) {
            sb.append(cause.getLocalizedMessage());
        }
        Map<Integer, BOp> bopIndex = q.getBOpIndex();
        Map<Integer, BOpStats> statsMap = q.getStats();
        BOp bop = bopIndex.get(bopId);
        sb.append('\t');
        if (summary) {
            sb.append(BOpUtility.toString(q.getQuery()).replace('\n', ' '));
            sb.append('\t');
            sb.append("total");
            sb.append('\t');
            sb.append('\t');
            sb.append('\t');
            sb.append("total");
        } else {
            sb.append(bopIndex.get(bopId).toString());
            sb.append('\t');
            sb.append(evalOrder);
            sb.append('\t');
            sb.append((Object)bop.getEvaluationContext());
            sb.append('\t');
            sb.append(bop.getProperty(BOp.Annotations.CONTROLLER, false));
            sb.append('\t');
            sb.append(Integer.toString(bopId));
        }
        sb.append('\t');
        IPredicate pred = (IPredicate)bop.getProperty(PipelineJoin.Annotations.PREDICATE);
        Integer n = predId = pred == null ? null : (Integer)pred.getProperty(BOp.Annotations.BOP_ID);
        if (predId != null) {
            sb.append(predId);
        } else if (pred != null) {
            sb.append(NA);
        }
        sb.append('\t');
        if (summary) {
            sb.append("total");
        } else {
            sb.append(bop.getClass().getSimpleName());
            sb.append("[" + bopId + "]");
            Integer defaultSink = (Integer)bop.getProperty(PipelineOp.Annotations.SINK_REF);
            Integer altSink = (Integer)bop.getProperty(PipelineOp.Annotations.ALT_SINK_REF);
            if (defaultSink != null) {
                sb.append(", sink=" + defaultSink);
            }
            if (altSink != null) {
                sb.append(", altSink=" + altSink);
            }
        }
        sb.append('\t');
        if (pred != null) {
            sb.append(pred.getClass().getSimpleName());
            sb.append("[" + predId + "](");
            Iterator<BOp> itr = pred.argIterator();
            boolean first = true;
            while (itr.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                IVariableOrConstant x = (IVariableOrConstant)itr.next();
                if (x.isVar()) {
                    sb.append("?");
                    sb.append(x.getName());
                    continue;
                }
                sb.append(x.get());
            }
            sb.append(")");
        }
        if (bop.getProperty("namedSetRef") != null) {
            Object namedSetRef = bop.getProperty("namedSetRef");
            if (namedSetRef instanceof INamedSolutionSetRef) {
                INamedSolutionSetRef ref = (INamedSolutionSetRef)namedSetRef;
                IRunningQuery t = QueryLog.getRunningQuery(q, ref.getQueryId());
                if (t != null) {
                    IQueryAttributes attrs = t == null ? null : t.getAttributes();
                    IHashJoinUtility state = (IHashJoinUtility)(attrs == null ? null : attrs.get(ref));
                    if (state != null) {
                        sb.append(state.toString());
                    } else {
                        sb.append(ref.toString());
                    }
                }
            } else {
                INamedSolutionSetRef[] refs = (INamedSolutionSetRef[])namedSetRef;
                for (int i = 0; i < refs.length; ++i) {
                    IRunningQuery t;
                    INamedSolutionSetRef ref = refs[i];
                    if (i > 0) {
                        sb.append(",");
                    }
                    if ((t = QueryLog.getRunningQuery(q, ref.getQueryId())) == null) continue;
                    IQueryAttributes attrs = t == null ? null : t.getAttributes();
                    IHashJoinUtility state = (IHashJoinUtility)(attrs == null ? null : attrs.get(ref));
                    if (state != null) {
                        sb.append(state.toString());
                        sb.append(QueryLog.cdata(",namedSet="));
                        sb.append(QueryLog.cdata(ref.getLocalName()));
                        continue;
                    }
                    sb.append(ref.toString());
                }
            }
        }
        if (bop instanceof ChunkedMaterializationOp) {
            sb.append(QueryLog.cdata("vars=" + Arrays.toString(((ChunkedMaterializationOp)bop).getVars()) + ",materializeInlineIVs=" + ((ChunkedMaterializationOp)bop).materializeInlineIVs()));
        }
        if (bop instanceof GroupByOp) {
            sb.append(QueryLog.cdata(((GroupByOp)bop).getGroupByState().toString()));
            sb.append(QueryLog.cdata(" "));
            sb.append(QueryLog.cdata(((GroupByOp)bop).getGroupByRewrite().toString()));
        }
        if (bop instanceof DropOp) {
            sb.append(QueryLog.cdata(Arrays.toString(((DropOp)bop).getDropVars())));
        }
        if (bop instanceof ConditionalRoutingOp) {
            sb.append(QueryLog.cdata(((ConditionalRoutingOp)bop).getCondition().toString()));
        }
        if (bop instanceof JoinGraph) {
            JoinGraph t = (JoinGraph)bop;
            sb.append(QueryLog.cdata("sampleType=" + (Object)((Object)t.getSampleType())));
            sb.append(QueryLog.cdata(", limit=" + t.getLimit()));
            sb.append(QueryLog.cdata(", nedges=" + t.getNEdges()));
        }
        if (bop instanceof ProjectionOp) {
            sb.append(QueryLog.cdata(Arrays.toString(((ProjectionOp)bop).getVariables())));
        }
        if (pred != null) {
            IKeyOrder keyOrder = (IKeyOrder)pred.getProperty(AST2BOpBase.Annotations.ORIGINAL_INDEX);
            Object overrideKeyOrder = pred.getProperty(IPredicate.Annotations.KEY_ORDER);
            Long rangeCount = (Long)pred.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY);
            sb.append('\t');
            if (keyOrder != null) {
                sb.append(keyOrder);
            }
            sb.append('\t');
            if (overrideKeyOrder != null) {
                sb.append(overrideKeyOrder.toString());
            }
            sb.append('\t');
            if (keyOrder != null) {
                sb.append(pred.getVariableCount(keyOrder));
            }
            sb.append('\t');
            if (rangeCount != null) {
                sb.append(rangeCount);
            }
        } else {
            sb.append('\t');
            sb.append('\t');
            sb.append('\t');
            sb.append('\t');
        }
        int fanOut = ((AbstractRunningQuery)q).getStartedOnCount(bopId);
        long numRunning = ((AbstractRunningQuery)q).getRunningCount(bopId);
        PipelineJoinStats stats = new PipelineJoinStats();
        if (summary) {
            for (BOpStats t : statsMap.values()) {
                stats.add(t);
            }
        } else {
            BOpStats tmp2 = statsMap.get(bopId);
            if (tmp2 != null) {
                stats.add(tmp2);
            }
        }
        long unitsIn = stats.unitsIn.get();
        long unitsOut = stats.unitsOut.get();
        sb.append('\t');
        if (bop != null) {
            RunState.RunStateEnum runState = ((AbstractRunningQuery)q).tryGetRunState(bopId);
            sb.append(runState == null ? NA : runState.name());
        } else {
            sb.append(NA);
        }
        sb.append('\t');
        sb.append(stats.elapsed.get());
        sb.append('\t');
        sb.append(stats.opCount.get());
        sb.append('\t');
        sb.append(Long.toString(numRunning));
        sb.append('\t');
        sb.append(Integer.toString(fanOut));
        QueueStats queueStats2 = tmp = queueStats == null ? null : queueStats.get(bopId);
        if (tmp != null) {
            sb.append('\t');
            sb.append(tmp.shardSet.size());
            sb.append('\t');
            sb.append(tmp.chunkCount);
            sb.append('\t');
            sb.append(tmp.solutionCount);
        } else {
            sb.append('\t');
            sb.append('\t');
            sb.append('\t');
        }
        sb.append('\t');
        sb.append(stats.chunksIn.get());
        sb.append('\t');
        sb.append(stats.unitsIn.get());
        sb.append('\t');
        sb.append(Double.toString(QueryLog.avg(stats.unitsIn.get(), stats.chunksIn.get())));
        sb.append('\t');
        sb.append(stats.chunksOut.get());
        sb.append('\t');
        sb.append(stats.unitsOut.get());
        sb.append('\t');
        sb.append(Double.toString(QueryLog.avg(stats.unitsOut.get(), stats.chunksOut.get())));
        sb.append('\t');
        sb.append(stats.mutationCount.get());
        sb.append('\t');
        sb.append(stats.typeErrors.get());
        sb.append('\t');
        sb.append(unitsIn == 0L ? NA : Double.valueOf((double)unitsOut / (double)unitsIn));
        sb.append('\t');
        sb.append(stats.accessPathDups.get());
        sb.append('\t');
        sb.append(stats.accessPathCount.get());
        sb.append('\t');
        sb.append(stats.accessPathRangeCount.get());
        sb.append('\t');
        sb.append(stats.accessPathChunksIn.get());
        sb.append('\t');
        sb.append(stats.accessPathUnitsIn.get());
        sb.append('\t');
        sb.append(elapsed == 0L ? 0L : stats.unitsOut.get() / elapsed);
        sb.append('\t');
        sb.append(elapsed == 0L ? 0L : stats.mutationCount.get() / elapsed);
        sb.append('\n');
        return sb.toString();
    }

    public static void getTableXHTML(String queryStr, IRunningQuery q, IRunningQuery[] children, Writer w, boolean summaryOnly, int maxBopLength, boolean clusterStats, boolean detailedStats, boolean mutationStats) throws IOException {
        w.write("<table border=\"1\" summary=\"" + QueryLog.attrib("Query Statistics") + "\"\n>");
        QueryLog.getTableHeaderXHTML(w, clusterStats, detailedStats, mutationStats);
        Map<Integer, QueueStats> queueStats = ((ChunkedRunningQuery)q).getQueueStats();
        QueryLog.getSummaryRowXHTML(queryStr, q, w, queueStats, maxBopLength, clusterStats, detailedStats, mutationStats);
        if (!summaryOnly) {
            QueryLog.getTableRowsXHTML(queryStr, q, w, queueStats, maxBopLength, clusterStats, detailedStats, mutationStats);
        }
        if (!summaryOnly && children != null) {
            for (int i = 0; i < children.length; ++i) {
                IRunningQuery c = children[i];
                QueryLog.getTableHeaderXHTML(w, clusterStats, detailedStats, mutationStats);
                Map<Integer, QueueStats> queueStats2 = ((ChunkedRunningQuery)c).getQueueStats();
                QueryLog.getSummaryRowXHTML(null, c, w, queueStats2, maxBopLength, clusterStats, detailedStats, mutationStats);
                QueryLog.getTableRowsXHTML(null, c, w, queueStats2, maxBopLength, clusterStats, detailedStats, mutationStats);
            }
        }
        w.write("</table\n>");
    }

    public static void getTableHeaderXHTML(Writer w, boolean clusterStats, boolean detailedStats, boolean mutationStats) throws IOException {
        w.write("<tr\n>");
        w.write("<th>queryId</th>");
        if (detailedStats) {
            w.write("<th>beginTime</th>");
            w.write("<th>doneTime</th>");
        }
        w.write("<th>deadline</th>");
        w.write("<th>elapsed</th>");
        if (clusterStats) {
            w.write("<th>serviceId</th>");
        }
        w.write("<th>cause</th>");
        w.write("<th>evalOrder</th>");
        if (clusterStats) {
            w.write("<th>evalContext</th>");
        }
        if (detailedStats) {
            w.write("<th>controller</th>");
            w.write("<th>bopId</th>");
            w.write("<th>predId</th>");
        }
        w.write("<th>bopSummary</th>");
        w.write("<th>predSummary</th>");
        if (detailedStats) {
            w.write("<th>bopAnnotations</th>");
            w.write("<th>predAnnotations</th>");
        }
        if (detailedStats) {
            w.write("<th>staticBestKeyOrder</th>");
            w.write("<th>overriddenKeyOrder</th>");
        }
        w.write("<th>nvars</th>");
        w.write("<th>fastRangeCount</th>");
        if (detailedStats) {
            w.write("<th>runState</th>");
        }
        w.write("<th>sumMillis</th>");
        if (detailedStats) {
            w.write("<th>opCount</th>");
            w.write("<th>numRunning</th>");
        }
        if (clusterStats) {
            w.write("<th>fanOut</th>");
            w.write("<th>queueShards</th>");
        }
        if (detailedStats) {
            w.write("<th>queueChunks</th>");
            w.write("<th>queueSolutions</th>");
            w.write("<th>chunksIn</th>");
        }
        w.write("<th>unitsIn</th>");
        if (detailedStats) {
            w.write("<th>unitsInPerChunk</th>");
            w.write("<th>chunksOut</th>");
        }
        w.write("<th>unitsOut</th>");
        if (detailedStats) {
            w.write("<th>unitsOutPerChunk</th>");
        }
        if (mutationStats) {
            w.write("<th>mutationCount</th>");
        }
        w.write("<th>typeErrors</th>");
        w.write("<th>joinRatio</th>");
        if (detailedStats) {
            w.write("<th>accessPathDups</th>");
            w.write("<th>accessPathCount</th>");
            w.write("<th>accessPathRangeCount</th>");
            w.write("<th>accessPathChunksIn</th>");
            w.write("<th>accessPathUnitsIn</th>");
        }
        if (detailedStats) {
            w.write("<th>");
            w.write(QueryLog.cdata("solutions/ms"));
            w.write("</th>");
        }
        if (mutationStats) {
            w.write("<th>");
            w.write(QueryLog.cdata("mutations/ms"));
            w.write("</th>");
        }
        w.write("</tr\n>");
    }

    public static void getTableRowsXHTML(String queryStr, IRunningQuery q, Writer w, Map<Integer, QueueStats> queueStats, int maxBopLength, boolean clusterStats, boolean detailedStats, boolean mutationStats) throws IOException {
        Integer[] order = BOpUtility.getEvaluationOrder(q.getQuery());
        int orderIndex = 0;
        for (Integer bopId : order) {
            QueryLog.getTableRowXHTML(queryStr, q, w, orderIndex, bopId, false, queueStats, maxBopLength, clusterStats, detailedStats, mutationStats);
            ++orderIndex;
        }
    }

    private static void getTableRowXHTML(String queryStr, IRunningQuery q, Writer w, int evalOrder, Integer bopId, boolean summary, Map<Integer, QueueStats> queueStats, int maxBopLength, boolean clusterStats, boolean detailedStats, boolean mutationStats) throws IOException {
        QueueStats tmp;
        Integer predId;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        long elapsed = q.getElapsed();
        UUID serviceId = q.getQueryEngine().getServiceUUID();
        Throwable cause = q.getCause();
        w.write("<tr\n>");
        w.write(TD + QueryLog.cdata(q.getQueryId().toString()) + TDx);
        if (detailedStats) {
            w.write(TD + dateFormat.format(new Date(q.getStartTime())) + TDx);
            w.write(TD + QueryLog.cdata(dateFormat.format(new Date(q.getDoneTime()))) + TDx);
        }
        w.write(TD);
        if (q.getDeadline() != Long.MAX_VALUE) {
            w.write(QueryLog.cdata(dateFormat.format(new Date(q.getDeadline()))));
        }
        w.write(TDx);
        w.write(TD + QueryLog.cdata(Long.toString(elapsed)) + TDx);
        if (clusterStats) {
            w.write(TD);
            w.write(QueryLog.cdata(serviceId == null ? NA : serviceId.toString()));
            w.write(TDx);
        }
        w.write(TD);
        if (cause != null) {
            String msg = cause.getLocalizedMessage();
            if (msg == null) {
                msg = cause.toString();
            }
            w.write(QueryLog.cdata(msg));
        }
        w.write(TDx);
        Map<Integer, BOp> bopIndex = q.getBOpIndex();
        Map<Integer, BOpStats> statsMap = q.getStats();
        BOp bop = bopIndex.get(bopId);
        if (summary) {
            w.write(TD);
            w.write("total");
            w.write(TDx);
            if (clusterStats) {
                w.write(TD);
                w.write(TDx);
            }
            if (detailedStats) {
                w.write(TD);
                w.write(TDx);
                w.write(TD);
                w.write("total");
                w.write(TDx);
            }
        } else {
            w.write(TD);
            w.write(Integer.toString(evalOrder));
            w.write(TDx);
            if (clusterStats) {
                w.write(TD);
                w.write(QueryLog.cdata(bop.getEvaluationContext().toString()));
                w.write(TDx);
            }
            if (detailedStats) {
                w.write(TD);
                w.write(QueryLog.cdata(bop.getProperty(BOp.Annotations.CONTROLLER, false).toString()));
                w.write(TDx);
                w.write(TD);
                w.write(Integer.toString(bopId));
                w.write(TDx);
            }
        }
        IPredicate pred = summary ? null : (IPredicate)bop.getProperty(PipelineJoin.Annotations.PREDICATE);
        Integer n = predId = pred == null ? null : (Integer)pred.getProperty(BOp.Annotations.BOP_ID);
        if (detailedStats) {
            w.write(TD);
            if (predId != null) {
                w.write(QueryLog.cdata(predId.toString()));
            } else if (pred != null) {
                w.write(QueryLog.cdata(NA));
            }
            w.write(TDx);
        }
        w.write(TD);
        if (summary) {
            w.write("total");
        } else {
            w.write(QueryLog.cdata(bop.getClass().getSimpleName()));
            w.write(QueryLog.cdata("[" + bopId + "]"));
        }
        w.write(TDx);
        w.write(TD);
        if (!summary) {
            if (pred != null) {
                w.write(QueryLog.cdata(pred.getClass().getSimpleName()));
                w.write(QueryLog.cdata("[" + predId + "]("));
                Iterator<BOp> itr = pred.argIterator();
                boolean first = true;
                while (itr.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        w.write(QueryLog.cdata(", "));
                    }
                    IVariableOrConstant x = (IVariableOrConstant)itr.next();
                    if (x.isVar()) {
                        w.write(QueryLog.cdata("?"));
                        w.write(QueryLog.cdata(x.getName()));
                        continue;
                    }
                    w.write(QueryLog.cdata(x.get().toString()));
                }
                w.write(QueryLog.cdata(")"));
            }
            if (bop.getProperty("namedSetRef") != null) {
                Object namedSetRef = bop.getProperty("namedSetRef");
                if (namedSetRef instanceof INamedSolutionSetRef) {
                    INamedSolutionSetRef ref = (INamedSolutionSetRef)namedSetRef;
                    IRunningQuery t = QueryLog.getRunningQuery(q, ref.getQueryId());
                    if (t != null) {
                        IQueryAttributes attrs = t == null ? null : t.getAttributes();
                        IHashJoinUtility iHashJoinUtility = (IHashJoinUtility)(attrs == null ? null : attrs.get(ref));
                        if (iHashJoinUtility != null) {
                            w.write(QueryLog.cdata(iHashJoinUtility.toString()));
                            w.write(QueryLog.cdata(",namedSet="));
                            w.write(QueryLog.cdata(ref.getLocalName()));
                        } else {
                            w.write(QueryLog.cdata(ref.toString()));
                        }
                    }
                } else {
                    INamedSolutionSetRef[] refs = (INamedSolutionSetRef[])namedSetRef;
                    for (int i = 0; i < refs.length; ++i) {
                        IRunningQuery iRunningQuery;
                        INamedSolutionSetRef ref = refs[i];
                        if (i > 0) {
                            w.write(QueryLog.cdata(","));
                        }
                        if ((iRunningQuery = QueryLog.getRunningQuery(q, ref.getQueryId())) == null) continue;
                        IQueryAttributes attrs = iRunningQuery == null ? null : iRunningQuery.getAttributes();
                        IHashJoinUtility state = (IHashJoinUtility)(attrs == null ? null : attrs.get(ref));
                        if (state != null) {
                            w.write(QueryLog.cdata(state.toString()));
                            continue;
                        }
                        w.write(QueryLog.cdata(ref.toString()));
                    }
                }
            }
            if (bop instanceof ChunkedMaterializationOp) {
                w.write(QueryLog.cdata("vars=" + Arrays.toString(((ChunkedMaterializationOp)bop).getVars()) + ",materializeInlineIVs=" + ((ChunkedMaterializationOp)bop).materializeInlineIVs()));
            }
            if (bop instanceof GroupByOp) {
                w.write(QueryLog.cdata(((GroupByOp)bop).getGroupByState().toString()));
                if (detailedStats) {
                    w.write(QueryLog.cdata(" "));
                    w.write(QueryLog.cdata(((GroupByOp)bop).getGroupByRewrite().toString()));
                }
            }
            if (bop instanceof DropOp) {
                w.write(QueryLog.cdata(Arrays.toString(((DropOp)bop).getDropVars())));
            }
            if (bop instanceof ConditionalRoutingOp) {
                w.write(QueryLog.cdata(((ConditionalRoutingOp)bop).getCondition().toString()));
            }
            if (bop instanceof JoinGraph) {
                JoinGraph t = (JoinGraph)bop;
                Path p = t.getPath(q);
                Map<PathIds, EdgeSample> samples = t.getSamples(q);
                w.write(QueryLog.cdata("sampleType=" + (Object)((Object)t.getSampleType())));
                w.write(QueryLog.cdata(", limit=" + t.getLimit()));
                w.write(QueryLog.cdata(", nedges=" + t.getNEdges()));
                if (p != null && samples != null) {
                    w.write("<pre>");
                    w.write(QueryLog.cdata(JGraph.showPath(p, samples)));
                    w.write("</pre>");
                }
            }
            if (bop instanceof ProjectionOp) {
                w.write(QueryLog.cdata(Arrays.toString(((ProjectionOp)bop).getVariables())));
            }
            if (bop instanceof SliceOp) {
                w.write(QueryLog.cdata("offset=" + ((SliceOp)bop).getOffset()));
                w.write(QueryLog.cdata(", limit=" + ((SliceOp)bop).getLimit()));
            }
        }
        w.write(TDx);
        if (detailedStats) {
            w.write(TD);
            if (!summary) {
                QueryLog.showAnnotations(w, bop.annotations());
            }
            w.write(TDx);
        }
        if (detailedStats) {
            w.write(TD);
            if (pred != null) {
                QueryLog.showAnnotations(w, pred.annotations());
            }
            w.write(TDx);
        }
        if (pred != null) {
            IKeyOrder keyOrder = (IKeyOrder)pred.getProperty(AST2BOpBase.Annotations.ORIGINAL_INDEX);
            Object overrideKeyOrder = pred.getProperty(IPredicate.Annotations.KEY_ORDER);
            Long rangeCount = (Long)pred.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY);
            if (detailedStats) {
                w.write(TD);
                if (keyOrder != null) {
                    w.write(keyOrder.toString());
                }
                w.write(TDx);
                w.write(TD);
                if (overrideKeyOrder != null) {
                    w.write(overrideKeyOrder.toString());
                }
                w.write(TDx);
            }
            w.write(TD);
            if (keyOrder != null) {
                w.write(Integer.toString(pred.getVariableCount(keyOrder)));
            }
            w.write(TDx);
            w.write(TD);
            if (rangeCount != null) {
                w.write(Long.toString(rangeCount));
            }
            w.write(TDx);
        } else {
            if (detailedStats) {
                w.write(TD);
                w.write(TDx);
                w.write(TD);
                w.write(TDx);
            }
            w.write(TD);
            w.write(TDx);
            w.write(TD);
            w.write(TDx);
        }
        long numRunning = ((AbstractRunningQuery)q).getRunningCount(bopId);
        PipelineJoinStats stats = new PipelineJoinStats();
        if (summary) {
            for (BOpStats bOpStats : statsMap.values()) {
                stats.add(bOpStats);
            }
        } else {
            BOpStats tmp2 = statsMap.get(bopId);
            if (tmp2 != null) {
                stats.add(tmp2);
            }
        }
        long unitsIn = stats.unitsIn.get();
        long unitsOut = stats.unitsOut.get();
        if (detailedStats) {
            w.write(TD);
            if (bop != null) {
                RunState.RunStateEnum runState = ((AbstractRunningQuery)q).tryGetRunState(bopId);
                w.write(QueryLog.cdata(runState == null ? NA : runState.name()));
            } else {
                w.write(QueryLog.cdata(NA));
            }
            w.write(TDx);
        }
        w.write(TD);
        w.write(Long.toString(stats.elapsed.get()));
        w.write(TDx);
        if (detailedStats) {
            w.write(TD);
            w.write(Long.toString(stats.opCount.get()));
            w.write(TDx);
            w.write(TD);
            w.write(Long.toString(numRunning));
            w.write(TDx);
        }
        if (clusterStats) {
            int fanOut = ((AbstractRunningQuery)q).getStartedOnCount(bopId);
            w.write(TD);
            w.write(Integer.toString(fanOut));
            w.write(TDx);
        }
        QueueStats queueStats2 = tmp = queueStats == null ? null : queueStats.get(bopId);
        if (tmp != null) {
            if (clusterStats) {
                w.write(TD);
                w.write(Long.toString(tmp.shardSet.size()));
                w.write(TDx);
            }
            if (detailedStats) {
                w.write(TD);
                w.write(Long.toString(tmp.chunkCount));
                w.write(TDx);
                w.write(TD);
                w.write(Long.toString(tmp.solutionCount));
                w.write(TDx);
            }
        } else {
            if (clusterStats) {
                w.write(TD);
                w.write(TDx);
            }
            if (detailedStats) {
                w.write(TD);
                w.write(TDx);
                w.write(TD);
                w.write(TDx);
            }
        }
        if (detailedStats) {
            w.write(TD);
            w.write(Long.toString(stats.chunksIn.get()));
            w.write(TDx);
        }
        w.write(TD);
        w.write(Long.toString(stats.unitsIn.get()));
        w.write(TDx);
        if (detailedStats) {
            w.write(TD);
            w.write(Double.toString(QueryLog.avg(stats.unitsIn.get(), stats.chunksIn.get())));
            w.write(TDx);
            w.write(TD);
            w.write(Long.toString(stats.chunksOut.get()));
            w.write(TDx);
        }
        w.write(TD);
        w.write(Long.toString(stats.unitsOut.get()));
        w.write(TDx);
        if (detailedStats) {
            w.write(TD);
            w.write(Double.toString(QueryLog.avg(stats.unitsOut.get(), stats.chunksOut.get())));
            w.write(TDx);
        }
        if (mutationStats) {
            w.write(TD);
            w.write(QueryLog.cdata(Long.toString(stats.mutationCount.get())));
            w.write(TDx);
        }
        w.write(TD);
        w.write(Long.toString(stats.typeErrors.get()));
        w.write(TDx);
        w.write(TD);
        w.write(QueryLog.cdata(unitsIn == 0L ? NA : Double.toString((double)unitsOut / (double)unitsIn)));
        w.write(TDx);
        if (detailedStats) {
            w.write(TD);
            w.write(Long.toString(stats.accessPathDups.get()));
            w.write(TDx);
            w.write(TD);
            w.write(Long.toString(stats.accessPathCount.get()));
            w.write(TDx);
            w.write(TD);
            w.write(Long.toString(stats.accessPathRangeCount.get()));
            w.write(TDx);
            w.write(TD);
            w.write(Long.toString(stats.accessPathChunksIn.get()));
            w.write(TDx);
            w.write(TD);
            w.write(Long.toString(stats.accessPathUnitsIn.get()));
            w.write(TDx);
        }
        if (detailedStats) {
            w.write(TD);
            w.write(QueryLog.cdata(elapsed == 0L ? "0" : Long.toString(stats.unitsOut.get() / elapsed)));
            w.write(TDx);
        }
        if (mutationStats) {
            w.write(TD);
            w.write(QueryLog.cdata(elapsed == 0L ? "0" : Long.toString(stats.mutationCount.get() / elapsed)));
            w.write(TDx);
        }
        w.write("</tr\n>");
    }

    private static void showAnnotations(Writer w, Map<String, Object> anns) throws IOException {
        if (anns != null && !anns.isEmpty()) {
            w.write("<dl>");
            for (Map.Entry<String, Object> e : anns.entrySet()) {
                w.write("<dt>");
                String key = e.getKey();
                w.write(QueryLog.cdata(key));
                w.write("</dt><dd>");
                Object val = e.getValue();
                if (val != null && val.getClass().isArray()) {
                    w.write(QueryLog.cdata(Arrays.toString((Object[])val)));
                } else if (key.equals(IPredicate.Annotations.FLAGS)) {
                    w.write(QueryLog.cdata(Tuple.flagString((Integer)val)));
                } else if (val instanceof BOp) {
                    w.write(QueryLog.cdata(((BOp)val).toShortString()));
                } else {
                    w.write(QueryLog.cdata("" + val));
                }
                w.write("</dd>");
            }
            w.write("</dl>");
        }
    }

    private static void getSummaryRowXHTML(String queryStr, IRunningQuery q, Writer w, Map<Integer, QueueStats> queueStats, int maxBopLength, boolean clusterStats, boolean detailedStats, boolean mutationStats) throws IOException {
        QueryLog.getTableRowXHTML(queryStr, q, w, -1, q.getQuery().getId(), true, queueStats, maxBopLength, clusterStats, detailedStats, mutationStats);
    }

    private static String cdata(String s) {
        return XHTMLRenderer.cdata(s);
    }

    private static String attrib(String s) {
        return XHTMLRenderer.attrib(s);
    }

    private static double avg(long x, long y) {
        if (y == 0L) {
            return 0.0;
        }
        return (double)x / (double)y;
    }

    private static IRunningQuery getRunningQuery(IRunningQuery q, UUID queryId) {
        if (q.getQueryId().equals(queryId)) {
            return q;
        }
        try {
            return q.getQueryEngine().getRunningQuery(queryId);
        }
        catch (RuntimeException t) {
            return null;
        }
    }

    static {
        QueryLog.logTableHeader();
    }
}

