/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.join;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.rdf.join.ChunkedMaterializationOp;
import com.bigdata.rdf.lexicon.LexiconRelation;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.NoSuchElementException;

public class ChunkedMaterializationIterator
implements ICloseableIterator<IBindingSet[]> {
    private final IVariable<?>[] required;
    private final LexiconRelation lex;
    private final boolean materializeInlineIVs;
    private final ICloseableIterator<IBindingSet[]> src;
    private boolean open = false;

    public ChunkedMaterializationIterator(IVariable<?>[] vars, LexiconRelation lex, boolean materializeInlineIVs, ICloseableIterator<IBindingSet[]> src) {
        if (vars == null) {
            throw new IllegalArgumentException();
        }
        if (vars != null && vars.length == 0) {
            throw new IllegalArgumentException();
        }
        if (lex == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.required = vars;
        this.lex = lex;
        this.materializeInlineIVs = materializeInlineIVs;
        this.src = src;
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            this.src.close();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.open && !this.src.hasNext()) {
            this.close();
            return false;
        }
        return this.open;
    }

    @Override
    public IBindingSet[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IBindingSet[] chunk = (IBindingSet[])this.src.next();
        ChunkedMaterializationOp.resolveChunk(this.required, this.lex, chunk, this.materializeInlineIVs);
        return chunk;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

