/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.update;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.rdf.update.AbstractAddRemoveStatementsOp;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public final class RemoveStatementsOp
extends AbstractAddRemoveStatementsOp {
    private static final long serialVersionUID = 1L;

    public RemoveStatementsOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public RemoveStatementsOp(RemoveStatementsOp op) {
        super(op);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(context, this));
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final AbstractTripleStore tripleStore;
        private final boolean sids;
        private final boolean quads;

        public ChunkTask(BOpContext<IBindingSet> context, RemoveStatementsOp op) {
            this.context = context;
            String namespace = ((String[])op.getRequiredProperty(AbstractAddRemoveStatementsOp.Annotations.RELATION_NAME))[0];
            long timestamp = (Long)op.getRequiredProperty(AbstractAddRemoveStatementsOp.Annotations.TIMESTAMP);
            this.tripleStore = (AbstractTripleStore)context.getResource(namespace, timestamp);
            this.sids = this.tripleStore.isStatementIdentifiers();
            this.quads = this.tripleStore.isQuads();
        }

        @Override
        public Void call() throws Exception {
            boolean bindsC = this.sids | this.quads;
            Set<ISPO> b = AbstractAddRemoveStatementsOp.acceptSolutions(this.context, bindsC);
            ISPO[] stmts = b.toArray(new ISPO[b.size()]);
            long nmodified = this.tripleStore.removeStatements(stmts, stmts.length);
            this.context.getStats().mutationCount.add(nmodified);
            return null;
        }
    }
}

