/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsynchronizedArrayBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class SliceOp
extends PipelineOp {
    private static final transient Logger log = Logger.getLogger(SliceOp.class);
    private static final long serialVersionUID = 1L;

    public SliceOp(SliceOp op) {
        super(op);
    }

    public SliceOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public SliceOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        switch (this.getEvaluationContext()) {
            case CONTROLLER: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(Annotations.EVALUATION_CONTEXT + "=" + (Object)((Object)this.getEvaluationContext()));
            }
        }
        if (!this.isPipelinedEvaluation()) {
            throw new UnsupportedOperationException(Annotations.PIPELINED + "=" + this.isPipelinedEvaluation());
        }
        if (!this.isSharedState()) {
            throw new UnsupportedOperationException(Annotations.SHARED_STATE + "=" + this.isSharedState());
        }
        if (this.isReorderSolutions()) {
            throw new UnsupportedOperationException(Annotations.REORDER_SOLUTIONS + "=" + this.isReorderSolutions());
        }
    }

    public long getOffset() {
        return this.getProperty(Annotations.OFFSET, 0L);
    }

    public long getLimit() {
        return this.getProperty(Annotations.LIMIT, Long.MAX_VALUE);
    }

    @Override
    public SliceStats newStats() {
        return new SliceStats();
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new SliceTask(this, context));
    }

    private static class SliceTask
    implements Callable<Void> {
        private final SliceOp op;
        private final BOpContext<IBindingSet> context;
        private final long offset;
        private final long limit;
        private final SliceStats stats;

        SliceTask(SliceOp op, BOpContext<IBindingSet> context) {
            this.op = op;
            this.context = context;
            this.offset = op.getOffset();
            this.limit = op.getLimit();
            if (this.offset < 0L) {
                throw new IllegalArgumentException(Annotations.OFFSET);
            }
            if (this.limit < 0L) {
                throw new IllegalArgumentException(Annotations.LIMIT);
            }
            this.stats = (SliceStats)context.getStats();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() throws Exception {
            ICloseableIterator<IBindingSet[]> source = this.context.getSource();
            try (IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();){
                UnsynchronizedArrayBuffer<IBindingSet> out = new UnsynchronizedArrayBuffer<IBindingSet>(sink, IBindingSet.class, this.op.getChunkCapacity());
                while (source.hasNext()) {
                    IBindingSet[] chunk = (IBindingSet[])source.next();
                    SliceStats sliceStats = this.stats;
                    synchronized (sliceStats) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(this.toString() + ": stats=" + this.stats + ", sink=" + sink));
                        }
                        boolean halt = this.handleChunk(out, chunk);
                        if (!out.isEmpty()) {
                            out.flush();
                        }
                        sink.flush();
                        if (halt) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)"Slice will interrupt query.");
                            }
                            this.context.getRunningQuery().halt((Void)null);
                        }
                    }
                }
                return null;
            }
        }

        private boolean handleChunk(UnsynchronizedArrayBuffer<IBindingSet> out, IBindingSet[] chunk) {
            this.stats.chunksIn.increment();
            for (int i = 0; i < chunk.length; ++i) {
                long A2;
                if (this.stats.naccepted.get() >= this.limit) {
                    return true;
                }
                this.stats.unitsIn.increment();
                long S = this.stats.nseen.incrementAndGet();
                if (S <= this.offset || (A2 = this.stats.naccepted.get()) >= this.limit) continue;
                IBindingSet bset = chunk[i];
                out.add(bset);
                this.stats.naccepted.incrementAndGet();
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)(this.toString() + ":" + bset));
            }
            return false;
        }

        public String toString() {
            return super.toString() + "{offset=" + this.offset + ",limit=" + this.limit + ",nseen=" + this.stats.nseen + ",naccepted=" + this.stats.naccepted + "}";
        }
    }

    public static class SliceStats
    extends BOpStats {
        private static final long serialVersionUID = 1L;
        public final AtomicLong nseen = new AtomicLong();
        public final AtomicLong naccepted = new AtomicLong();

        @Override
        public void add(BOpStats o) {
            if (this == o) {
                return;
            }
            super.add(o);
            if (o instanceof SliceStats) {
                SliceStats t = (SliceStats)o;
                this.nseen.addAndGet(t.nseen.get());
                this.naccepted.addAndGet(t.naccepted.get());
            }
        }

        @Override
        protected void toString(StringBuilder sb) {
            sb.append(",nseen=" + this.nseen);
            sb.append(",naccepted=" + this.naccepted);
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String OFFSET = SliceOp.class.getName() + ".offset";
        public static final long DEFAULT_OFFSET = 0L;
        public static final String LIMIT = SliceOp.class.getName() + ".limit";
        public static final long DEFAULT_LIMIT = Long.MAX_VALUE;
    }
}

