/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractTuple;
import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.ResultSet;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rawstore.IBlock;
import cutthecrap.utils.striterators.IFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public abstract class AbstractChunkedTupleIterator<E>
implements ITupleIterator<E> {
    protected static final transient Logger log = Logger.getLogger(AbstractChunkedTupleIterator.class);
    protected static final transient boolean INFO = log.isInfoEnabled();
    protected static final transient boolean DEBUG = log.isDebugEnabled();
    protected static final transient String ERR_NO_KEYS = "Keys not requested";
    protected static final transient String ERR_NO_VALS = "Values not requested";
    protected final byte[] fromKey;
    protected final byte[] toKey;
    protected final int capacity;
    protected final int flags;
    protected final IFilter filter;
    protected int nqueries = 0;
    protected ResultSet rset = null;
    private long commitTime = 0L;
    protected long nvisited = 0L;
    protected int lastVisited = -1;
    protected boolean exhausted = false;
    protected byte[] lastVisitedKeyInPriorResultSet;
    private ResultSetTuple tuple = null;
    private ArrayList<byte[]> removeList;

    protected abstract long getTimestamp();

    protected long getCommitTime() {
        return this.commitTime;
    }

    protected abstract boolean getReadConsistent();

    protected final long getReadTime() {
        if (this.getTimestamp() == -1L && this.getReadConsistent()) {
            if (this.commitTime == 0L) {
                throw new IllegalStateException();
            }
            return TimestampUtility.asHistoricalRead(this.commitTime);
        }
        return this.getTimestamp();
    }

    public int getQueryCount() {
        return this.nqueries;
    }

    public long getVisitedCount() {
        return this.nvisited;
    }

    protected int getDefaultCapacity() {
        return 100;
    }

    public AbstractChunkedTupleIterator(byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.capacity = capacity == 0 ? this.getDefaultCapacity() : capacity;
        this.flags = flags;
        this.filter = filter;
    }

    protected abstract ResultSet getResultSet(long var1, byte[] var3, byte[] var4, int var5, int var6, IFilter var7);

    protected void rangeQuery() {
        assert (!this.exhausted);
        if (INFO) {
            log.info((Object)("nqueries=" + this.nqueries + ", fromKey=" + BytesUtil.toString(this.fromKey) + ", toKey=" + BytesUtil.toString(this.toKey)));
        }
        this.rset = this.getResultSet(this.getTimestamp(), this.fromKey, this.toKey, this.capacity, this.flags, this.filter);
        this.commitTime = this.rset.getCommitTime();
        this.lastVisited = -1;
        ++this.nqueries;
        if (INFO) {
            log.info((Object)("Got chunk: ntuples=" + this.rset.getNumTuples() + ", exhausted=" + this.rset.isExhausted() + ", lastKey=" + BytesUtil.toString(this.rset.getLastKey())));
        }
    }

    protected void continuationQuery() {
        assert (!this.exhausted);
        assert (this.rset != null);
        assert (!this.rset.isExhausted());
        byte[] byArray = this.lastVisitedKeyInPriorResultSet = this.tuple.getKeysRequested() ? this.tuple.getKey() : null;
        if ((this.flags & 0x40) == 0) {
            byte[] _fromKey;
            boolean fixedLengthSuccessor = this.flags * 128 != 0;
            byte[] byArray2 = _fromKey = fixedLengthSuccessor ? SuccessorUtil.successor((byte[])this.rset.getLastKey().clone()) : BytesUtil.successor(this.rset.getLastKey());
            if (INFO) {
                log.info((Object)("forwardScan: fromKey=" + BytesUtil.toString(_fromKey) + ", toKey=" + BytesUtil.toString(this.toKey)));
            }
            this.rset = this.getResultSet(this.getReadTime(), _fromKey, this.toKey, this.capacity, this.flags, this.filter);
        } else {
            byte[] _toKey = this.rset.getLastKey();
            if (INFO) {
                log.info((Object)("reverseScan: fromKey=" + BytesUtil.toString(this.fromKey) + ", toKey=" + BytesUtil.toString(_toKey)));
            }
            this.rset = this.getResultSet(this.getReadTime(), this.fromKey, _toKey, this.capacity, this.flags, this.filter);
        }
        this.lastVisited = -1;
        ++this.nqueries;
        this.deleteBehind();
    }

    @Override
    public boolean hasNext() {
        if (this.nqueries == 0) {
            this.rangeQuery();
        }
        assert (this.rset != null);
        if (this.exhausted) {
            return false;
        }
        int ntuples = this.rset.getNumTuples();
        if (ntuples > 0 && this.lastVisited + 1 < ntuples) {
            return true;
        }
        if (!this.rset.isExhausted()) {
            this.continuationQuery();
            return this.hasNext();
        }
        this.exhausted = true;
        this.flush();
        return false;
    }

    @Override
    public ITuple<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastVisitedKeyInPriorResultSet = null;
        ++this.nvisited;
        ++this.lastVisited;
        this.tuple = new ResultSetTuple(this.rset, this.lastVisited);
        return this.tuple;
    }

    @Override
    public synchronized void remove() {
        byte[] key;
        if (this.nvisited == 0L) {
            throw new IllegalStateException();
        }
        if (!this.tuple.getKeysRequested()) {
            throw new UnsupportedOperationException(ERR_NO_KEYS);
        }
        if (this.removeList == null) {
            this.removeList = new ArrayList(this.capacity);
        }
        byte[] byArray = key = this.lastVisited == -1 ? this.lastVisitedKeyInPriorResultSet : this.tuple.getKey();
        assert (key != null);
        if (!this.exhausted && this.nvisited < (long)this.capacity) {
            this.removeList.add(key);
        } else {
            this.deleteLast(key);
        }
    }

    public void flush() {
        this.deleteBehind();
    }

    protected void deleteBehind() {
        if (this.removeList == null || this.removeList.isEmpty()) {
            return;
        }
        this.deleteBehind(this.removeList.size(), this.removeList.iterator());
        this.removeList.clear();
    }

    protected abstract void deleteBehind(int var1, Iterator<byte[]> var2);

    protected abstract void deleteLast(byte[] var1);

    protected abstract IBlock readBlock(int var1, long var2);

    public class ResultSetTuple
    implements ITuple<E> {
        private final ResultSet rset;
        private final int lastVisited;
        private DataOutputBuffer keyBuffer = null;
        private DataOutputBuffer valueBuffer = null;

        protected ResultSetTuple(ResultSet rset, int lastVisited) {
            this.rset = rset;
            this.lastVisited = lastVisited;
        }

        @Override
        public int getSourceIndex() {
            if (this.lastVisited == -1) {
                throw new IllegalStateException();
            }
            return this.rset.getSourceIndex(this.lastVisited);
        }

        @Override
        public int flags() {
            return AbstractChunkedTupleIterator.this.flags;
        }

        @Override
        public boolean getKeysRequested() {
            return (AbstractChunkedTupleIterator.this.flags & 1) != 0;
        }

        @Override
        public boolean getValuesRequested() {
            return (AbstractChunkedTupleIterator.this.flags & 2) != 0;
        }

        @Override
        public byte[] getKey() {
            if (this.lastVisited == -1) {
                throw new IllegalStateException();
            }
            return this.rset.getKeys().get(this.lastVisited);
        }

        @Override
        public ByteArrayBuffer getKeyBuffer() {
            if (this.lastVisited == -1) {
                throw new IllegalStateException();
            }
            if (this.keyBuffer == null) {
                int initialCapacity = this.rset.getKeys().length(this.lastVisited);
                this.keyBuffer = new DataOutputBuffer(initialCapacity);
            }
            this.keyBuffer.reset();
            this.rset.getKeys().copy(this.lastVisited, this.keyBuffer);
            this.keyBuffer.flip();
            return this.keyBuffer;
        }

        @Override
        public DataInputBuffer getKeyStream() {
            return new DataInputBuffer(this.getKeyBuffer());
        }

        @Override
        public byte[] getValue() {
            if (this.lastVisited == -1) {
                throw new IllegalStateException();
            }
            if (!this.getValuesRequested()) {
                throw new UnsupportedOperationException();
            }
            return this.rset.getValues().get(this.lastVisited);
        }

        @Override
        public boolean isNull() {
            return this.getValue() == null;
        }

        @Override
        public ByteArrayBuffer getValueBuffer() {
            if (this.lastVisited == -1) {
                throw new IllegalStateException();
            }
            if (this.valueBuffer == null) {
                int initialCapacity = this.rset.getValues().length(this.lastVisited);
                this.valueBuffer = new DataOutputBuffer(initialCapacity);
            }
            this.valueBuffer.reset();
            this.rset.getValues().copy(this.lastVisited, this.valueBuffer);
            this.valueBuffer.flip();
            return this.valueBuffer;
        }

        @Override
        public DataInputBuffer getValueStream() {
            return new DataInputBuffer(this.getValueBuffer());
        }

        @Override
        public E getObject() {
            if (this.lastVisited == -1) {
                throw new IllegalStateException();
            }
            return this.rset.getTupleSerializer().deserialize(this);
        }

        @Override
        public long getVersionTimestamp() {
            if (this.lastVisited == -1) {
                throw new IllegalStateException();
            }
            if (!this.rset.hasVersionTimestamps()) {
                return 0L;
            }
            return this.rset.getVersionTimestamp(this.lastVisited);
        }

        @Override
        public boolean isDeletedVersion() {
            if (this.lastVisited == -1) {
                throw new IllegalStateException();
            }
            if (!this.rset.hasDeleteMarkers()) {
                return false;
            }
            return this.rset.getDeleteMarker(this.lastVisited);
        }

        @Override
        public long getVisitCount() {
            return AbstractChunkedTupleIterator.this.nvisited;
        }

        @Override
        public ITupleSerializer getTupleSerializer() {
            return this.rset.getTupleSerializer();
        }

        @Override
        public IBlock readBlock(long addr) {
            int sourceIndex = this.getSourceIndex();
            return AbstractChunkedTupleIterator.this.readBlock(sourceIndex, addr);
        }

        public String toString() {
            return AbstractTuple.toString(this);
        }
    }
}

