/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.bop.solutions.SolutionSetStream;
import com.bigdata.btree.BTree;
import com.bigdata.btree.HTreeIndexMetadata;
import com.bigdata.btree.ICheckpoint;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.htree.HTree;
import com.bigdata.io.SerializerUtil;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.stream.Stream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;

public class Checkpoint
implements ICheckpoint,
Externalizable {
    private static final long serialVersionUID = -4308251060627051232L;
    transient long addrCheckpoint;
    private long addrMetadata;
    private long addrRoot;
    private int height;
    private long nnodes;
    private long nleaves;
    private long nentries;
    private long counter;
    private long addrBloomFilter;
    private long recordVersion;
    private IndexTypeEnum indexType;
    private static final transient int VERSION0 = 0;
    private static final transient int VERSION1 = 1;
    private static final transient int VERSION2 = 2;
    private static final transient int currentVersion = 2;

    @Override
    public final long getCheckpointAddr() {
        if (this.addrCheckpoint == 0L) {
            throw new IllegalStateException();
        }
        return this.addrCheckpoint;
    }

    @Override
    public final boolean hasCheckpointAddr() {
        return this.addrCheckpoint != 0L;
    }

    @Override
    public final long getMetadataAddr() {
        return this.addrMetadata;
    }

    @Override
    public final long getRootAddr() {
        return this.addrRoot;
    }

    @Override
    public final long getBloomFilterAddr() {
        return this.addrBloomFilter;
    }

    @Override
    public final int getHeight() {
        switch (this.indexType) {
            case BTree: {
                return this.height;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getGlobalDepth() {
        switch (this.indexType) {
            case HTree: {
                return this.height;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getNodeCount() {
        return this.nnodes;
    }

    @Override
    public final long getLeafCount() {
        return this.nleaves;
    }

    @Override
    public final long getEntryCount() {
        return this.nentries;
    }

    @Override
    public final long getCounter() {
        return this.counter;
    }

    @Override
    public final long getRecordVersion() {
        return this.counter;
    }

    @Override
    public final IndexTypeEnum getIndexType() {
        return this.indexType;
    }

    public final String toString() {
        return "Checkpoint{indexType=" + (Object)((Object)this.indexType) + (this.indexType == IndexTypeEnum.BTree ? ",height=" + this.height : (this.indexType == IndexTypeEnum.HTree ? ",globalDepth=" + this.height : "")) + ",nnodes=" + this.nnodes + ",nleaves=" + this.nleaves + ",nentries=" + this.nentries + ",counter=" + this.counter + ",addrRoot=" + this.addrRoot + ",addrMetadata=" + this.addrMetadata + ",addrBloomFilter=" + this.addrBloomFilter + ",addrCheckpoint=" + this.addrCheckpoint + "}";
    }

    public Checkpoint() {
    }

    public Checkpoint(IndexMetadata metadata) {
        this(metadata.getMetadataAddr(), 0L, 0L, 0, 0L, 0L, 0L, 0L, 0L, metadata.getIndexType());
    }

    public Checkpoint(IndexMetadata metadata, Checkpoint oldCheckpoint) {
        this(metadata.getMetadataAddr(), 0L, 0L, 0, 0L, 0L, 0L, oldCheckpoint.counter, 0L, metadata.getIndexType());
    }

    public Checkpoint(BTree btree) {
        this(btree.getMetadataAddr(), btree.getRootAddr(), btree.bloomFilter == null ? btree.getCheckpoint().getBloomFilterAddr() : (btree.bloomFilter.isEnabled() ? btree.bloomFilter.getAddr() : 0L), btree.height, btree.nnodes, btree.nleaves, btree.nentries, btree.counter.get(), btree.getRecordVersion(), IndexTypeEnum.BTree);
    }

    public Checkpoint(HTree htree) {
        this(htree.getMetadataAddr(), htree.getRootAddr(), 0L, 0, htree.getNodeCount(), htree.getLeafCount(), htree.getEntryCount(), htree.getCounter().get(), htree.getRecordVersion(), IndexTypeEnum.HTree);
    }

    public Checkpoint(Stream stream) {
        this(stream.getMetadataAddr(), stream.getRootAddr(), ((SolutionSetStream)stream).getStatsAddr(), 0, 0L, 0L, stream.rangeCount(), 0L, stream.getRecordVersion(), IndexTypeEnum.Stream);
    }

    private Checkpoint(long addrMetadata, long addrRoot, long addrBloomFilter, int height, long nnodes, long nleaves, long nentries, long counter, long recordVersion, IndexTypeEnum indexType) {
        assert (indexType != null);
        this.addrMetadata = addrMetadata;
        this.addrRoot = addrRoot;
        this.addrBloomFilter = addrBloomFilter;
        this.height = height;
        this.nnodes = nnodes;
        this.nleaves = nleaves;
        this.nentries = nentries;
        this.counter = counter;
        this.recordVersion = recordVersion;
        this.indexType = indexType;
    }

    public final void write(IRawStore store) {
        if (this.addrCheckpoint != 0L) {
            throw new IllegalStateException();
        }
        byte[] data = SerializerUtil.serialize(this);
        this.addrCheckpoint = store.write(ByteBuffer.wrap(data));
    }

    public static Checkpoint load(IRawStore store, long addrCheckpoint) {
        if (store == null) {
            throw new IllegalArgumentException();
        }
        ByteBuffer buf = store.read(addrCheckpoint);
        Checkpoint checkpoint = (Checkpoint)SerializerUtil.deserialize(buf);
        checkpoint.addrCheckpoint = addrCheckpoint;
        return checkpoint;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        switch (version) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Unknown version: " + version);
            }
        }
        this.addrMetadata = in.readLong();
        this.addrRoot = in.readLong();
        this.addrBloomFilter = in.readLong();
        this.height = in.readInt();
        if (version <= 1) {
            this.nnodes = in.readInt();
            this.nleaves = in.readInt();
            this.nentries = in.readInt();
            this.recordVersion = 0L;
        } else {
            this.nnodes = in.readLong();
            this.nleaves = in.readLong();
            this.nentries = in.readLong();
            this.recordVersion = in.readLong();
        }
        this.counter = in.readLong();
        switch (version) {
            case 0: {
                in.readLong();
                this.indexType = IndexTypeEnum.BTree;
                break;
            }
            case 1: 
            case 2: {
                this.indexType = IndexTypeEnum.valueOf(in.readShort());
                in.readShort();
                in.readInt();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        in.readLong();
        if (version >= 2) {
            for (int i = 0; i < 10; ++i) {
                in.readLong();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        out.writeLong(this.addrMetadata);
        out.writeLong(this.addrRoot);
        out.writeLong(this.addrBloomFilter);
        out.writeInt(this.height);
        out.writeLong(this.nnodes);
        out.writeLong(this.nleaves);
        out.writeLong(this.nentries);
        out.writeLong(this.recordVersion);
        out.writeLong(this.counter);
        out.writeShort(this.indexType.getCode());
        out.writeShort(0);
        out.writeInt(0);
        out.writeLong(0L);
        for (int i = 0; i < 10; ++i) {
            out.writeLong(0L);
        }
    }

    public static ICheckpointProtocol loadFromCheckpoint(IRawStore store, long checkpointAddr, boolean readOnly) {
        ICheckpointProtocol ndx;
        Checkpoint checkpoint;
        try {
            checkpoint = Checkpoint.load(store, checkpointAddr);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not load Checkpoint: store=" + store + ", addrCheckpoint=" + store.toString(checkpointAddr), t);
        }
        switch (checkpoint.getIndexType()) {
            case BTree: {
                ndx = BTree.load(store, checkpointAddr, readOnly);
                break;
            }
            case HTree: {
                ndx = HTree.load(store, checkpointAddr, readOnly);
                break;
            }
            case Stream: {
                ndx = Stream.load(store, checkpointAddr, readOnly);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown: " + (Object)((Object)checkpoint.getIndexType())));
            }
        }
        return ndx;
    }

    public static ICheckpointProtocol create(IRawStore store, IndexMetadata metadata) {
        ICheckpointProtocol ndx;
        switch (metadata.getIndexType()) {
            case BTree: {
                ndx = BTree.create(store, metadata);
                break;
            }
            case HTree: {
                ndx = HTree.create(store, (HTreeIndexMetadata)metadata);
                break;
            }
            case Stream: {
                ndx = Stream.create(store, (Stream.StreamIndexMetadata)metadata);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown: " + (Object)((Object)metadata.getIndexType())));
            }
        }
        return ndx;
    }
}

