/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.DumpIndex;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentMultiBlockIterator;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.Node;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.util.InnerCause;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DumpIndexSegment {
    protected static Logger log = Logger.getLogger(DumpIndexSegment.class);
    static final String bar = "============================================================";

    public static void usage() {
        System.err.println("usage: " + DumpIndexSegment.class.getSimpleName() + " [options] " + " file(s)");
        System.err.println("options:");
        System.err.println(" -d level: set the logger level");
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            DumpIndexSegment.usage();
            System.exit(1);
        }
        boolean dumpNodeState = false;
        boolean dumpLeafState = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.equals("-d")) {
                    Level level = Level.toLevel((String)args[++i]);
                    System.out.println("Setting log level: " + level);
                    try {
                        AbstractBTree.dumpLog.setLevel(level);
                        continue;
                    }
                    catch (Throwable t) {
                        if (InnerCause.isInnerCause(t, NoSuchMethodException.class)) {
                            log.error((Object)("Could not set log level : " + AbstractBTree.dumpLog.getName()));
                            continue;
                        }
                        throw new RuntimeException(t);
                    }
                }
                if (arg.equals("-nodeState")) {
                    dumpNodeState = true;
                    continue;
                }
                if (arg.equals("-leafState")) {
                    dumpLeafState = true;
                    continue;
                }
                System.err.println("Unknown option: " + arg);
                System.exit(1);
                continue;
            }
            File file = new File(arg);
            if (!file.exists()) {
                System.err.println("No such file: " + file);
                continue;
            }
            DumpIndexSegment.dumpIndexSegment(file, dumpNodeState, dumpLeafState);
        }
    }

    static void dumpIndexSegment(File file, boolean dumpNodeState, boolean dumpLeafState) throws IOException {
        boolean fastForwardScan;
        boolean fastReverseScan;
        boolean multiBlockScan;
        IndexSegmentStore store = new IndexSegmentStore(file);
        DumpIndexSegment.dumpHeaders(store);
        AbstractNode<?> root = store.loadIndexSegment().getRoot();
        if (root instanceof Node) {
            DumpIndexSegment.writeBanner("dump nodes");
            DumpIndexSegment.dumpNodes(store, (Node)root, dumpNodeState);
        }
        if (multiBlockScan = false) {
            DumpIndexSegment.writeBanner("dump leaves using multi-block forward scan");
            DumpIndexSegment.dumpLeavesMultiBlockForwardScan(store);
        }
        if (fastReverseScan = true) {
            DumpIndexSegment.writeBanner("dump leaves using fast reverse scan");
            DumpIndexSegment.dumpLeavesReverseScan(store, dumpLeafState);
        }
        if (fastForwardScan = true) {
            DumpIndexSegment.writeBanner("dump leaves using fast forward scan");
            DumpIndexSegment.dumpLeavesForwardScan(store, dumpLeafState);
        }
        boolean entryScan = true;
        boolean showTuples = false;
        if (entryScan) {
            DumpIndexSegment.writeBanner("dump keys and values using iterator");
            DumpIndex.dumpIndex(store.loadIndexSegment(), showTuples);
        }
    }

    static void dumpHeaders(IndexSegmentStore store) throws IOException {
        System.out.println("file        : " + store.getFile());
        System.out.println("checkpoint  : " + store.getCheckpoint().toString());
        System.out.println("metadata    : " + store.getIndexMetadata().toString());
        System.out.println("bloomFilter : " + (store.getCheckpoint().addrBloom != 0L ? store.readBloomFilter().toString() : "N/A"));
    }

    static void dumpNodes(IndexSegmentStore store, Node node, boolean dumpNodeState) {
        if (dumpNodeState) {
            node.dump(System.out);
        }
        int nkeys = node.getKeyCount();
        for (int i = 0; i <= nkeys; ++i) {
            long addr = node.getChildAddr(i);
            if (!store.getAddressManager().isNodeAddr(addr)) continue;
            Node child = (Node)node.getChild(i);
            DumpIndexSegment.dumpNodes(store, child, dumpNodeState);
        }
    }

    static long getFirstLeafAddr(IndexSegmentStore store, long addr) {
        if (store.getAddressManager().isNodeAddr(addr)) {
            ByteBuffer data = store.read(addr);
            IndexSegment btree = store.loadIndexSegment();
            Node child = (Node)DumpIndexSegment.decode(btree, addr, data);
            return DumpIndexSegment.getFirstLeafAddr(store, child.getChildAddr(0));
        }
        return addr;
    }

    static AbstractNode<?> decode(AbstractBTree btree, long addr, ByteBuffer buf) {
        return btree.nodeSer.wrap(btree, addr, btree.nodeSer.decode(buf));
    }

    static long getLastLeafAddr(IndexSegmentStore store, long addr) {
        if (store.getAddressManager().isNodeAddr(addr)) {
            ByteBuffer data = store.read(addr);
            IndexSegment btree = store.loadIndexSegment();
            Node child = (Node)DumpIndexSegment.decode(btree, addr, data);
            return DumpIndexSegment.getLastLeafAddr(store, child.getChildAddr(child.getKeyCount()));
        }
        return addr;
    }

    static void dumpLeavesReverseScan(IndexSegmentStore store, boolean dumpLeafState) {
        long begin = System.currentTimeMillis();
        IndexSegment btree = store.loadIndexSegment();
        long addr = store.getCheckpoint().addrLastLeaf;
        System.out.println("lastLeafAddr=" + store.toString(addr));
        long addr2 = DumpIndexSegment.getLastLeafAddr(store, store.getCheckpoint().addrRoot);
        if (addr != addr2) {
            log.error((Object)("Last leaf address is inconsistent? checkpoint reports: " + addr + " (" + store.toString(addr) + ")" + ", but node hierarchy reports " + addr2 + " (" + store.toString(addr2) + ")"));
        }
        int nscanned = 0;
        while (true) {
            if (!store.getAddressManager().isLeafAddr(addr)) {
                log.error((Object)("Not a leaf address: " + store.toString(addr) + " : aborting scan"));
                break;
            }
            ByteBuffer data = store.read(addr);
            Leaf leaf = (Leaf)DumpIndexSegment.decode(btree, addr, data);
            if (dumpLeafState) {
                leaf.dump(System.out);
            }
            ++nscanned;
            long priorAddr = ((IndexSegment.ImmutableNodeFactory.ImmutableLeaf)leaf).getPriorAddr();
            if (priorAddr == -1L) {
                log.error((Object)("Expecting the prior address to be known - aborting scan: current addr=" + addr + " (" + store.toString(addr) + ")"));
                break;
            }
            if (priorAddr == 0L) {
                if (nscanned == store.getCheckpoint().nleaves) break;
                log.error((Object)("Scanned " + nscanned + " leaves, but checkpoint record indicates that there are " + store.getCheckpoint().nleaves + " leaves"));
                break;
            }
            addr = priorAddr;
        }
        long elapsed = System.currentTimeMillis() - begin;
        System.out.println("Visited " + nscanned + " leaves using fast reverse scan in " + elapsed + " ms");
    }

    static void dumpLeavesForwardScan(IndexSegmentStore store, boolean dumpLeafState) {
        long begin = System.currentTimeMillis();
        IndexSegment btree = store.loadIndexSegment();
        long addr = store.getCheckpoint().addrFirstLeaf;
        long addr2 = DumpIndexSegment.getFirstLeafAddr(store, store.getCheckpoint().addrRoot);
        if (addr != addr2) {
            log.error((Object)("First leaf address is inconsistent? checkpoint reports: " + addr + " (" + store.toString(addr) + ")" + ", but node hierarchy reports " + addr2 + " (" + store.toString(addr2) + ")"));
        }
        System.out.println("firstLeafAddr=" + store.toString(addr));
        int nscanned = 0;
        while (true) {
            if (!store.getAddressManager().isLeafAddr(addr)) {
                log.error((Object)("Not a leaf address: " + store.toString(addr) + " : aborting scan"));
                break;
            }
            ByteBuffer data = store.read(addr);
            Leaf leaf = (Leaf)DumpIndexSegment.decode(btree, addr, data);
            if (dumpLeafState) {
                leaf.dump(System.out);
            }
            ++nscanned;
            long nextAddr = ((IndexSegment.ImmutableNodeFactory.ImmutableLeaf)leaf).getNextAddr();
            if (nextAddr == -1L) {
                log.error((Object)("Expecting the next address to be known - aborting scan: current addr=" + addr + " (" + store.toString(addr) + ")"));
                break;
            }
            if (nextAddr == 0L) {
                if (nscanned == store.getCheckpoint().nleaves) break;
                log.error((Object)("Scanned " + nscanned + " leaves, but checkpoint record indicates that there are " + store.getCheckpoint().nleaves + " leaves"));
                break;
            }
            addr = nextAddr;
        }
        long elapsed = System.currentTimeMillis() - begin;
        System.out.println("Visited " + nscanned + " leaves using fast forward scan in " + elapsed + " ms");
    }

    static void dumpLeavesMultiBlockForwardScan(IndexSegmentStore store) {
        long begin = System.currentTimeMillis();
        IndexSegment seg = store.loadIndexSegment();
        IndexSegmentMultiBlockIterator itr = new IndexSegmentMultiBlockIterator(seg, DirectBufferPool.INSTANCE, null, null, 3);
        int nscanned = 0;
        while (itr.hasNext()) {
            itr.next();
            ++nscanned;
        }
        long elapsed = System.currentTimeMillis() - begin;
        System.out.println("Visited " + nscanned + " tuples using multi-block forward scan in " + elapsed + " ms");
    }

    static void writeBanner(String s) {
        System.out.println(bar);
        System.out.println("=== " + s);
        System.out.println(bar);
    }
}

