/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ISimpleSplitHandler;
import com.bigdata.btree.IndexSegment;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class FixedLengthPrefixSplits
implements ISimpleSplitHandler,
Serializable,
Externalizable {
    protected static final transient Logger log = Logger.getLogger(FixedLengthPrefixSplits.class);
    private static final long serialVersionUID = -4873807205429701805L;
    private int N;

    public FixedLengthPrefixSplits(int nbytes) {
        if (nbytes <= 0) {
            throw new IllegalArgumentException();
        }
        this.N = nbytes;
    }

    @Override
    public byte[] getSeparatorKey(IndexSegment seg, int fromIndex, int toIndex, int splitAt) {
        int N = this.N;
        byte[] a = seg.keyAt(splitAt);
        for (int i = splitAt + 1; i < toIndex; ++i) {
            byte[] b = seg.keyAt(i);
            int cmp = BytesUtil.compareBytesWithLenAndOffset(0, 8, a, 0, 8, b);
            assert (cmp <= 0);
            if (cmp >= 0) continue;
            byte[] prefix = new byte[N];
            System.arraycopy(b, 0, prefix, 0, N);
            if (log.isInfoEnabled()) {
                log.info((Object)("Found: prefix=" + BytesUtil.toString(prefix) + ", splitAt=" + splitAt + ", i=" + i));
            }
            return prefix;
        }
        log.warn((Object)("No successor: nbytes=" + N + ", splitAt=" + splitAt));
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.N = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.N);
    }
}

