/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.btree.LeafTupleIterator;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.IBufferAccess;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class IndexSegmentMultiBlockIterator<E>
implements ITupleIterator<E> {
    protected static final transient Logger log = Logger.getLogger(IndexSegmentMultiBlockIterator.class);
    private final IndexSegment seg;
    private final IndexSegmentStore store;
    private final DirectBufferPool pool;
    private volatile IBufferAccess buffer;
    private final byte[] fromKey;
    private final byte[] toKey;
    private boolean exhausted = false;
    private final Tuple<E> tuple;
    private LeafTupleIterator<E> tupleItr = null;
    private final long firstLeafAddr;
    private final long lastLeafAddr;
    private IndexSegment.ImmutableNodeFactory.ImmutableLeaf currentLeaf = null;
    private long blockOffset = 0L;
    private int blockLength = 0;
    private long leafReadCount = 0L;
    private long blockReadCount = 0L;

    public IndexSegmentMultiBlockIterator(IndexSegment seg, DirectBufferPool pool, byte[] fromKey, byte[] toKey, int flags) {
        if (seg == null) {
            throw new IllegalArgumentException();
        }
        if (pool == null) {
            throw new IllegalArgumentException();
        }
        this.seg = seg;
        this.store = seg.getStore();
        this.pool = pool;
        this.fromKey = fromKey;
        this.toKey = toKey;
        if ((flags & 0x40) != 0) {
            throw new IllegalArgumentException();
        }
        if ((flags & 0x10) != 0) {
            throw new IllegalArgumentException();
        }
        if ((flags & 0x20) != 0) {
            throw new IllegalArgumentException();
        }
        this.tuple = new Tuple(seg, flags);
        this.firstLeafAddr = fromKey == null ? this.store.getCheckpoint().addrFirstLeaf : seg.findLeafAddr(fromKey);
        long l = this.lastLeafAddr = toKey == null ? this.store.getCheckpoint().addrLastLeaf : seg.findLeafAddr(toKey);
        if (pool.getBufferCapacity() < this.store.getCheckpoint().maxNodeOrLeafLength) {
            throw new UnsupportedOperationException("Record is larger than buffer: maxNodeOrLeafLength=" + this.store.getCheckpoint().maxNodeOrLeafLength + ", bufferCapacity=" + pool.getBufferCapacity());
        }
        if (this.firstLeafAddr == 0L) {
            this.exhausted = true;
        }
        this.blockOffset = 0L;
        this.blockLength = 0;
    }

    protected void finalize() throws Throwable {
        this.releaseBuffer();
        super.finalize();
    }

    private ByteBuffer acquireBuffer() {
        if (this.buffer == null) {
            try {
                this.buffer = this.pool.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.buffer.buffer();
    }

    private void releaseBuffer() {
        if (this.buffer != null) {
            try {
                this.buffer.release();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            this.buffer = null;
        }
    }

    protected IndexSegment.ImmutableNodeFactory.ImmutableLeaf getLeaf() {
        return this.currentLeaf;
    }

    @Override
    public boolean hasNext() {
        return this._hasNext();
    }

    @Override
    public ITuple<E> next() {
        if (this.exhausted) {
            throw new NoSuchElementException();
        }
        return this.tupleItr.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean _hasNext() {
        while (!this.exhausted) {
            if (this.tupleItr != null) {
                if (this.tupleItr.hasNext()) {
                    return true;
                }
                this.tupleItr = null;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Current leaf is exhausted.");
                }
            }
            if ((this.currentLeaf = this.nextLeaf()) != null) {
                this.tupleItr = new LeafTupleIterator<E>(this.currentLeaf, this.tuple, this.fromKey, this.toKey);
                continue;
            }
            this.exhausted = true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exhausted.");
        }
        this.releaseBuffer();
        return false;
    }

    private IndexSegment.ImmutableNodeFactory.ImmutableLeaf nextLeaf() {
        if (this.exhausted) {
            throw new IllegalStateException();
        }
        if (this.currentLeaf == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Reading initial leaf");
            }
            this.acquireBuffer();
            this.nextBlock(this.firstLeafAddr, this.buffer.buffer());
            IndexSegment.ImmutableNodeFactory.ImmutableLeaf leaf = this.getLeaf(this.firstLeafAddr);
            return leaf;
        }
        if (this.currentLeaf.identity == this.lastLeafAddr) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No more leaves (end of key range)");
            }
            return null;
        }
        long nextLeafAddr = this.currentLeaf.getNextAddr();
        if (nextLeafAddr == 0L) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No more leaves (end of segment)");
            }
            return null;
        }
        long offset = this.store.getOffset(nextLeafAddr);
        int nbytes = this.store.getByteCount(nextLeafAddr);
        if (offset < this.blockOffset) {
            throw new AssertionError();
        }
        if (offset + (long)nbytes > this.blockOffset + (long)this.blockLength) {
            this.nextBlock(nextLeafAddr, this.buffer.buffer());
        }
        IndexSegment.ImmutableNodeFactory.ImmutableLeaf leaf = this.getLeaf(nextLeafAddr);
        return leaf;
    }

    private IndexSegment.ImmutableNodeFactory.ImmutableLeaf getLeaf(long addr) {
        long offset = this.store.getOffset(addr);
        int nbytes = this.store.getByteCount(addr);
        if (offset < this.blockOffset) {
            throw new IllegalArgumentException();
        }
        if (offset + (long)nbytes > this.blockOffset + (long)this.blockLength) {
            throw new IllegalArgumentException();
        }
        int offsetWithinBuffer = (int)(offset - this.blockOffset);
        ByteBuffer tmp = this.buffer.buffer().asReadOnlyBuffer();
        tmp.limit(offsetWithinBuffer + nbytes);
        tmp.position(offsetWithinBuffer);
        ILeafData data = (ILeafData)this.seg.nodeSer.decode(tmp);
        ++this.leafReadCount;
        if (log.isTraceEnabled()) {
            log.trace((Object)("read leaf: leafReadCount=" + this.leafReadCount + ", addr=" + addr + "(" + this.store.toString(addr) + "), blockOffset=" + this.blockOffset + " offsetWithinBuffer=" + offsetWithinBuffer));
        }
        return new IndexSegment.ImmutableNodeFactory.ImmutableLeaf(this.seg, addr, data);
    }

    private void nextBlock(long leafAddr, ByteBuffer b) {
        int minSize = this.store.getByteCount(leafAddr);
        if (minSize > b.capacity()) {
            throw new UnsupportedOperationException("Leaf is larger than buffer: leafSize=" + minSize + ", bufferCapacity=" + b.capacity());
        }
        long startOffset = this.store.getOffset(leafAddr);
        long lastOffset = this.store.getOffset(this.lastLeafAddr) + (long)this.store.getByteCount(this.lastLeafAddr);
        int nbytes = (int)Math.min(lastOffset - startOffset, (long)b.capacity());
        if (log.isTraceEnabled()) {
            log.trace((Object)("leafAddr=" + this.store.toString(leafAddr) + ", startOffset=" + startOffset + ", lastOffset=" + lastOffset + ", nbytes=" + nbytes));
        }
        if (nbytes == 0) {
            throw new AssertionError((Object)("nbytes=0 : leafAddr" + this.store.toString(leafAddr) + " : " + this));
        }
        b.position(0);
        b.limit(nbytes);
        try {
            this.store.readFromFile(startOffset, b);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.blockOffset = startOffset;
        this.blockLength = nbytes;
        ++this.blockReadCount;
        if (log.isTraceEnabled()) {
            log.trace((Object)("read block: blockReadCount=" + this.blockReadCount + ", leafAddr=" + this.store.toString(leafAddr) + ", blockOffset=" + this.blockOffset + ", blockLength=" + this.blockLength));
        }
    }

    public String toString() {
        return super.toString() + "{file=" + this.store.getFile() + ",checkpoint=" + this.store.getCheckpoint() + ",fromKey=" + BytesUtil.toString(this.fromKey) + ",toKey=" + BytesUtil.toString(this.toKey) + ",firstLeafAddr=" + this.store.toString(this.firstLeafAddr) + ",lastLeafAddr=" + this.store.toString(this.lastLeafAddr) + ",currentLeaf=" + (this.currentLeaf != null ? this.store.toString(this.currentLeaf.identity) : "N/A") + ",blockOffset=" + this.blockOffset + ",blockLength=" + this.blockLength + ",bufferCapacity=" + this.pool.getBufferCapacity() + ",leafReadCount=" + this.leafReadCount + ",blockReadCount=" + this.blockReadCount + "}";
    }
}

