/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.IBloomFilter;
import com.bigdata.btree.ICounter;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IKeyRangeIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.counters.CounterSet;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.IResourceManager;
import com.bigdata.mdi.IResourceMetadata;
import cutthecrap.utils.striterators.IFilter;

public class ReadCommittedView
implements ILocalBTreeView {
    private final IResourceManager resourceManager;
    private final String name;
    private volatile Basis basis;

    private synchronized BTree getIndex() {
        AbstractJournal journal = this.resourceManager.getLiveJournal();
        if (journal != this.basis.journal || journal.getLastCommitTime() != this.basis.commitRecord.getTimestamp()) {
            this.basis = new Basis(journal, this.name);
        }
        assert (this.basis.btree.isReadOnly());
        return this.basis.btree;
    }

    public ReadCommittedView(IResourceManager resourceManager, String name) {
        if (resourceManager == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.resourceManager = resourceManager;
        this.name = name;
        this.basis = new Basis(resourceManager.getLiveJournal(), name);
    }

    @Override
    public ICounter getCounter() {
        return this.getIndex().getCounter();
    }

    @Override
    public CounterSet getCounters() {
        return this.getIndex().getCounters();
    }

    @Override
    public IndexMetadata getIndexMetadata() {
        return this.getIndex().getIndexMetadata();
    }

    @Override
    public IResourceMetadata[] getResourceMetadata() {
        return this.getIndex().getResourceMetadata();
    }

    @Override
    public boolean contains(byte[] key) {
        return this.getIndex().contains(key);
    }

    @Override
    public boolean contains(Object key) {
        return this.getIndex().contains(key);
    }

    @Override
    public byte[] lookup(byte[] key) {
        return this.getIndex().lookup(key);
    }

    @Override
    public Object lookup(Object key) {
        return this.getIndex().lookup(key);
    }

    @Override
    public byte[] remove(byte[] key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] insert(byte[] key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object insert(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long rangeCount() {
        return this.getIndex().rangeCount();
    }

    @Override
    public long rangeCount(byte[] fromKey, byte[] toKey) {
        return this.getIndex().rangeCount(fromKey, toKey);
    }

    @Override
    public long rangeCountExact(byte[] fromKey, byte[] toKey) {
        return this.getIndex().rangeCountExact(fromKey, toKey);
    }

    @Override
    public long rangeCountExactWithDeleted(byte[] fromKey, byte[] toKey) {
        return this.getIndex().rangeCountExactWithDeleted(fromKey, toKey);
    }

    @Override
    public ITupleIterator rangeIterator() {
        return this.getIndex().rangeIterator();
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filterCtor) {
        return this.getIndex().rangeIterator(fromKey, toKey, capacity, flags, filterCtor);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey) {
        return this.getIndex().rangeIterator(fromKey, toKey);
    }

    @Override
    public void submit(byte[] fromKey, byte[] toKey, IKeyRangeIndexProcedure proc, IResultHandler handler) {
        this.getIndex().submit(fromKey, toKey, proc, handler);
    }

    @Override
    public Object submit(byte[] key, ISimpleIndexProcedure proc) {
        return this.getIndex().submit(key, proc);
    }

    @Override
    public void submit(int fromIndex, int toIndex, byte[][] keys, byte[][] vals, AbstractKeyArrayIndexProcedureConstructor ctor, IResultHandler resultHandler) {
        this.getIndex().submit(fromIndex, toIndex, keys, vals, ctor, resultHandler);
    }

    @Override
    public IBloomFilter getBloomFilter() {
        return this.getIndex().getBloomFilter();
    }

    @Override
    public BTree getMutableBTree() {
        return this.getIndex().getMutableBTree();
    }

    @Override
    public int getSourceCount() {
        return this.getIndex().getSourceCount();
    }

    @Override
    public AbstractBTree[] getSources() {
        return this.getIndex().getSources();
    }

    private static class Basis {
        final AbstractJournal journal;
        final ICommitRecord commitRecord;
        final BTree btree;

        public Basis(AbstractJournal journal, String name) {
            this.journal = journal;
            this.commitRecord = journal.getCommitRecord();
            this.btree = (BTree)journal.getIndexWithCommitRecord(name, this.commitRecord);
        }
    }
}

